const path = require('path')

const resolve = dir => {
  return path.join(__dirname, dir)
}
const webpack = require('webpack')
// 增加环境变量
process.env.VUE_APP_VERSION = require('./package.json').version;
process.env.VUE_APP_BUILD_TIME = require('dayjs')().format('YYYY-M-D HH:mm:ss');

export default {
  mode: 'spa',
  /*
   ** Headers of the page
   */
  head: {
    title: process.env.npm_package_name || '',
    meta: [{
        charset: 'utf-8'
      },
      {
        name: 'viewport',
        content: 'width=device-width, initial-scale=1'
      },
      {
        hid: 'description',
        name: 'description',
        content: process.env.npm_package_description || ''
      }
    ],
    link: [{
      rel: 'icon',
      type: 'image/x-icon',
      href: '/favicon.ico'
    }]
  },
  /*
   ** Customize the progress-bar color
   */
  loading: {
    color: '#fff'
  },
  /*
   ** Global CSS
   */
  css: [
    // './libs/iview-pro/iview-pro.css',
    // {
    //   src: '@/styles/index.less',
    //   lang: 'less'
    // },
  ],
  /*
   ** Plugins to load before mounting the App
   */
  plugins: [
    '@/plugins/iview'
  ],
  /*
   ** Nuxt.js dev-modules
   */
  buildModules: [],
  /*
   ** Nuxt.js modules
   */
  modules: [
    // Doc: https://axios.nuxtjs.org/usage
    '@nuxtjs/axios',
  ],
  /*
   ** Axios module configuration
   ** See https://axios.nuxtjs.org/options
   */
  axios: {},
  /*
   ** Build configuration
   */
  build: {
    /*
    ** You can extend webpack config here
    */
  //  loaders:{
  //   less:{
  //     javascriptEnabled:true
  //   }
  //  },
    extend (config, ctx) {
      // config.resolve.alias['_c']=path.resolve(__dirname, 'components')
      // config.module.rules.push({
      //   enforce:'pre',
      //   test: /\.vue$/,
      //   loader: 'iview-loader',
      //   options: {
      //     prefix: false
      // }
      // });
    }
    // ,
  //   chainWebpack: config => {
  //     // 不编译 iView Pro
  //     config.module
  //     .rule('js')
  //     .test(/\.jsx?$/)
  //     .exclude
  //     .add(path.resolve(__dirname,'libs/iview-pro'))
  //     .end();
  // },
  // ,plugins: [
  //   new webpack.ProvidePlugin({'window.Quill':'quill' })
  // ]
  }
 
}
