﻿using System;
using System.Collections.Generic;
using System.Management;
using System.Net;
using System.Net.NetworkInformation;
using System.Net.Sockets;
using System.Text;

namespace HYH.Registry.Services.Encryption
{
    /// <summary>
    /// 
    /// </summary>
    public static class ComputerInfoHelper
    {
        /// <summary>
        /// 获取电脑 MAC（物理） 地址
        /// </summary>
        /// <returns></returns>
        public static string GetMACAddress()
        {
            //获取本机所有网络连接
            NetworkInterface[] nics = NetworkInterface.GetAllNetworkInterfaces();

            if (nics == null || nics.Length < 1)
            {
                return "";
            }

            var MACIp = "";
            foreach (NetworkInterface adapter in nics)
            {
                string macip = "";
                var adapterName = adapter.Name;
                //var adapterDescription = adapter.Description;
                //var NetworkInterfaceType = adapter.NetworkInterfaceType;

                PhysicalAddress address = adapter.GetPhysicalAddress();
                byte[] bytes = address.GetAddressBytes();

                for (int i = 0; i < bytes.Length; i++)
                {
                    macip += bytes[i].ToString("X2");

                    if (i != bytes.Length - 1)
                    {
                        macip += ":";
                    }
                }
                if (adapter.OperationalStatus == OperationalStatus.Up && !string.IsNullOrEmpty(adapterName) && !string.IsNullOrEmpty(macip))
                {
                    MACIp += macip;
                    break;
                }
            }

            return MACIp;
        }
        //获取硬盘序列号
        public static string GetHardDiskSerialNumber()
        {
            try
            {
                ManagementObjectSearcher searcher = new ManagementObjectSearcher("SELECT * FROM Win32_PhysicalMedia");
                string sHardDiskSerialNumber = "";
                foreach (ManagementObject mo in searcher.Get())
                {
                    sHardDiskSerialNumber = mo["SerialNumber"].ToString().Trim();
                    break;
                }
                return sHardDiskSerialNumber;
            }
            catch
            {
                return "";
            }
        }


        //获取网卡地址
        public static string GetNetCardMACAddress()
        {
            try
            {
                ManagementObjectSearcher searcher = new ManagementObjectSearcher("SELECT * FROM Win32_NetworkAdapter WHERE ((MACAddress Is Not NULL) AND (Manufacturer <> 'Microsoft'))");
                string NetCardMACAddress = "";
                foreach (ManagementObject mo in searcher.Get())
                {
                    NetCardMACAddress = mo["MACAddress"].ToString().Trim();
                    break;
                }
                return NetCardMACAddress;
            }
            catch
            {
                return "";
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public static string GetHostName()
        {
            IPGlobalProperties computerProperties = IPGlobalProperties.GetIPGlobalProperties();
            //获取本机电脑名
            var HostName = computerProperties.HostName;
            //获取域名
            var DomainName = computerProperties.DomainName;
            return "电脑名：" + HostName + ",域名:" + DomainName;
        }
        public static string PrintAllMacAddress()
        {
            const int MIN_MAC_ADDR_LENGTH = 12;
            string macAddress = string.Empty;
            long maxSpeed = -1;

            foreach (NetworkInterface nic in NetworkInterface.GetAllNetworkInterfaces())
            {
                Console.WriteLine(
                    "Name: " + nic.Name +
                    " Found MAC Address: " + nic.GetPhysicalAddress() +
                    " Type: " + nic.NetworkInterfaceType);

                string tempMac = nic.GetPhysicalAddress().ToString();
                if (nic.Speed > maxSpeed &&
                    !string.IsNullOrEmpty(tempMac) &&
                    tempMac.Length >= MIN_MAC_ADDR_LENGTH)
                {
                    Console.WriteLine("New Max Speed = " + nic.Speed + ", MAC: " + tempMac);
                    maxSpeed = nic.Speed;
                    macAddress = "Name: " + nic.Name +
                    " Found MAC Address: " + tempMac +
                    " Type: " + nic.NetworkInterfaceType;
                }
            }

            return macAddress;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public static string GetFirstMacAddress()
        {
            string macAddresses = string.Empty;

            foreach (NetworkInterface nic in NetworkInterface.GetAllNetworkInterfaces())
            {
                if (nic.OperationalStatus == OperationalStatus.Up)
                {
                    macAddresses += nic.GetPhysicalAddress().ToString();
                    Console.WriteLine(macAddresses);
                    break;
                }
            }

            return macAddresses;
        }
        /// <summary>
        /// 获取电脑 MAC（物理） 地址
        /// </summary>
        /// <returns></returns>
        public static string GetMACIp()
        {
            //获取本机所有网络连接
            NetworkInterface[] nics = NetworkInterface.GetAllNetworkInterfaces();

            if (nics == null || nics.Length < 1)
            {
                return "";
            }

            var MACIp = "";
            foreach (NetworkInterface adapter in nics)
            {
                string macip = "";
                var adapterName = adapter.Name;

                var adapterDescription = adapter.Description;
                var NetworkInterfaceType = adapter.NetworkInterfaceType;
                //if (adapterName.Contains("本地连接"))
                //{
                PhysicalAddress address = adapter.GetPhysicalAddress();
                byte[] bytes = address.GetAddressBytes();

                for (int i = 0; i < bytes.Length; i++)
                {
                    macip += bytes[i].ToString("X2");

                    if (i != bytes.Length - 1)
                    {
                        macip += "-";
                    }
                }
                //}
  
                MACIp += "[" + adapterName + ":" + macip + "-" + adapterDescription + "-" + NetworkInterfaceType + "] ";
            }

            return MACIp;
        }
        //public static string GetHostName()
        //{
        //    //获取本机所有网络连接
        //    NetworkInterface[] nics = NetworkInterface.GetAllNetworkInterfaces();
        //    foreach (NetworkInterface adapter in nics)
        //    {
        //        var fdd = adapter.GetIPProperties();
        //        fdd.GetIPv4Properties
        //    }
        //}
        //public static string GetIPv4()
        //{
        //获取内网IP
        public static IPAddress GetInternalIP()
        {
            NetworkInterface[] nics = NetworkInterface.GetAllNetworkInterfaces();

            foreach (NetworkInterface adapter in nics)
            {
                foreach (var uni in adapter.GetIPProperties().UnicastAddresses)
                {
                    if (uni.Address.AddressFamily == AddressFamily.InterNetwork)
                    {
                        return uni.Address;
                    }
                }
            }
            return null;
        }
        //}

    }
}
