﻿using Abp.AspNetCore;
using Abp.AspNetCore.Configuration;
using Abp.Modules;
using Abp.Reflection.Extensions;
using HYH.AspNetCore;
using HYH.Registry.EntityFrameworkCore;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;

namespace HYH.Registry.Web.Host.Startup
{
    [DependsOn(
         typeof(RegistryApplicationModule),
         typeof(RegistryEntityFrameworkCoreModule),
         typeof(AbpAspNetCoreModule),
         typeof(WebHostModule))
     ]
    public class RegistryWebHostModule : AbpModule
    {
        private readonly IHostingEnvironment _env;
        private readonly IConfiguration _appConfiguration;

        public RegistryWebHostModule(IHostingEnvironment env, IConfiguration configuration)
        {
            _env = env;
            _appConfiguration = configuration;
        }

        public override void Initialize()
        {
            IocManager.RegisterAssemblyByConvention(typeof(RegistryWebHostModule).GetAssembly());
        }

        public override void PreInitialize()
        {
            Configuration.DefaultNameOrConnectionString = _appConfiguration.GetConnectionString(
                RegistryConsts.ConnectionStringName
            );


            Configuration.Modules.AbpAspNetCore()
                 .CreateControllersForAppServices(
                     typeof(RegistryApplicationModule).GetAssembly()
                 );
        }
    }
}
