﻿using HYH.Registry.Configuration;
using HYH.Registry.Web;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Design;
using Microsoft.Extensions.Configuration;

namespace HYH.Registry.EntityFrameworkCore
{
    /* This class is needed to run EF Core PMC commands. Not used anywhere else */
    public class RegistryDbContextFactory : IDesignTimeDbContextFactory<RegistryDbContext>
    {
        public RegistryDbContext CreateDbContext(string[] args)
        {
            var builder = new DbContextOptionsBuilder<RegistryDbContext>();
            var configuration = AppConfigurations.Get(WebContentDirectoryFinder.CalculateContentRootFolder());

            DbContextOptionsConfigurer.Configure(
                builder,
                configuration.GetConnectionString(RegistryConsts.ConnectionStringName)
            );

            return new RegistryDbContext(builder.Options);
        }
    }
}