using System;
using Abp.Domain.Entities.Auditing;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
namespace HYH.Registry.DbModels
{
    /// <summary>
    /// author: henq
    /// time: 2019/12/4 14:13:34
    ///
    ///</summary>
    [Table("MaterialPowder")]
    public class MaterialPowder: FullAuditedEntity
    {
/// <summary>
/// 编码
/// </summary>
[StringLength(200)]
public string Coding { get; set; }
/// <summary>
/// 名称
/// </summary>
[StringLength(200)]
public string Name { get; set; }
/// <summary>
/// 牌号
/// </summary>
[StringLength(200)]
public string Brand { get; set; }
/// <summary>
/// 规格
/// </summary>
[StringLength(200)]
public string Specifications { get; set; }
/// <summary>
/// 原厂家
/// </summary>
[StringLength(200)]
[Column("original_manufacturer")]
public string OriginalManufacturer { get; set; }
/// <summary>
/// 批次号
/// </summary>
[StringLength(200)]
[Column("batch_no")]
public string BatchNo { get; set; }
/// <summary>
/// 剩余量（kg）
/// </summary>
[Column("remaining_amount")]
public double RemainingAmount { get; set; }
/// <summary>
/// 入库总量（kg）
/// </summary>
[Column("total_inventory")]
public double TotalInventory { get; set; }
/// <summary>
/// 单价（元/kg）
/// </summary>
[StringLength(200)]
[Column("unit_price")]
public string UnitPrice { get; set; }
/// <summary>
/// 合格证
/// </summary>
[StringLength(200)]
[Column("certificate_of_approval")]
public string CertificateOfApproval { get; set; }
/// <summary>
/// 库房库位
/// </summary>
[Column("store_id")]
public int StoreId { get; set; }
/// <summary>
/// 位置
/// </summary>
[StringLength(200)]
public string Location { get; set; }
/// <summary>
/// 类别
/// </summary>
public Int16 Category { get; set; }
/// <summary>
/// 复验日期
/// </summary>
[Column("reinspection_date")]
public DateTime ReinspectionDate { get; set; }
/// <summary>
/// 复验状态
/// </summary>
[StringLength(200)]
[Column("reinspection_status")]
public string ReinspectionStatus { get; set; }
    }
    }