using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using HYH.Registry.Core;
namespace HYH.Registry.Dtos
{
    /// <summary>
    /// author: henq
    /// time: 2019/12/4 14:13:34
    ///
    ///</summary>

    #region Dto
    public class MaterialPowderDto: BaseEntity
    {
/// <summary>
/// 编码
/// </summary>
[StringLength(200)]
public string Coding { get; set; }
/// <summary>
/// 名称
/// </summary>
[StringLength(200)]
public string Name { get; set; }
/// <summary>
/// 牌号
/// </summary>
[StringLength(200)]
public string Brand { get; set; }
/// <summary>
/// 规格
/// </summary>
[StringLength(200)]
public string Specifications { get; set; }
/// <summary>
/// 原厂家
/// </summary>
[StringLength(200)]
public string OriginalManufacturer { get; set; }
/// <summary>
/// 批次号
/// </summary>
[StringLength(200)]
public string BatchNo { get; set; }
/// <summary>
/// 剩余量（kg）
/// </summary>
public double RemainingAmount { get; set; }
/// <summary>
/// 入库总量（kg）
/// </summary>
public double TotalInventory { get; set; }
/// <summary>
/// 单价（元/kg）
/// </summary>
[StringLength(200)]
public string UnitPrice { get; set; }
/// <summary>
/// 合格证
/// </summary>
[StringLength(200)]
public string CertificateOfApproval { get; set; }
/// <summary>
/// 库房库位
/// </summary>
public int StoreId { get; set; }
/// <summary>
/// 位置
/// </summary>
[StringLength(200)]
public string Location { get; set; }
/// <summary>
/// 类别
/// </summary>
public Int16 Category { get; set; }
/// <summary>
/// 复验日期
/// </summary>
public DateTime ReinspectionDate { get; set; }
/// <summary>
/// 复验状态
/// </summary>
[StringLength(200)]
public string ReinspectionStatus { get; set; }

    }
    #endregion
    #region CreateDto
    public class MaterialPowderCreateDto: BaseEntity
    {
/// <summary>
/// 编码
/// </summary>
[StringLength(200)]
public string Coding { get; set; }
/// <summary>
/// 名称
/// </summary>
[StringLength(200)]
public string Name { get; set; }
/// <summary>
/// 牌号
/// </summary>
[StringLength(200)]
public string Brand { get; set; }
/// <summary>
/// 规格
/// </summary>
[StringLength(200)]
public string Specifications { get; set; }
/// <summary>
/// 原厂家
/// </summary>
[StringLength(200)]
public string OriginalManufacturer { get; set; }
/// <summary>
/// 批次号
/// </summary>
[StringLength(200)]
public string BatchNo { get; set; }
/// <summary>
/// 剩余量（kg）
/// </summary>
public double RemainingAmount { get; set; }
/// <summary>
/// 入库总量（kg）
/// </summary>
public double TotalInventory { get; set; }
/// <summary>
/// 单价（元/kg）
/// </summary>
[StringLength(200)]
public string UnitPrice { get; set; }
/// <summary>
/// 合格证
/// </summary>
[StringLength(200)]
public string CertificateOfApproval { get; set; }
/// <summary>
/// 库房库位
/// </summary>
public int StoreId { get; set; }
/// <summary>
/// 位置
/// </summary>
[StringLength(200)]
public string Location { get; set; }
/// <summary>
/// 类别
/// </summary>
public Int16 Category { get; set; }
/// <summary>
/// 复验日期
/// </summary>
public DateTime ReinspectionDate { get; set; }
/// <summary>
/// 复验状态
/// </summary>
[StringLength(200)]
public string ReinspectionStatus { get; set; }

    }
    #endregion

    #region EditDto

    public class MaterialPowderEditDto: MaterialPowderCreateDto
    {

    }
    #endregion
    #region ListDto

    public class MaterialPowderListDto: BaseEntity
    {
/// <summary>
/// 编码
/// </summary>
[StringLength(200)]
public string Coding { get; set; }
/// <summary>
/// 名称
/// </summary>
[StringLength(200)]
public string Name { get; set; }
/// <summary>
/// 牌号
/// </summary>
[StringLength(200)]
public string Brand { get; set; }
/// <summary>
/// 规格
/// </summary>
[StringLength(200)]
public string Specifications { get; set; }
/// <summary>
/// 原厂家
/// </summary>
[StringLength(200)]
public string OriginalManufacturer { get; set; }
/// <summary>
/// 批次号
/// </summary>
[StringLength(200)]
public string BatchNo { get; set; }
/// <summary>
/// 剩余量（kg）
/// </summary>
public double RemainingAmount { get; set; }
/// <summary>
/// 入库总量（kg）
/// </summary>
public double TotalInventory { get; set; }
/// <summary>
/// 单价（元/kg）
/// </summary>
[StringLength(200)]
public string UnitPrice { get; set; }
/// <summary>
/// 合格证
/// </summary>
[StringLength(200)]
public string CertificateOfApproval { get; set; }
/// <summary>
/// 库房库位
/// </summary>
public int StoreId { get; set; }
/// <summary>
/// 位置
/// </summary>
[StringLength(200)]
public string Location { get; set; }
/// <summary>
/// 类别
/// </summary>
public Int16 Category { get; set; }
/// <summary>
/// 复验日期
/// </summary>
public DateTime ReinspectionDate { get; set; }
/// <summary>
/// 复验状态
/// </summary>
[StringLength(200)]
public string ReinspectionStatus { get; set; }
    }
    #endregion
    }
