
using Abp.Application.Services.Dto;
using Abp.AutoMapper;
using Abp.Domain.Repositories;
using Abp.Linq.Extensions;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Dynamic.Core;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using HYH.Registry.Core;
using HYH.Registry.DbModels;
using HYH.Registry.Dtos;
using HYH.Registry.Core;
namespace HYH.Registry.Service
{
    /// <summary>
    /// MaterialPlacode
    /// 
    ///应用层服务的接口实现方法
    ///</summary>

    public class MaterialPlacodeAppService : BaseService
    {
        private readonly IRepository<MaterialPlacode, int> _rep;
        /// <summary>
        /// 构造函数
        ///</summary>
        public MaterialPlacodeAppService (IRepository<MaterialPlacode, int> entityRepository )
        {
            _rep = entityRepository;
        }

            #region 自动生成服务代码
            /// <summary>
            /// 获取分页列表信息
            /// </summary>
            /// <param name="input"></param>
            /// <returns></returns>
            [HttpPost]
            public async Task<PagedResultDto<MaterialPlacodeListDto>> Paged(PageRequestDto<MaterialPlacodeDto>  input)
            {

                var query = _rep.GetAll();
                // TODO:根据传入的参数添加过滤条件
                int pageSize = input.PageSize > 0 ? input.PageSize : Int32.MaxValue;
                int current = input.PageIndex > 0 ? input.PageIndex : 1;

                var count = await query.CountAsync();

                var entityList = await query
                .OrderByDescending(u=>u.Id).AsNoTracking()
                .PageBy((current-1)*pageSize,pageSize)
                .ToListAsync();

                var entityListDtos =entityList.MapTo<List<MaterialPlacodeListDto>>();
                 return new PagedResultDto<MaterialPlacodeListDto> (count,entityListDtos);
              }

            /// <summary>
            /// 获取编辑的MaterialPlacode
            /// </summary>
            /// <param name="input"></param>
            /// <returns></returns>

            public async Task<MaterialPlacodeDto> Get(NullableIdDto<int> input)
            {

                MaterialPlacodeDto editDto;
                var entity = await _rep.GetAsync(input.Id.Value);
                editDto = entity.MapTo<MaterialPlacodeDto>();
                return editDto;
            }

        /// <summary>
        /// 添加MaterialPlacode
        ///</summary>

        public virtual async Task<IActionResult>  Create(MaterialPlacodeCreateDto input)
        {
        //TODO:新增前的逻辑判断，是否允许新增
        var entity=input.MapTo<MaterialPlacode>();
    int id = await _rep.InsertAndGetIdAsync(entity);
    return new JsonResult(id>0?true:false);

    }

        /// <summary>
        /// 编辑
        /// </summary>

    public virtual async Task<IActionResult> Update(MaterialPlacodeEditDto input)
        {
        //TODO:更新前的逻辑判断，是否允许更新

        var entity = await _rep.GetAsync(input.Id);
        input.MapTo(entity);
        await _rep.UpdateAsync(entity);
        return new JsonResult(true);
        }

        /// <summary>
            /// 删除
            ///        </summary>
        /// <param name="input"></param>
        /// <returns></returns>

        public async Task<IActionResult> Delete(EntityDto<int> input)
                {
                //TODO:删除前的逻辑判断，是否允许删除
                await _rep.DeleteAsync(input.Id);
                return new JsonResult(true);
                }

                /// <summary>
                    /// 批量删除的方法
                    ///</summary>

                public async Task<IActionResult>  BatchDelete(List<int>  input)
                        {
                        // TODO:批量删除前的逻辑判断，是否允许删除
                        await _rep.DeleteAsync(s => input.Contains(s.Id));
                        return new JsonResult(true);
                        }
                        #endregion
           }

     }
