using HYH.Registry.Core;
using System;
using System.ComponentModel.DataAnnotations;
namespace HYH.Registry.Dtos
{
    /// <summary>
    /// author: henq
    /// time: 2019/12/4 18:27:14
    ///
    ///</summary>
/*
//在 DbContent 中注册
    public DbSet<MaterialPlacode> MaterialPlacodes { get; set; }
//在 ApplicationModule.cs 关联映射
                config.CreateMap<MaterialPlacode, MaterialPlacodeDto>();
                config.CreateMap<MaterialPlacodeCreateDto, MaterialPlacode>();
                config.CreateMap<MaterialPlacodeEditDto, MaterialPlacode>();
                config.CreateMap<MaterialPlacode,MaterialPlacodeListDto>();
*/
    #region Dto
    public class MaterialPlacodeDto : BaseEntity
    {
        /// <summary>
        /// 基板编码
        /// </summary>
        [StringLength(200)]
        public string SubstrateCoding { get; set; }
        /// <summary>
        /// 基板材质
        /// </summary>
        [StringLength(200)]
        public string BaseMaterial { get; set; }
        /// <summary>
        /// 材料编号
        /// </summary>
        [StringLength(200)]
        public string MaterialNumber { get; set; }
        /// <summary>
        /// 适用设备
        /// </summary>
        [StringLength(200)]
        public string ApplyToEquipment { get; set; }
        /// <summary>
        /// 厚度
        /// </summary>
        public double Thickness { get; set; }
        /// <summary>
        /// 状态
        /// </summary>
        public Int16 State { get; set; }
        /// <summary>
        /// 所处位置
        /// </summary>
        [StringLength(200)]
        public string Location { get; set; }
        /// <summary>
        /// 库存
        /// </summary>
        public double Inventory { get; set; }
        /// <summary>
        /// 最低库存
        /// </summary>
        public double MinimumInventory { get; set; }
        /// <summary>
        /// 可用库存
        /// </summary>
        public double AvailableInStock { get; set; }

    }
    #endregion
    #region CreateDto
    public class MaterialPlacodeCreateDto : BaseEntity
    {
        /// <summary>
        /// 基板编码
        /// </summary>
        [StringLength(200)]
        public string SubstrateCoding { get; set; }
        /// <summary>
        /// 基板材质
        /// </summary>
        [StringLength(200)]
        public string BaseMaterial { get; set; }
        /// <summary>
        /// 材料编号
        /// </summary>
        [StringLength(200)]
        public string MaterialNumber { get; set; }
        /// <summary>
        /// 适用设备
        /// </summary>
        [StringLength(200)]
        public string ApplyToEquipment { get; set; }
        /// <summary>
        /// 厚度
        /// </summary>
        public double Thickness { get; set; }
        /// <summary>
        /// 状态
        /// </summary>
        public Int16 State { get; set; }
        /// <summary>
        /// 所处位置
        /// </summary>
        [StringLength(200)]
        public string Location { get; set; }
        /// <summary>
        /// 库存
        /// </summary>
        public double Inventory { get; set; }
        /// <summary>
        /// 最低库存
        /// </summary>
        public double MinimumInventory { get; set; }
        /// <summary>
        /// 可用库存
        /// </summary>
        public double AvailableInStock { get; set; }

    }
    #endregion

    #region EditDto

    public class MaterialPlacodeEditDto : MaterialPlacodeCreateDto
    {

    }
    #endregion
    #region ListDto

    public class MaterialPlacodeListDto : BaseEntity
    {
        /// <summary>
        /// 基板编码
        /// </summary>
        [StringLength(200)]
        public string SubstrateCoding { get; set; }
        /// <summary>
        /// 基板材质
        /// </summary>
        [StringLength(200)]
        public string BaseMaterial { get; set; }
        /// <summary>
        /// 材料编号
        /// </summary>
        [StringLength(200)]
        public string MaterialNumber { get; set; }
        /// <summary>
        /// 适用设备
        /// </summary>
        [StringLength(200)]
        public string ApplyToEquipment { get; set; }
        /// <summary>
        /// 厚度
        /// </summary>
        public double Thickness { get; set; }
        /// <summary>
        /// 状态
        /// </summary>
        public Int16 State { get; set; }
        /// <summary>
        /// 所处位置
        /// </summary>
        [StringLength(200)]
        public string Location { get; set; }
        /// <summary>
        /// 库存
        /// </summary>
        public double Inventory { get; set; }
        /// <summary>
        /// 最低库存
        /// </summary>
        public double MinimumInventory { get; set; }
        /// <summary>
        /// 可用库存
        /// </summary>
        public double AvailableInStock { get; set; }
    }
    #endregion
}
