﻿using System;
using System.Threading.Tasks;
using Abp.TestBase;
using HYH.Registry.EntityFrameworkCore;
using HYH.Registry.Tests.TestDatas;

namespace HYH.Registry.Tests
{
    public class RegistryTestBase : AbpIntegratedTestBase<RegistryTestModule>
    {
        public RegistryTestBase()
        {
            UsingDbContext(context => new TestDataBuilder(context).Build());
        }

        protected virtual void UsingDbContext(Action<RegistryDbContext> action)
        {
            using (var context = LocalIocManager.Resolve<RegistryDbContext>())
            {
                action(context);
                context.SaveChanges();
            }
        }

        protected virtual T UsingDbContext<T>(Func<RegistryDbContext, T> func)
        {
            T result;

            using (var context = LocalIocManager.Resolve<RegistryDbContext>())
            {
                result = func(context);
                context.SaveChanges();
            }

            return result;
        }

        protected virtual async Task UsingDbContextAsync(Func<RegistryDbContext, Task> action)
        {
            using (var context = LocalIocManager.Resolve<RegistryDbContext>())
            {
                await action(context);
                await context.SaveChangesAsync(true);
            }
        }

        protected virtual async Task<T> UsingDbContextAsync<T>(Func<RegistryDbContext, Task<T>> func)
        {
            T result;

            using (var context = LocalIocManager.Resolve<RegistryDbContext>())
            {
                result = await func(context);
                context.SaveChanges();
            }

            return result;
        }
    }
}
