﻿using Abp.Application.Services;
using Abp.Domain.Repositories;
using HYH.AspNetCore;
using HYH.Core.DbModels;
using HYH.Registry.DbModels;
using HYH.Registry.EntityFrameworkCore;
using HYH.SqlSugarCore;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace HYH.Registry.Services.Encryption
{
    /// <summary>
    /// 
    /// </summary>
    public class EncryptionService : ApplicationService
    {
        private readonly ICurrentUser _currentUser;
        private readonly IRepository<Tenant, int> _repTenant;

        /// <summary>
        /// 构造函数
        ///</summary>
        public EncryptionService(
            ICurrentUser currentUser,
            IRepository<Tenant, int> repTenant
            )
        {
            _currentUser = currentUser;
            _repTenant = repTenant;


        }

        /// <summary>
        /// 获取Mac地址
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public string GetNetCardMACAddress()
        {
            string netCardMACAddress = ComputerInfoHelper.GetNetCardMACAddress();
            return netCardMACAddress;
        }
        /// <summary>
        /// 获取Mac地址
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public string GetMACIp()
        {
            string netCardMACAddress = ComputerInfoHelper.GetMACIp();
            return netCardMACAddress;
        }
        /// <summary>
        /// 获取电脑名称
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public string GetName()
        {
            string netCardMACAddress = ComputerInfoHelper.GetName();
            return netCardMACAddress;
        }
        /// <summary>
        /// 获取硬盘序列号
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public string GetHardDiskSerialNumber()
        {
            string hardDiskSerialNumber = ComputerInfoHelper.GetHardDiskSerialNumber();
            return hardDiskSerialNumber;
        }
        /// <summary>
        /// 合成码
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public string GetGeneratedCode()
        {
            string netCardMACAddress = ComputerInfoHelper.GetNetCardMACAddress();
            string hardDiskSerialNumber = ComputerInfoHelper.GetHardDiskSerialNumber();
            string data = netCardMACAddress + hardDiskSerialNumber;
            var dataLen = data.Length;
            var result = AESHelper.AESEncrypt(data, "jianzhukeji", "jzkj");
            var length = result.Length;
            return result;
        }

        /// <summary>
        /// 生成密文
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public string GetGeneratingCiphertext(string input)
        {
            string data = AESHelper.AESDecrypt(input, "jianzhukeji", "jzkj");
            string code = _currentUser.TenantCode;
            var tenant = _repTenant.FirstOrDefault(q => q.Code == code);
            string timestamp = (tenant.EndTime - tenant.StartTime).ToString();
            string companyName = tenant.Name;
            data += timestamp + companyName;
            data = data.PadRight(72);
            var datalen = data.Length;
            var result = AESHelper.AESEncrypt(data, "jianzhukeji", "jzkj");
            var length = result.Length;
            return result;
        }
    }
}
