﻿using Abp.Application.Services;
using Abp.Domain.Repositories;
using HYH.AspNetCore;
using HYH.Core.DbModels;
using HYH.Registry.DbModels;
using HYH.Registry.EntityFrameworkCore;
using HYH.SqlSugarCore;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HYH.Registry.Services.Encryption
{
    /// <summary>
    /// 
    /// </summary>
    public class EncryptionService : ApplicationService
    {
        private readonly ICurrentUser _currentUser;
        private readonly IRepository<Tenant, int> _repTenant;

        /// <summary>
        /// 构造函数
        ///</summary>
        public EncryptionService(
            ICurrentUser currentUser,
            IRepository<Tenant, int> repTenant
            )
        {
            _currentUser = currentUser;
            _repTenant = repTenant;


        }

        /// <summary>
        /// 获取Mac地址
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public string GetNetCardMACAddress()
        {
            string netCardMACAddress = ComputerInfoHelper.GetNetCardMACAddress();
            return netCardMACAddress;
        }
        /// <summary>
        /// 获取所有Mac地址
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public string PrintAllMacAddress()
        {
            string netCardMACAddress = ComputerInfoHelper.PrintAllMacAddress();
            return netCardMACAddress;
        }
        /// <summary>
        /// 获取第一个mac地址
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public string GetFirstMacAddress()
        {
            string netCardMACAddress = ComputerInfoHelper.GetFirstMacAddress();
            return netCardMACAddress;
        }
        /// <summary>
        /// 获取Mac地址
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public string GetMACIp()
        {
            string netCardMACAddress = ComputerInfoHelper.GetMACIp();
            return netCardMACAddress;
        }
        /// <summary>
        /// 获取电脑名称
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public string GetName()
        {
            string netCardMACAddress = ComputerInfoHelper.GetName();
            return netCardMACAddress;
        }
        /// <summary>
        /// 获取硬盘序列号
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public string GetHardDiskSerialNumber()
        {
            string hardDiskSerialNumber = ComputerInfoHelper.GetHardDiskSerialNumber();
            return hardDiskSerialNumber;
        }
        /// <summary>
        /// 合成码
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public string GetGeneratedCode()
        {
            //string netCardMACAddress = ComputerInfoHelper.GetNetCardMACAddress();
            //string hardDiskSerialNumber = ComputerInfoHelper.GetHardDiskSerialNumber();
            string netCardMACAddress = ComputerInfoHelper.GetMACIp();
            string hostName = ComputerInfoHelper.GetHostName();
            string data = netCardMACAddress + hostName;
            var dataLen = data.Length;
            var result = AESHelper.AESEncrypt(data, "jianzhukeji", "jzkj");
            var length = result.Length;
            return result;
        }

        /// <summary>
        /// 生成密文
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public string GetGeneratingCiphertext(EncryptionDto input)
        {
            string data = AESHelper.AESDecrypt(input.CipherText, "jianzhukeji", "jzkj");
            //var tenant = _repTenant.FirstOrDefault(q => q.Code == _currentUser.TenantCode);
            string timeStr = Convert.ToDateTime(input.ExpirationDate).ToString("yyyy-MM-dd HH:mm:ss");
            string companyName = input.CompanyName;
            //string time = input.ExpirationDate;
            //string companyName = input.CompanyName;
            data = timeStr + data + companyName;
            data = data.PadRight(72);
            var datalen = data.Length;
            var result = AESHelper.AESEncrypt(data, "jianzhukeji", "jzkj");
            var length = result.Length;
            return result;

        }
        /// <summary>
        /// 登录的密文验证
        /// </summary>
        /// <returns></returns>

        public async Task<IActionResult> LoginCipherCertification()
        {
            bool flag = false;
            string netCardMACAddress = ComputerInfoHelper.GetMACIp();
            string hostName = ComputerInfoHelper.GetHostName();
            var tenant = await _repTenant.FirstOrDefaultAsync(q => q.Code == _currentUser.TenantCode);
            if (!string.IsNullOrEmpty(tenant.Registry_cipher))
            {
                // 解密
                var dataString = AESHelper.AESDecrypt(tenant.Registry_cipher, "jianzhukeji", "jzkj");
                string timeStr = dataString.Substring(0, 19);
                DateTime dateTime = Convert.ToDateTime(timeStr);
                if (dateTime > DateTime.Now)
                {
                    flag = true;
                }
            }
            return new JsonResult(flag);
        }
    }
}
