﻿using Abp.AutoMapper;
using Abp.Modules;
using Abp.Reflection.Extensions;
using AutoMapper;
using HYH.Core;
using HYH.Core.Utilities;
using HYH.Registry.Nodes;
using System.Linq;
using System.Reflection;

namespace HYH.Registry
{
    [DependsOn(
        typeof(RegistryCoreModule), 
        typeof(AbpAutoMapperModule))]
    public class RegistryApplicationModule : AbpModule
    {
        private Assembly thisAssembly;

        public override void Initialize()
        {
            thisAssembly = typeof(RegistryApplicationModule).GetAssembly();
            IocManager.RegisterAssemblyByConvention(thisAssembly);

            var profiles = thisAssembly.GetTypes().Where(x => typeof(Profile).IsAssignableFrom(x));
            Configuration.Modules.AbpAutoMapper().Configurators.Add(
                cfg =>
                {
                    foreach (var profile in profiles)
                    {
                        var resolvedProfile = IocManager.Resolve(profile) as Profile;
                        cfg.AddProfile(resolvedProfile);
                    }
                }
            );
        }

        public override void PreInitialize()
        {
            Configuration.Modules.AbpAutoMapper().Configurators.Add(config =>
            {
              
            });
        }
        public override void PostInitialize()
        {
            base.PostInitialize();
        }
    }
}