using System;
using System.Threading.Tasks;
using Abp.TestBase;
using HYH.Aps.EntityFrameworkCore;
using HYH.Aps.Tests.TestDatas;

namespace HYH.Aps.Tests
{
    public class WorkflowTestBase : AbpIntegratedTestBase<WorkflowTestModule>
    {
        public WorkflowTestBase()
        {
            UsingDbContext(context => new TestDataBuilder(context).Build());
        }

        protected virtual void UsingDbContext(Action<WorkflowDbContext> action)
        {
            using (var context = LocalIocManager.Resolve<WorkflowDbContext>())
            {
                action(context);
                context.SaveChanges();
            }
        }

        protected virtual T UsingDbContext<T>(Func<WorkflowDbContext, T> func)
        {
            T result;

            using (var context = LocalIocManager.Resolve<WorkflowDbContext>())
            {
                result = func(context);
                context.SaveChanges();
            }

            return result;
        }

        protected virtual async Task UsingDbContextAsync(Func<WorkflowDbContext, Task> action)
        {
            using (var context = LocalIocManager.Resolve<WorkflowDbContext>())
            {
                await action(context);
                await context.SaveChangesAsync(true);
            }
        }

        protected virtual async Task<T> UsingDbContextAsync<T>(Func<WorkflowDbContext, Task<T>> func)
        {
            T result;

            using (var context = LocalIocManager.Resolve<WorkflowDbContext>())
            {
                result = await func(context);
                context.SaveChanges();
            }

            return result;
        }
    }
}
