﻿using Abp.AspNetCore;
using Castle.Facilities.Logging;
using Castle.Services.Logging.SerilogIntegration;
using HYH.AspNetCore;
using HYH.Core;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.HttpOverrides;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Logging;
using NanoFabric.Swagger;
using Serilog;
using System;
using Volo.Abp.Security.Claims;

namespace HYH.Registry.Web.Host.Startup
{
    public class Startup
    {
        private readonly IConfiguration _configuration;

        public Startup(IHostingEnvironment env, IConfiguration configuration)
        {
            _configuration = configuration;
        }

        public IServiceProvider ConfigureServices(IServiceCollection services)
        {
            services
                .AddRequired(_configuration)
                .AddRegistry()
                .AddMicroServices();


            var sp = services.BuildServiceProvider();
            var httpContextAccessor = sp.GetService<IHttpContextAccessor>();
            var currentPrincipalAccessor = sp.GetService<ICurrentPrincipalAccessor>();
            LogEnricher logEnricher = new LogEnricher();
            logEnricher.HttpContextAccessor = httpContextAccessor;
            logEnricher.CurrentPrincipalAccessor = currentPrincipalAccessor;
            return services.AddAbp<RegistryWebHostModule>(
                options =>
                {
                    var config = new LoggerConfiguration()
                     .ReadFrom.Configuration(_configuration)
                     .Enrich.With(logEnricher)
                     .CreateLogger();
                    options.IocManager.IocContainer
                     .AddFacility<LoggingFacility>(f => f.LogUsing(new SerilogFactory(config)));
                });
        }
        public void Configure(IApplicationBuilder app, IHostingEnvironment env, ILoggerFactory loggerFactory, IApiInfo apiInfo)
        {
            app.UseAbp(options => {
                options.UseAbpRequestLocalization = false;
                options.UseCastleLoggerFactory = true;
            });
            app.UseForwardedHeaders(new ForwardedHeadersOptions
            {
                ForwardedHeaders = ForwardedHeaders.XForwardedFor | ForwardedHeaders.XForwardedProto
            });
            app.UseDeveloperExceptionPage();
            app.UsePermissiveCors();
            app.UseStaticFiles();
            app.UseConsulRegisterService(_configuration);
            app.UseAbpRequestLocalization();
            app.UseAuthentication();
            app.UseMvc();
            app.UseCustomSwagger(apiInfo);
        }
    }
}
