﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using Abp.AspNetCore.Mvc.Controllers;
using Abp.Runtime.Validation;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Hosting.Internal;
using Microsoft.AspNetCore.Mvc;

namespace HYH.Registry.Web.Host.Controllers.Code
{
    [AllowAnonymous]
    [Route("/code/[action]")]
    [ApiController]
    [DisableValidation]
    [ApiExplorerSettings(IgnoreApi = true)]
    public class CodeController : AbpController
    {
        public string host = "http://localhost:5008/";
        [HttpGet]
        public IActionResult Index()
        {
            ViewBag.host = host;
            return View();
        }
        [HttpPost]
        public IActionResult Down([FromBody]DBTable table)
        {
            var web = Directory.GetCurrentDirectory();
            var dirs = new DirectoryInfo(web).Parent.GetDirectories();
            var modelPath = "";
            var appPath = "";
            foreach (var item in dirs)
            {
                if (item.Name.EndsWith(".Core"))
                {
                    modelPath = item.FullName;
                }
                else if (item.Name.EndsWith(".Application"))
                {
                    appPath = item.FullName;
                }
            }
            if (string.IsNullOrEmpty(modelPath + appPath))
            {
                return new JsonResult(false);
            }
            makeCode(table, modelPath, appPath);
            return new JsonResult(true);
        }
        private void makeCode(DBTable dto,string modelPath,string appPath)
        {
            var name = underToPascal(dto.Name.Trim());

            var url = host+"c/{0}?id={1}";
            //1 model 生成
            getHtml(string.Format(url, "index", dto.Id), modelPath + "/DbModels/",name + ".cs");
            //2 dto 生成
            getHtml(string.Format(url, "dto", dto.Id), appPath + "/Services/"+name, name + "Dto.cs");
            //3 service 生成
            getHtml(string.Format(url, "service", dto.Id), appPath + "/Services/" + name, name + "Service.cs");
        }
        private void getHtml(string url, string path, string name)
        {
          
            try
            {
              
                HttpWebRequest request = (HttpWebRequest)WebRequest.Create(url);
                HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                Stream receive = response.GetResponseStream();
                StreamReader readStream = new StreamReader(receive, Encoding.Default);

                var txt = readStream.ReadToEnd();

                if (!Directory.Exists(path))
                {
                    Directory.CreateDirectory(path);
                }
                System.IO.File.WriteAllText(Path.Combine(path,name), txt);
            }

            catch (Exception ex)
            {
                Console.WriteLine(ex);
            }

        }
        public string underToPascal(string s)
        {
            var arrs = s.Split('_');
            var reslut = "";
            arrs.ToList().ForEach(u =>
            {
                var w = u[0].ToString().ToUpper() + u.Substring(1);
                reslut += w;
            });
            return reslut;
        }
    }

    public class DBTable
    {
        public int Id { get; set; }
        /// <summary>
        /// 数据库名称
        /// </summary>
        public string DatabaseName { get; set; }
        /// <summary>
        /// 表名称
        /// </summary>
        public string Name { get; set; }
       
    }
}