﻿using Abp.Configuration.Startup;
using Abp.Domain.Uow;
using Abp.EntityFrameworkCore;
using Abp.EntityFrameworkCore.Configuration;
using Abp.Modules;
using Abp.Reflection.Extensions;
using HYH.EntityFramework;
using HYH.EntityFrameworkCore;

namespace HYH.Registry.EntityFrameworkCore
{
    [DependsOn(
        typeof(RegistryCoreModule), 
        typeof(AbpEntityFrameworkCoreModule))]
    public class RegistryEntityFrameworkCoreModule : AbpModule
    {
        public override void PreInitialize()
        {
            Configuration.ReplaceService<IConnectionStringResolver, ConnectionStringResolver>();

            // Configure first DbContext
            Configuration.Modules.AbpEfCore().AddDbContext<PlatformDbContext>(options =>
            {
                if (options.ExistingConnection != null)
                {
                    DbContextOptionsConfigurer.Configure(options.DbContextOptions, options.ExistingConnection);
                }
                else
                {
                    DbContextOptionsConfigurer.Configure(options.DbContextOptions, options.ConnectionString);
                }
            });
        }
        public override void Initialize()
        {
            IocManager.RegisterAssemblyByConvention(typeof(RegistryEntityFrameworkCoreModule).GetAssembly());
        }
    }
}