package com.aps.service.Algorithm;

import com.aps.entity.Algorithm.Chromosome;
import com.aps.entity.Algorithm.ObjectiveWeights;

import java.util.List;

/**
 * 作者：佟礼
 * 时间：2025-11-24
 */
public class FitnessCalculator {
    /**
     * 多目标适应度计算（加权求和）
     */
    public double calculateFitness(Chromosome chromosome,ObjectiveWeights objectiveWeights) {


        double fitness=0;
        for(int i=0;i<chromosome.getObjectives().length;i++)
        {
            // 归一化（假设最大可能值，实际应根据问题规模调整）
            double val=1/ (1 +chromosome.getObjectives()[i]);
            if(!objectiveWeights.isPureNSGAIIMode())
            {
                val=val*objectiveWeights.getWeights()[i];
            }
            fitness+=val;
           // 1/1+1 0.5
           // 1/1+2 0.3
           // 1/1+3  0.25
            // 值越大 归一化 后越小
        }
        // 适应度值（越大越好）
        return fitness;
    }
    /**
     * 计算种群适应度标准差（用于参数微调）
     * @param population 染色体种群数组
     * @return 适应度标准差
     */
    public double calculateFitnessStd(List<Chromosome> population) {
        int popSize = population.size();

        // 1. 计算平均适应度
        double avgFitness = 0.0f;
        for (Chromosome chromosome : population) {
            avgFitness += chromosome.getFitness();
        }
        avgFitness /= popSize;

        // 2. 计算每个个体与平均值的平方差之和
        float sumSqDiff = 0.0f;
        for (Chromosome chromosome : population) {
            double diff = chromosome.getWeightedObjective() - avgFitness;
            sumSqDiff += diff * diff;
        }

        // 3. 计算标准差
        return (double) Math.sqrt(sumSqDiff / popSize);
    }




}
