package com.aps.entity.Algorithm;

import com.aps.entity.basic.TimeSegment;
import lombok.Data;

import java.util.List;

/**
 * 作者：佟礼
 * 时间：2025-11-21
 */
@Data
public class ScheduleResultDetail {
    private String Key;
    private int StartTime; // 相对开始时间（秒）
    private int EndTime; // 相对结束时间（秒）
    private double OneTime; // 单件工时
    private double Quantity; // 时间段

    private List<TimeSegment> usedSegment;


    // Key 的 getter/setter
    public String getKey() {
        return Key;
    }

    public void setKey(String key) {
        this.Key = key;
    }

    // StartTime 的 getter/setter
    public int getStartTime() {
        return StartTime;
    }

    public void setStartTime(int startTime) {
        this.StartTime = startTime;
    }

    // EndTime 的 getter/setter
    public int getEndTime() {
        return EndTime;
    }

    public void setEndTime(int endTime) {
        this.EndTime = endTime;
    }

    // 对应C#的计算属性 processingTime（通过方法实现）
    public int getProcessingTime() {
        return EndTime - StartTime; // 绝对处理时间（分钟）
    }
}
