// EntityConfig.java
package com.aps.entity.common;

public class EntityConfig {
    private String entityName;
    private DataSourceType dataSource;
    private String tableName;      // 数据库表名（如果是数据库源）
    private String fieldName;      // Chromosome字段名（如果是文件源）
    private Class<?> entityClass;  // 实体类（数据库实体使用）

    // 构造方法
    public EntityConfig() {}

    public EntityConfig(String entityName, DataSourceType dataSource, String fieldName, String tableName, Class<?> entityClass) {
        this.entityName = entityName;
        this.dataSource = dataSource;
        this.fieldName = fieldName;
        this.tableName = tableName;
        this.entityClass = entityClass;
    }

    // getter/setter
    public String getEntityName() { return entityName; }
    public void setEntityName(String entityName) { this.entityName = entityName; }
    
    public DataSourceType getDataSource() { return dataSource; }
    public void setDataSource(DataSourceType dataSource) { this.dataSource = dataSource; }
    
    public String getTableName() { return tableName; }
    public void setTableName(String tableName) { this.tableName = tableName; }
    
    public String getFieldName() { return fieldName; }
    public void setFieldName(String fieldName) { this.fieldName = fieldName; }
    
    public Class<?> getEntityClass() { return entityClass; }
    public void setEntityClass(Class<?> entityClass) { this.entityClass = entityClass; }

    @Override
    public String toString() {
        return "EntityConfig{" +
                "entityName='" + entityName + '\'' +
                ", dataSource=" + dataSource +
                ", tableName='" + tableName + '\'' +
                ", fieldName='" + fieldName + '\'' +
                ", entityClass=" + entityClass +
                '}';
    }
}