package com.aps.service.Algorithm;

import com.aps.entity.*;
import com.aps.entity.Algorithm.DependencyType;
import com.aps.entity.Algorithm.IDAndChildID.GroupResult;
import com.aps.entity.Algorithm.IDAndChildID.NodeInfo;
import com.aps.entity.Algorithm.OperationDependency;
import com.aps.entity.basic.*;
import com.aps.service.*;
import com.aps.service.plan.MachineSchedulerService;
import com.aps.service.plan.SceneService;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 作者：佟礼
 * 时间：2025-12-09
 */
@Service
public class RoutingDataService {

    @Autowired
    private ProdLaunchOrderService _prodLaunchOrderService;

    @Autowired
    private ProdProcessExecService _prodProcessExecService;

    @Autowired
    private ProdEquipmentService _prodEquipmentService;

    @Autowired
    private PlanResourceService _PlanResourceService;

    @Autowired
    private SceneService _sceneService;

    @Autowired
    private ProdOrderProcessService _prodOrderProcessService;

    @Autowired
    private  RoutingDiscreteParamService _routingDiscreteParamService;
    @Autowired
    private  DiscreteParameterMatrixService _discreteParameterMatrixService;

    @Autowired
    private ProdEquipSpecialCalService _prodEquipSpecialCalService;

    @Autowired
    private MesShiftWorkSchedService _MesShiftWorkSchedService;

    public Map<Integer, Object> InitEntrys(String SceneId, List<ProdEquipment> ProdEquipments, List<Order> ProdLaunchOrders)
    {
        Map<Integer, Object> list=new HashMap<>();
        List<ProdProcessExec> ProdProcessExecs=  _prodProcessExecService.lambdaQuery()
                .eq(ProdProcessExec::getSceneId,SceneId)
                .list();

// 获取op列表中所有的routingDetailId
        List<Long> routingDetailIds = ProdProcessExecs.stream()
                .map(ProdProcessExec::getRoutingDetailId)
                .filter(Objects::nonNull)
                .distinct()
                .collect(Collectors.toList());

// 查询RoutingDiscreteParam中routingDetailId在上述列表中的所有记录
        List<RoutingDiscreteParam> routingDiscreteParams = _routingDiscreteParamService.lambdaQuery()
                .in(RoutingDiscreteParam::getRoutingDetailId, routingDetailIds)
                .eq(RoutingDiscreteParam::getIsDeleted, 0)
                .list();


        List<ProdOrderProcess> ProdOrderProcesss = _prodOrderProcessService.lambdaQuery()
                .eq(ProdOrderProcess::getSceneId,SceneId)
                .list();

       return CreateEntry( SceneId,  ProdEquipments,  ProdLaunchOrders, routingDiscreteParams, ProdOrderProcesss, ProdProcessExecs,null );

    }

    public Map<Integer, Object> CreateEntry(String SceneId, List<ProdEquipment> ProdEquipments, List<Order> ProdLaunchOrders, List<RoutingDiscreteParam> routingDiscreteParams, List<ProdOrderProcess> ProdOrderProcesss, List<ProdProcessExec> ProdProcessExecs, List<GroupResult> existingResults)
    {
        Map<Integer, Object> list=new HashMap<>();
        List<String> soutceExecId = ProdOrderProcesss.stream()
                .map(ProdOrderProcess::getExecId)
                .distinct() // 提取Exec_ID
                .collect(Collectors.toList());

        List<String> targetExecId = ProdOrderProcesss.stream()
                .map(ProdOrderProcess::getTargetExecId)
                .distinct() // 提取TARGET_Exec_ID
                .collect(Collectors.toList());

        List<String> ExecIdNoChild=  ProdProcessExecs.stream()
                .filter(e -> !soutceExecId.contains(e.getExecId())&&!targetExecId.contains(e.getExecId()))  // 过滤条件
                .map(ProdProcessExec::getExecId)
                .distinct()
                .collect(Collectors.toList());

        if(ExecIdNoChild!=null&&ExecIdNoChild.size()>0)
        {
            for (String ExecId : ExecIdNoChild) {
                soutceExecId.add(ExecId);
                targetExecId.add("");
            }
        }
        List<GroupResult> results;
        int index=0;
        if(existingResults==null||existingResults.size()==0) {
            results = IdGroupingWithDualSerial.groupAndOrderIds(soutceExecId, targetExecId);
        }else {
            index=existingResults.size();
            results = IdGroupingWithDualSerial.addNewDataWithIsolatedGroup(existingResults,soutceExecId, targetExecId);
        }

        List<Entry> entrys=new ArrayList<>();

        for (int i = index; i < results.size(); i++) {
            GroupResult groupResult = results.get(i);
            List<NodeInfo> nodeInfoList = groupResult.getNodeInfoList();
            // System.out.println("分组" + (i + 1) + "顺序：" + nodeInfoList);
            for (NodeInfo nodeInfo : nodeInfoList) {
//                System.out.printf("原始ID：%s → 全局序号：%d，分组内序号：%d，新父ID列表：%s，新子ID列表：%s%n",
//                        nodeInfo.getOriginalId(),
//                        nodeInfo.getGlobalSerial(),
//                        nodeInfo.getGroupSerial(),
//                        nodeInfo.getNewParentIds().isEmpty() ? "无" : nodeInfo.getNewParentIds(),
//                        nodeInfo.getNewChildIds());

                Entry entry = new Entry();
                entry.setSceneId(SceneId);
                entry.setId(nodeInfo.getGlobalSerial());
                entry.setGroupId(i + 1);
                entry.setSequence(nodeInfo.getGroupSerial());
                entry.setExecId(nodeInfo.getOriginalId());
                ProdProcessExec op= ProdProcessExecs.stream()
                        .filter(t->t.getExecId().equals(entry.getExecId()))
                        .findFirst().orElse(null);
                if(nodeInfo.getNewParentIds()!=null)
                {

                    List<OperationDependency> OperationDependency=new ArrayList<>();
                    for (int id : nodeInfo.getNewParentIds()) {
                        OperationDependency od=new OperationDependency();
                        od.setPrevOperationId(id);

                        if (op != null) {
                            od.setDependencyType(DependencyType.fromValueSafe(op.getConnectProperty()));
                        } else {
                            od.setDependencyType(DependencyType.FinishToStart);
                        }
                        OperationDependency.add(od);
                    }
                    entry.setPrevEntryIds(OperationDependency);
                }



                if(nodeInfo.getNewChildIds()!=null)
                {
                    List<OperationDependency> OperationDependency=new ArrayList<>();
                    for (int id : nodeInfo.getNewChildIds()) {
                        OperationDependency od=new OperationDependency();
                        od.setNextOperationId(id);
                        // 记录属性
                        if (op != null) {
                            od.setDependencyType(DependencyType.fromValueSafe(op.getConnectProperty()));
                        } else {
                            od.setDependencyType(DependencyType.FinishToStart);
                        }



                        OperationDependency.add(od);
                    }
                    entry.setNextEntryIds(OperationDependency);
                }



                if(op!=null)
                {
                    entry.setDiscreteParameter(routingDiscreteParams.stream().filter(t -> t.getRoutingDetailId().equals(op.getRoutingDetailId())).collect(Collectors.toList()));
                    entry.setEquipTypeID(op.getMachineId());
                    entry.setOrderId(op.getOrderId());
                    entry.setQuantity(op.getPlanQty());
                    entry.setRoutingId(op.getRoutingId());
                    entry.setRoutingDetailId(op.getRoutingDetailId());
                    entry.setTaskSeq(op.getTaskSeq());
                    entry.setRoutingDetailName(op.getRoutingDetailName());
                    Order order = ProdLaunchOrders.stream()
                            .filter(t -> t.getOrderId().equals(op.getOrderId()))
                            .findFirst().orElse(null);
                    if (order != null) {
                        entry.setProductId(order.getMaterialId());
                        entry.setPriority(order.getActualPriority());
                        order.setId(entry.getGroupId());
                    }
                    List<ProdEquipment> Equipments = ProdEquipments.stream()
                            .filter(t -> t.getExecId().equals(op.getExecId()))
                            .collect(Collectors.toList());
                    if (Equipments != null && Equipments.size() > 0) {
                        List<MachineOption> mos = new ArrayList<>();
                        for (ProdEquipment e : Equipments) {
                            MachineOption mo = new MachineOption();
                            mo.setMachineId(e.getEquipId());
                            mo.setProcessingTime(e.getSpeed());
                            mo.setContantTime(op.getConstTime());
                            mo.setSetupTime(op.getChangeLineTime());
                            mo.setTeardownTime(op.getPostprocessingTime());
                            mo.setPreTime(e.getSetupTime());

                            mos.add(mo);
                        }
                        entry.setMachineOptions(mos);
                    }
                }
                entry.setPriority(1);
                entrys.add(entry);
            }
            // 输出每个节点的详细信息

            System.out.println("------------------------");
        }
        list.put(1,entrys);
        list.put(2,results);

        return  list;

    }

    public List<Machine> InitCalendarToAllMachines(String SceneId, List<ProdEquipment> ProdEquipments, MachineSchedulerService machineScheduler) {
        // 按设备分组

        List<Long> MachineIds = ProdEquipments.stream()
                .map(ProdEquipment::getEquipId)
                .distinct()
                .sorted()
                .collect(Collectors.toList());

        List<Machine> machines=new ArrayList<>();

        for (Long id : MachineIds) {
            Machine machine=new Machine();
            machine.setId(id);
            machines.add(machine);
        }
        //节假日
        //  List<MesHoliday> holidays=  _MesHolidayService.list();

        LambdaQueryWrapper<ProdEquipSpecialCal> ProdEquipSpecialCalWrapper = new LambdaQueryWrapper<>();
        ProdEquipSpecialCalWrapper.eq(ProdEquipSpecialCal::getSceneId, SceneId);

        List<PlanResource> PlanResources=  _PlanResourceService.lambdaQuery()
                .eq(PlanResource::getIsdeleted,0)
                .list();



        List<ProdEquipSpecialCal> ProdEquipSpecialCals=  _prodEquipSpecialCalService.list(ProdEquipSpecialCalWrapper);

        List<MesShiftWorkSched> MesShiftWorkScheds=  _MesShiftWorkSchedService.lambdaQuery()
                .eq(MesShiftWorkSched::getIsdeleted,0).list();


        if (machines == null) {
            return null;
        }

        for (Machine machine : machines) {
            // 确保维护窗口列表不为null
            if (machine.getMaintenanceWindows() == null) {
                machine.setMaintenanceWindows(new ArrayList<>());
            }
            List<ProdEquipSpecialCal> machineProdEquipSpecialCals = ProdEquipSpecialCals.stream()
                    .filter(t -> t.getEquipId() == machine.getId()&&t.getReferenceType()==1)
                    .collect(Collectors.toList());
            List<Shift> shifts1=new ArrayList<>();
            for (ProdEquipSpecialCal machineProdEquipSpecialCal : machineProdEquipSpecialCals) {

                List<MesShiftWorkSched> ShiftWorkScheds = MesShiftWorkScheds.stream()
                        .filter(t -> (long) t.getWeekWorkSchedId() == machineProdEquipSpecialCal.getReferenceId())
                        .collect(Collectors.toList());
                List<Shift> Shifts = mergeShiftData(ShiftWorkScheds);
                for (Shift shift : Shifts) {

                    shift.setMachineId(machine.getId());
                    shift.setStartDate(machineProdEquipSpecialCal.getStartDate());
                    shift.setEndDate(machineProdEquipSpecialCal.getEndDate());
                    shifts1.add(shift);
                }
            }
            List<PlanResource> PlanResources1 = PlanResources.stream()
                    .filter(t -> t.getReferenceId() == machine.getId())
                    .collect(Collectors.toList());
            if(PlanResources1!=null&&PlanResources1.size()>0)
            {
                for (PlanResource PlanResource : PlanResources1) {
                    machine.setCode(PlanResource.getCode());
                    machine.setName(PlanResource.getTitle());
                    if(PlanResource.getWorkSchedId()==null)
                    {
                        continue;
                    }
                    List<MesShiftWorkSched> ShiftWorkScheds = MesShiftWorkScheds.stream()
                            .filter(t -> (long) t.getWeekWorkSchedId() == PlanResource.getWorkSchedId())
                            .collect(Collectors.toList());
                    List<Shift> Shifts = mergeShiftData(ShiftWorkScheds);
                    for (Shift shift : Shifts) {

                        shift.setMachineId(machine.getId());
                        shift.setStartDate(LocalDateTime.of(2000, 1, 1, 0, 0, 0));
                        shift.setEndDate(LocalDateTime.of(2000, 1, 1, 0, 0, 0));
                        shifts1.add(shift);
                    }
                }

            }
            if(shifts1.size()==0)
            {
                throw new RuntimeException(String.format(
                        "设备%s没有设置日历",
                        machine.getCode()+":"+machine.getName()));


            }
            machine.setShifts(shifts1);

            List<ProdEquipSpecialCal> Holidays = ProdEquipSpecialCals.stream()
                    .filter(t -> t.getEquipId() == machine.getId()&&t.getReferenceType()==2)
                    .collect(Collectors.toList());
            List<Holiday> Holidays1=new ArrayList<>();
            for (ProdEquipSpecialCal machineProdEquipSpecialCal : Holidays) {

                Holiday holiday=new Holiday();
                holiday.setStart(machineProdEquipSpecialCal.getStartDate());
                holiday.setEnd(machineProdEquipSpecialCal.getEndDate());
                Holidays1.add(holiday);
            }
            machine.setHolidays(Holidays1);



        }


        // 4. 初始化机器时间线
        for (Machine machine : machines) {
            MachineTimeline timeline = machineScheduler.getOrCreateTimeline(machine);
            machine.setAvailability(timeline.getSegments());
        }
        return  machines;


    }
    /**
     * 合并重复的ShiftData，将serialNumber收集为列表
     * @param originalList 原始数据列表
     * @return 合并后的MergedShiftData列表
     */
    public static List<Shift> mergeShiftData(List<MesShiftWorkSched> originalList) {
        // 按shiftStart和shiftEnd分组
        Map<String, Shift> groupMap = new HashMap<>();

        for (MesShiftWorkSched data : originalList) {
            // 用shiftStart+shiftEnd作为分组key
            String groupKey = data.getShiftStart().toString() + "_" + data.getShiftEnd().toString();

            if (groupMap.containsKey(groupKey)) {
                // 已存在分组：添加serialNumber到列表
                Shift merged = groupMap.get(groupKey);
                merged.getDays().add(data.getStartWeekDay());
            } else {
                // 新分组：创建MergedShiftData并初始化
                Shift merged = new Shift();

                merged.setStartTime(data.getShiftStart().toLocalTime());
                merged.setEndTime(data.getShiftEnd().toLocalTime());
                merged.setStatus(0);

                // 初始化序号列表
                Set<Integer> serials =new HashSet<>();
                serials.add(data.getStartWeekDay());
                merged.setDays(serials);
                groupMap.put(groupKey, merged);
            }
        }

        // 转换为列表返回
        return new ArrayList<>(groupMap.values());
    }

}
