package com.aps.entity.Algorithm;

/**
 * 作者：佟礼
 * 时间：2025-12-09
 * 多目标权重配置
 */
public class ObjectiveWeights {
    /**
     * 目标权重（默认值：[0.3, 0.2, 0.15, 0.2, 0.15]）
     * 对应：完工时间、总流程时间、总换型时间、机器负载标准差、延迟时间
     */
    private double[] weights = new double[] { 0.3, 0.2, 0.15, 0.2, 0.15 };

    /**
     * NSGA-II模式：true=纯帕累托（无视权重），false=加权帕累托
     */
    private boolean pureNSGAIIMode = true;

    // Getter and Setter for weights
    public double[] getWeights() {
        return weights;
    }

    public void setWeights(double[] weights) {
        this.weights = weights;
    }

    // Getter and Setter for pureNSGAIIMode
    public boolean isPureNSGAIIMode() {
        return pureNSGAIIMode;
    }

    public void setPureNSGAIIMode(boolean pureNSGAIIMode) {
        this.pureNSGAIIMode = pureNSGAIIMode;
    }

    /**
     * 归一化目标值（消除量纲影响）
     */
    public double[] normalizeObjectives(double[] objectives, double[] minValues, double[] maxValues) {
        double[] normalized = new double[objectives.length];
        if(minValues==null||minValues.length==0)
        {
            for (int i = 0; i < objectives.length; i++) {
                normalized[i]= 1/ (1 +(double) objectives[i]);
            }
        }else {

            for (int i = 0; i < objectives.length; i++) {
                if (maxValues[i] - minValues[i] == 0)
                    normalized[i] = 0;
                else
                    normalized[i] = (objectives[i] - minValues[i]) / (maxValues[i] - minValues[i]);
            }
        }
        return normalized;
    }

    /**
     * 计算加权目标值
     */
    public double calculateWeightedObjective(double[] normalizedObjectives) {
        double sum = 0;
        for (int i = 0; i < normalizedObjectives.length; i++)
            sum += normalizedObjectives[i] * weights[i];
        return sum;
    }

    /**
     * 计算加权目标值
     */
    public double calculateObjective(double[] normalizedObjectives) {
        double sum = 0;
        for (int i = 0; i < normalizedObjectives.length; i++)
            sum += normalizedObjectives[i];
        return sum;
    }
}
