package com.aps.service;

import com.aps.entity.StrategyRule;
import com.aps.entity.StrategyScheduling;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * <p>
 * 策略规则 服务类
 * </p>
 *
 * @author MyBatis-Plus
 * @since 2025-12-10
 */
public interface StrategyRuleService extends IService<StrategyRule> {
    
    /**
     * 根据策略规则ID获取其前向调度配置并转换为StrategyScheduling实体列表
     *
     * @param ruleId 策略规则ID
     * @return StrategyScheduling实体列表
     */
    List<StrategyScheduling> getForwardSchedulingByRuleId(Long ruleId);
    

}