package com.aps.entity.basic;

import java.time.LocalDateTime;

public class Holiday {
    private LocalDateTime start;
    private LocalDateTime end;
    
    public Holiday() {}
    
    public Holiday(LocalDateTime start, LocalDateTime end) {
        this.start = start;
        this.end = end;
    }
    
    public LocalDateTime getStart() {
        return start;
    }
    
    public void setStart(LocalDateTime start) {
        this.start = start;
    }
    
    public LocalDateTime getEnd() {
        return end;
    }
    
    public void setEnd(LocalDateTime end) {
        this.end = end;
    }
    
    /**
     * 将Holiday转换为MaintenanceWindow
     * @return 对应的MaintenanceWindow对象
     */
    public MaintenanceWindow toMaintenanceWindow() {
        return new MaintenanceWindow(this.start, this.end, "Holiday Period");
    }
    
    /**
     * 将Holiday转换为MaintenanceWindow（可指定原因）
     * @param reason 维护原因
     * @return 对应的MaintenanceWindow对象
     */
    public MaintenanceWindow toMaintenanceWindow(String reason) {
        return new MaintenanceWindow(this.start, this.end, reason);
    }
}