package com.aps.controller;

import com.aps.entity.MaterialInfo;
import com.aps.entity.RoutingHeader;
import com.aps.service.MaterialInfoService;
import com.aps.service.RoutingHeaderService;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author MyBatis-Plus
 * @since 2025-10-09
 */

@RestController
@RequestMapping("/routingHeader")
@Tag(name = "测试接口", description = "工艺相关接口")
public class RoutingHeaderController {

    @Autowired
    RoutingHeaderService routingHeaderService;
    
    @Operation(summary = "获取工艺列表", description = "返回所有工艺数据")
    @GetMapping("/test")
    public RoutingHeader test(){
        return routingHeaderService.list().get(0);
    }
}