package com.aps.entity.Algorithm;

import com.aps.entity.Algorithm.IDAndChildID.GroupResult;
import com.aps.entity.basic.Entry;
import com.aps.entity.basic.Machine;
import com.aps.entity.basic.Order;
import lombok.Data;



import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

/**
 * 作者：佟礼
 * 时间：2025-11-21
 */
@Data
public class Chromosome {

    private String ID = UUID.randomUUID().toString();

    private Integer version=0;

    /// <summary>
    /// 机器选择部分（可选机器集中的顺序号）
    /// </summary>
    private List<Integer> machineSelection;

    /// <summary>
    /// 工序排序部分（工件/订单ID）
    /// </summary>
    private String machineStr;

    /// <summary>
    /// 机器选择部分 + 工序排序部分
    /// </summary>
    private String geneStr;

    public void  setMachineSelection(List<Integer> val) {
        machineSelection = val;
        machineStr = machineSelection.stream()
                .map(String::valueOf) // 将每个 Integer 转换为 String
                .collect(Collectors.joining(","));
        geneStr=machineStr+ "_" +operationStr;
    }



    /// <summary>
    /// 工序排序部分（工件/订单ID）
    /// </summary>
    private List<Integer> operationSequencing;

    public void  setOperationSequencing(List<Integer> val) {
        operationSequencing = val;
        operationStr = operationSequencing.stream()
                .map(String::valueOf) // 将每个 Integer 转换为 String
                .collect(Collectors.joining(","));
        geneStr=machineStr+ "_" +operationStr;
    }

    /// <summary>
    /// 工序排序部分（工件/订单ID）
    /// </summary>
    private String operationStr;





    private  List<GlobalOperationInfo> globalOpList;
    private  List<Entry> allOperations;
    private  List<Order> orders;
    private  List<Machine> InitMachines;

    private List<OrderMaterialRequirement> orderMaterials;

    private List<GroupResult> OperatRel;

    private ObjectiveWeights objectiveWeights;
    /*
    * 最早完工时间（最小化） 最小化总加工时间 最小总换型时间
     */
    private double[] Objectives ; // 多目标值：[Makespan, TotalFlowTime, TotalChangeover, LoadStd, Delay]
    private double[] MaxObjectives ; //
    private double[] MinObjectives ; //
    private int Rank; // 非支配排序等级（1最优）
    private double CrowdingDistance =0; // 拥挤距离 越小越优
    /*
    *(Objectives - min) / (max - min);
    */
    private double[] WeightedObjectives;//越靠近1越优
    private double WeightedObjective =0; // 加权目标值（用于自定义权重）
    /// <summary>
    /// 适应度值
    /// </summary>
    private double Fitness;

    /// <summary>
    /// 机器
    /// </summary>
    private List<Machine> Machines;

    /// <summary>
    /// 解码后的调度结果
    /// </summary>
    private List<GAScheduleResult> Result;

    /// <summary>
    /// 解码后的调度结果
    /// </summary>
    private List<GAScheduleResult> ResultOld=new CopyOnWriteArrayList<>();

    /// <summary>
    /// 最早完工时间
    /// </summary>
    private double Makespan;

    /// <summary>
    /// 总流程时间
    /// </summary>
    private double TotalFlowTime;

    /// <summary>
    /// 总换型时间
    /// </summary>
    private double TotalChangeoverTime;

    /// <summary>
    /// 机器负载标准差（越小越均衡）
    /// </summary>
    private double MachineLoadStd;

    /// <summary>
    /// 交付期延迟时间
    /// </summary>
    private double DelayTime;


    private String ScenarioID;

    private String ScenarioName;
    private LocalDateTime BaseTime ; // 当前基准时间



//
//    //最大设备利用率
//    private  double machineMaxRate;
//    //最小设备利用率
//    private  double machineMinRate;
////设备等待时长
//    private  double machineWaitTime;
//
//
////订单及时完成率
//    private  double orderOnTime;
//
//    //最大延迟
//    private  double orderMaxDelay;
//
//    //最小延迟
//    private  double orderMinDelay;
//
//    //平均延迟
//    private  double orderAvgDelay;
//
//    //最长生产周期
//    private  double orderMaxProductTime;
//
//    //最短生产周期
//    private  double orderMinProductTime;
//
//    //平均生产周期
//    private  double orderAvgProductTime;
//
//    //最大流量
//    private  double orderMaxFlow;
//
//    //最小流量
//    private  double orderMinFlow;
//
//    //平均流量
//    private  double orderAvgFlow;


    private  List<KpiMetrics> kpiMetrics;

}
