package com.aps.entity.Schedule;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class GenVO {
    private String orderId;       // 工单ID
    private Integer operationId;  // 工序ID
    private Long equipId;      // 设备ID
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startTime; // 实际开始时间
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endTime;   // 实际结束时间
    private BigDecimal quantity;   // 加工数量
    private String operationName; // 工序名称
    private String equipName;    // 设备名称
}