package com.aps.controller;

import com.aps.common.util.R;
import com.aps.entity.Algorithm.Chromosome;
import com.aps.entity.ProdSceneConfig;
import com.aps.service.LanuchService;
import com.aps.service.ProdSceneConfigService;
import com.aps.service.plan.PlanResultService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/lanuch")
@Tag(name = "启动工单", description = "启动工单接口")
public class LanuchController {

    @Autowired
    private LanuchService lanuchService;

    @Autowired
    private PlanResultService planResultService;

    @Autowired
    private ProdSceneConfigService prodSceneConfigService;

    /**
     * 启动工单
     */
    @PostMapping("/execute")
    @Operation(summary = "启动工单")
    public R<ProdSceneConfig> lanuch(@RequestBody Map<String, String> params) {
        String sceneName = params.get("sceneName");
        String userId = params.get("userId");

        return lanuchService.lanuch(sceneName, userId);
    }

    /**
     * 执行排程
     */
    @PostMapping("/schedule")
    @Operation(summary = "运算")
    public R<String> schedule(@RequestBody Map<String, String> params) {
        String sceneId = params.get("sceneId");
        
        // 如果需要处理时间字段，可以从params中获取并转换
        // 例如：开始时间、结束时间等
        String startTimeStr = params.get("startTime");
        String endTimeStr = params.get("endTime");
        
        // 在这里可以添加时间格式转换逻辑
        // 根据不同格式解析时间字符串
        
        Chromosome scheduleChromosomes = planResultService.schedule(sceneId);
        return R.ok("运算完成");
    }

    /**
     * 复制场景
     */
    @PostMapping("/copyScene")
    @Operation(summary = "复制场景")
    public R<ProdSceneConfig> copyScene(@RequestBody Map<String, String> params) {
        String oldSceneId = params.get("oldSceneId");
        String newSceneName = params.get("newSceneName");
        String userId = params.get("userId");

        return lanuchService.copyScene(oldSceneId, userId, newSceneName);
    }

    /**
     * 导出计划
     */
    @PostMapping("/exportPlan")
    @Operation(summary = "导出计划")
    public R<String> exportPlan(@RequestBody Map<String, String> params) {
        String sceneId = params.get("sceneId");

        return lanuchService.exportPlan(sceneId);
    }

    /**
     * 删除场景
     */
    @PostMapping("/deleteScene")
    @Operation(summary = "删除场景")
    public R<Boolean> deleteScene(@RequestBody Map<String, String> params) {
        String sceneId = params.get("sceneId");

        boolean result = prodSceneConfigService.deleteSceneById(sceneId);
        return result ? R.ok(true) : R.ok(false, "删除场景失败");
    }

    /**
     * 获取用户所有场景
     */
    @PostMapping("/getAllScene")
    @Operation(summary = "获取用户场景")
    public R<List<ProdSceneConfig>> getAllScene(@RequestBody Map<String, String> params) {
        String userId = params.get("userId");

        List<ProdSceneConfig> scenes = prodSceneConfigService.lambdaQuery()
                .eq(ProdSceneConfig::getCreateUser, userId)
                .list();
        return R.ok(scenes);
    }
}