package com.aps.service.impl;

import com.aps.entity.ApsTimeConfig;
import com.aps.mapper.ApsTimeConfigMapper;
import com.aps.service.ApsTimeConfigService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

/**
 * <p>
 * APS时间配置表 服务实现类
 * </p>
 *
 * @author MyBatis-Plus
 * @since 2025-12-23
 */
@Service
public class ApsTimeConfigServiceImpl extends ServiceImpl<ApsTimeConfigMapper, ApsTimeConfig> implements ApsTimeConfigService {
    
    @Override
    public ApsTimeConfig getConfig() {
        // 查询表中的唯一配置记录
        QueryWrapper<ApsTimeConfig> queryWrapper = new QueryWrapper<>();
        return this.getOne(queryWrapper);
    }
    
    @Override
    public boolean updateConfig(ApsTimeConfig config) {
        // 先删除所有配置记录（由于表只存一条数据）
        QueryWrapper<ApsTimeConfig> deleteWrapper = new QueryWrapper<>();
        this.remove(deleteWrapper);
        
        // 然后插入新配置
        return this.save(config);
    }
    
    @Override
    public boolean updateConfigFromMap(Map<String, Object> configMap) {
        ApsTimeConfig config = new ApsTimeConfig();
        
        // 从Map中提取并设置各个字段
        if (configMap.containsKey("baseTime") && configMap.get("baseTime") != null) {
            Object baseTimeObj = configMap.get("baseTime");
            if (baseTimeObj instanceof String) {
                // 如果是字符串格式，尝试解析为LocalDateTime
                try {
                    config.setBaseTime(LocalDateTime.parse((String) baseTimeObj, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                } catch (Exception e) {
                    // 如果格式不对，尝试其他格式
                    config.setBaseTime(LocalDateTime.parse((String) baseTimeObj));
                }
            } else if (baseTimeObj instanceof LocalDateTime) {
                config.setBaseTime((LocalDateTime) baseTimeObj);
            }
        }
        
        if (configMap.containsKey("freezeDate") && configMap.get("freezeDate") != null) {
            Object freezeDateObj = configMap.get("freezeDate");
            if (freezeDateObj instanceof BigDecimal) {
                config.setFreezeDate((BigDecimal) freezeDateObj);
            } else if (freezeDateObj instanceof Number) {
                config.setFreezeDate(new BigDecimal(freezeDateObj.toString()));
            } else if (freezeDateObj instanceof String) {
                config.setFreezeDate(new BigDecimal((String) freezeDateObj));
            }
        }
        
        if (configMap.containsKey("startCount") && configMap.get("startCount") != null) {
            Object startCountObj = configMap.get("startCount");
            if (startCountObj instanceof BigDecimal) {
                config.setStartCount((BigDecimal) startCountObj);
            } else if (startCountObj instanceof Number) {
                config.setStartCount(new BigDecimal(startCountObj.toString()));
            } else if (startCountObj instanceof String) {
                config.setStartCount(new BigDecimal((String) startCountObj));
            }
        }
        
        if (configMap.containsKey("endCount") && configMap.get("endCount") != null) {
            Object endCountObj = configMap.get("endCount");
            if (endCountObj instanceof BigDecimal) {
                config.setEndCount((BigDecimal) endCountObj);
            } else if (endCountObj instanceof Number) {
                config.setEndCount(new BigDecimal(endCountObj.toString()));
            } else if (endCountObj instanceof String) {
                config.setEndCount(new BigDecimal((String) endCountObj));
            }
        }
        
        // 使用先删除后插入的策略更新配置
        QueryWrapper<ApsTimeConfig> deleteWrapper = new QueryWrapper<>();
        this.remove(deleteWrapper);
        
        return this.save(config);
    }
}
