package com.aps.common.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class FileHelper {
    private static final String LOG_FILE = "schedule_log.txt";
    private static final String LOG_FILE_PATH = "log/";
    
    public static void writeLogFile(String message) {
        String date = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"))+"-";

        try (PrintWriter writer = new PrintWriter(new FileWriter(LOG_FILE_PATH+date+LOG_FILE, true))) {
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            writer.println("[" + timestamp + "] " + message);
            System.out.println("[" + timestamp + "] " + message);

        } catch (IOException e) {
            System.err.println("Failed to write log: " + e.getMessage());
        }
    }
}