package com.aps.service.Algorithm;

import com.aps.common.util.FileHelper;
import com.aps.common.util.ProductionDeepCopyUtil;
import com.aps.common.util.SpringContextUtil;
import com.aps.entity.Algorithm.*;
import com.aps.entity.DiscreteParameterDuration;
import com.aps.entity.ProdEquipment;
import com.aps.entity.Routingsupporting;
import com.aps.entity.basic.*;
import com.aps.service.DiscreteParameterDurationService;
import com.aps.service.DiscreteParameterMatrixService;
import com.aps.service.plan.MachineSchedulerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.DelegatingServerHttpResponse;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.*;
import java.util.stream.Collectors;
import java.util.concurrent.locks.ReentrantLock;

/**
 * 作者：佟礼
 * 时间：2025-11-24
 */



public class GeneticDecoder {
    private final Map<String, Chromosome> decodingCache = new HashMap<>();
    // 缓存大小限制
    private static final int MAX_CACHE_SIZE = 1000;
    // 线程安全锁：避免多线程下缓存操作冲突（可选，若单线程可移除）
    private final ReentrantLock cacheLock = new ReentrantLock();
    private LocalDateTime baseTime;
    private final List<Machine> machines;
    private final MachineSchedulerService machineScheduler;
    private final List<Order> orders;
    private int orderMaxID;
    private final List<Material> materials;
    private List<Entry> _allOperations;
    private GlobalParam _globalParam;
    private MachineCalculator machineCalculator;

    private List<OrderMaterialRequirement> orderMaterials;
    private DiscreteParameterMatrixService discreteParameterMatrixService;



    public GeneticDecoder(GlobalParam globalParam,LocalDateTime baseTime, List<Machine> machines, List<Order> orders,
                          List<Material> materials, MachineSchedulerService machineScheduler, List<OrderMaterialRequirement> _orderMaterials) {
        this.baseTime = baseTime;
        this.machines = machines;
        this.orders = orders;
        this.orders.forEach(t -> t.setSYQuantity(t.getQuantity()));
        this.materials = materials;
        this.machineScheduler = machineScheduler;
        _globalParam=globalParam;
         machineCalculator=new MachineCalculator(baseTime,machines,machineScheduler);
         orderMaterials=_orderMaterials;
       // this.orderMaxID = orders.stream().mapToInt(Order::getId).max().orElse(0);
    }

    public Chromosome decodeChromosomeWithCache(Chromosome chromosome) {
        String cacheKey = createCacheKey(chromosome);
       // FileHelper.writeLogFile("解码-----------开始-------"+chromosome.getID()+":"+cacheKey );

        _allOperations=chromosome.getAllOperations();
        if(orderMaterials!=null&&orderMaterials.size()>0&&_globalParam.isIsCheckSf()) {
            CreateNewOpSequence(chromosome);
        }

        // 1. 创建缓存键


        // 2. 尝试从缓存获取（加锁保证线程安全）
        cacheLock.lock();
        try {
            if (decodingCache.containsKey(cacheKey)) {
                // 缓存命中：复用缓存结果
                Chromosome cachedResult = decodingCache.get(cacheKey);
                // 赋值给染色体
               // chromosome.setInitMachines(ProductionDeepCopyUtil.deepCopyList(cachedResult.getInitMachines(),Machine.class));

                chromosome.setObjectives(cachedResult.getObjectives());
                chromosome.setMakespan(cachedResult.getMakespan());
                chromosome.setTotalFlowTime(cachedResult.getTotalFlowTime());
                chromosome.setTotalChangeoverTime(cachedResult.getTotalChangeoverTime());
                chromosome.setMachineLoadStd(cachedResult.getMachineLoadStd());
                chromosome.setDelayTime(cachedResult.getDelayTime());
                chromosome.setResult(ProductionDeepCopyUtil.deepCopyList(cachedResult.getResult(),GAScheduleResult.class));
               // Chromosome chromosomen= ProductionDeepCopyUtil.deepCopy(cachedResult);
              //  FileHelper.writeLogFile("解码-----------结束-------"+chromosome.getID());

                return chromosome;
            }
        } finally {
            cacheLock.unlock(); // 确保锁释放
        }
        // 3. 缓存未命中：执行解码逻辑
        decode(chromosome);

        // 4. 将解码结果存入缓存（加锁保证线程安全）
        cacheLock.lock();
        try {
            // 存储缓存：封装为 CacheValue 对象
            decodingCache.put(
                    cacheKey,
                    chromosome
            );

            // 5. 限制缓存大小（超过 1000 移除最早插入的键）
            if (decodingCache.size() > MAX_CACHE_SIZE) {

                Iterator<String> keyIterator = decodingCache.keySet().iterator();
                if (keyIterator.hasNext()) {
                    keyIterator.next(); // 获取首个键
                    keyIterator.remove(); // 移除首个键（对应 C# _decodingCache.Keys.First()）
                }
            }
        } finally {
            cacheLock.unlock();
        }
       // FileHelper.writeLogFile("解码-----------结束-------"+chromosome.getID());
        return  chromosome;
    }

    private void   CreateNewOpSequence(Chromosome chromosome)
    {

        List<Integer> finishedOrder = chromosome.getOrders().stream()
                .filter(t-> t.getFinishOrderId()==null||t.getFinishOrderId().size()==0)
                .map(Order::getId)
                .distinct()
                .collect(Collectors.toList());

if(finishedOrder==null||finishedOrder.size()==0)
{
    return;
}

        List<Integer> oldSequence=chromosome.getOperationSequencing();
        List<Integer> finalSequence = new ArrayList<>();
        // 初始化两个结果数组
        List<Integer> pfSequence = new ArrayList<>(); // 包含1/2的元素
        Map<Integer, List<Integer>> sfSequence = new HashMap<>(); // 不包含1/2的元素

        // 遍历原数组分类
        for (int num : oldSequence) {
            if (finishedOrder.contains(num)) {
                pfSequence.add(num);
            } else {
                if(sfSequence.containsKey(num))
                {
                    sfSequence.get(num).add(num);
                }else {
                    sfSequence.computeIfAbsent(num, k -> new ArrayList<>()).add(num);
                }
            }
        }


        Map<Integer, Integer> orderProcessCounter=new HashMap<>();
        for (int num : pfSequence) {
            int scheduledCount=1;
            if(orderProcessCounter.containsKey(num))
            {
                scheduledCount = orderProcessCounter.get(num)+1;
            }
            int scheduledCount1=scheduledCount;
            Entry entry=_allOperations.stream()
                    .filter(t->t.GroupId==num&&t.getSequence()==scheduledCount1)
                    .findFirst().orElse(null);
            if(entry!=null&&entry.getDependentOnOrderIds().size()>0)
            {
                for (int order : entry.getDependentOnOrderIds()) {

                    for (int num1 : sfSequence.get(order)){
                        InsertSimSequence(orderProcessCounter,num1,finalSequence,sfSequence);
                    }
                }

                finalSequence.add(num);
            }else {

                finalSequence.add(num);
            }
            orderProcessCounter.put(num, scheduledCount);
        }
        chromosome.setOperationSequencing(finalSequence);
    }

    private void InsertSimSequence(Map<Integer, Integer> orderProcessCounter,int orderid,List<Integer> finalSequence,Map<Integer, List<Integer>> sfSequence)
    {
        Random rnd = new Random();
        int scheduledCount=1;
        if(orderProcessCounter.containsKey(orderid))
        {
            scheduledCount = orderProcessCounter.get(orderid)+1;
        }
        int scheduledCount1=scheduledCount;
        Entry entry=_allOperations.stream()
                .filter(t->t.GroupId==orderid&&t.getSequence()==scheduledCount1)
                .findFirst().orElse(null);

        if(entry!=null&&entry.getDependentOnOrderIds().size()>0) {

            for (int order : entry.getDependentOnOrderIds()) {

                for (int num1 : sfSequence.get(order)) {
                    InsertSimSequence(orderProcessCounter,num1,finalSequence,sfSequence);
                }
            }
            finalSequence.add(orderid);
        }else {
            int insertPos = Math.max(0, finalSequence.size() - rnd.nextInt(2));
            finalSequence.add(insertPos,orderid);
        }
        orderProcessCounter.put(orderid, scheduledCount);
    }

    /**
     * 染色体解码为调度方案
     */
    public void decode(Chromosome chromosome) {

        List<GlobalOperationInfo> globalOpList=chromosome.getGlobalOpList();
        List<Entry> allOperations=chromosome.getAllOperations();
        _allOperations=chromosome.getAllOperations();
        Map<Integer, GlobalOperationInfo> globalOpMap = globalOpList.stream()
                .collect(Collectors.toMap(GlobalOperationInfo::getGlobalOpId, g -> g));

        // 验证：MachineSelection长度必须与全局工序数一致
        if (chromosome.getMachineSelection().size() != globalOpList.size()) {
            throw new IllegalArgumentException(String.format(
                    "MachineSelection长度（%d）与全局工序数（%d）不匹配！",
                    chromosome.getMachineSelection().size(), globalOpList.size()));
        }

        // 步骤1：生成“工序→机器/加工时间”映射
        List<OpMachine> opMachineMap = new ArrayList<>();
        for (GlobalOperationInfo globalOp : globalOpList) {
            int globalOpId = globalOp.getGlobalOpId();
            Entry op = globalOp.getOp();
            int groupId = globalOp.getGroupId();
            int sequence = globalOp.getSequence();

            // 从MachineSelection中获取当前工序的机器选择顺序号
            int machineSeq = chromosome.getMachineSelection().get(globalOpId);
            List<MachineOption> optionalMachines = op.getMachineOptions();

            // 验证：机器顺序号必须在可选范围内
            if (machineSeq < 1 || machineSeq > optionalMachines.size()) {
                throw new IllegalStateException(String.format(
                        "全局工序%d（订单%d工序%d）的机器顺序号%d超出范围（1-%d）",
                        globalOpId, groupId, sequence, machineSeq, optionalMachines.size()));
            }

            // 获取选择的设备ID和加工时间
            MachineOption selectedMachine = optionalMachines.get(machineSeq - 1);
            OpMachine opMachine=new OpMachine();
            opMachine.setGroupId(groupId);
            opMachine.setSequence(sequence);
            opMachine.setMachineId(selectedMachine.getMachineId());
            opMachine.setProcessingTime(selectedMachine.getProcessingTime());
            opMachineMap.add(opMachine);

        }

        // 步骤2：按OperationSequencing顺序调度工序
        Map<Integer, Integer> orderProcessCounter = allOperations.stream()
                .collect(Collectors.groupingBy(Entry::getGroupId, Collectors.collectingAndThen(
                        Collectors.counting(), Long::intValue)))
                .entrySet().stream()
                .collect(Collectors.toMap(Map.Entry::getKey, e -> 0));

        Map<Integer, Integer> orderLastEndTime = allOperations.stream()
                .collect(Collectors.groupingBy(Entry::getGroupId))
                .keySet().stream()
                .collect(Collectors.toMap(k -> k, k -> 0));

//        Map<Long, String> machineState = chromosome.getMachines().stream()
//                .collect(Collectors.toMap(Machine::getId, m -> ""));

      //  List<Entry> allScheduledOps = new ArrayList<>();

        for (int groupId : chromosome.getOperationSequencing()) {
            int scheduledCount = orderProcessCounter.get(groupId);
            List<Entry> orderOps = allOperations.stream()
                    .filter(t -> t.getGroupId() == groupId)
                    .sorted(Comparator.comparing(Entry::getSequence))
                    .collect(Collectors.toList());

            if (scheduledCount >= orderOps.size()) {
                throw new IllegalStateException(String.format(
                        "订单%d的工序已全部调度（共%d道），无需重复处理！",
                        groupId, orderOps.size()));
            }

            Entry currentOp = orderOps.get(scheduledCount);
            int opSequence = currentOp.getSequence();

            GAScheduleResult existingResult = chromosome.getResultOld().stream()
                    .filter(r-> r.getOperationId() == currentOp.getId())
                    .findFirst().orElse(null);
            if(existingResult!=null) {
                if(existingResult.isIsLocked())
                {
                    continue;
                }
            }

            // 从映射表中获取机器和加工时间
            OpMachine  machineOption=opMachineMap.stream()
                    .filter(m -> m.getGroupId() == groupId&&m.getSequence()==opSequence)
                    .findFirst()
                    .orElse(null);
            Long machineId = machineOption.getMachineId();
            double processTime = machineOption.getProcessingTime();

            Machine targetMachine = chromosome.getMachines().stream()
                    .filter(m -> m.getId() == machineId)
                    .findFirst()
                    .orElse(null);

            int prevtime = 0;

            if (!currentOp.getPrevEntryIds().isEmpty()) {
                // 处理多个前工序
                prevtime= CalPrevtime( prevtime, currentOp, chromosome, processTime, targetMachine);
            }

            // 上个离散参数
          //  String lastDiscreteParameter = machineState.get(machineId);

            int bomtime = getOperationBOMTime(currentOp,chromosome);
            prevtime = Math.max(prevtime, bomtime);

            Machine machine = chromosome.getMachines().stream()
                    .filter(m -> m.getId() == machineId)
                    .findFirst()
                    .orElse(null);

           // int changeoverTime =0; //(lastDiscreteParameter.isEmpty() ||
                   // lastDiscreteParameter.equals(currentOp.getDiscreteParameter())) ? 0 : 0;

            int actualEndTime = processWithSingleMachine(currentOp, machine, processTime, prevtime, chromosome);

            orderProcessCounter.put(groupId, orderProcessCounter.get(groupId) + 1);
            orderLastEndTime.put(groupId, actualEndTime);
          //  machineState.put(machineId, currentOp.getDiscreteParameter());
        }

        // 步骤4：计算调度指标
        calculateScheduleResult(chromosome);
    }



    private int processWithSingleMachine(Entry operation, Machine machine, double  processingTime,
                                         int prevOperationEndTime, Chromosome chromosome) {

        int  processingTimeTotal =(int)(processingTime * operation.getQuantity());
        MachineOption machineOption= operation.getMachineOptions().stream()
                .filter(t->t.getMachineId()==machine.getId())
                .findFirst().orElse(null);

        operation.setSelectMachineID(machine.getId());


        int teardownTime = machineOption.getTeardownTime();
        int preTime = machineOption.getPreTime();
        int setupTime = calculateSetupTime(chromosome.getResult(), operation, machine, machineOption);



//        FileHelper.writeLogFile("  开始    "+operation.getGroupId()+" : "+operation.getId()+",处理时间: " + processingTime + ", 后处理: " + teardownTime +
//                ", 前处理: " + preTime + ", 换型: " + setupTime+ ", 数量: " + operation.getQuantity()+ ", 设备: "+machine.getId()+ ", 是否可中断: "+operation.getIsInterrupt());


        // 确定任务的最早开始时间（基于前一道工序的完整结束时间，包含后处理）
        int earliestStartTime = prevOperationEndTime;

        // 检查设备上是否有前一个任务
        GAScheduleResult lastGeneOnMachine = chromosome.getResult().stream()
                .filter(g -> g.getMachineId() == machine.getId())
                .max(Comparator.comparingInt(GAScheduleResult::getEndTime))
                .orElse(null);

        if (lastGeneOnMachine != null) {
            int machineAvailableTime = lastGeneOnMachine.getEndTime();
            if (setupTime > 0) {
                if (_globalParam.is_smoothSetup()) {

                    machineAvailableTime += setupTime;
                    // 平滑模式：换型在非工作时间进行，不额外占用设备时间
//                    System.out.println("      平滑模式换型：在非工作时间进行，设备可用时间不变");
                } else {
                    // 标准模式：换型需要额外占用设备时间
                    machineAvailableTime += setupTime;
//                    System.out.println("      标准模式换型：需要额外占用设备 " + setupTime + " 分钟");
                }
            }

            earliestStartTime = Math.max(earliestStartTime, machineAvailableTime);
        }

//        System.out.println("      最终最早开始时间: " + earliestStartTime +
//                " (前序工序结束含后处理: " + prevOperationEndTime + ", 设备可用: " +
//                (lastGeneOnMachine != null ? lastGeneOnMachine.getEndTime() : 0) +
//                ", 换型: " + setupTime + ")");

        // 根据换型模式调整处理时间
      //  int processingTimeForScheduling;
        if (_globalParam.is_smoothSetup()) {
            // 平滑模式：只需要安排主处理时间
           // processingTimeForScheduling = processingTimeTotal;
//            System.out.println("      平滑模式：安排主处理时间 " + processingTime + " 分钟");
        } else {
            // 标准模式：需要安排主处理时间+换型时间
            processingTimeTotal = processingTimeTotal + setupTime;
          //  System.out.println("      标准模式：安排主处理+" + setupTime + "分钟换型=" + processingTimeTotal + "分钟");
        }

        GAScheduleResult existingResult = chromosome.getResultOld().stream().filter(r-> r.getOperationId() == operation.getId()).findFirst().orElse(null);
        if(existingResult!=null)
        {
            earliestStartTime = Math.max(earliestStartTime,existingResult.getDesignatedStartTime());
        }




        List<ScheduleResultDetail> geneDetails = machineCalculator.getNextAvailableTime(machine, earliestStartTime, -1,
                processingTimeTotal, chromosome.getResult(), operation.IsInterrupt!=1, true,processingTime, operation.getQuantity(), true);




        int startTime = geneDetails.stream()
                .mapToInt(ScheduleResultDetail::getStartTime)
                .min()
                .orElse(0);
        int endTime = geneDetails.stream()
                .mapToInt(ScheduleResultDetail::getEndTime)
                .max()
                .orElse(0);

        // 冲突检测和解决
        final int finalStartTime = startTime;
        final int finalEndTime = endTime;

        GAScheduleResult conflictingGene = chromosome.getResult().stream()
                .filter(g -> g.getMachineId() == machine.getId())
                .filter(g -> (finalStartTime < g.getEndTime() && finalEndTime > g.getStartTime()))
                .findFirst()
                .orElse(null);

        if (conflictingGene != null) {
//            System.out.println("      ⚠️ 检测到时间冲突，重新调度");
            int conflictSetupStartTime = conflictingGene.getEndTime();
            int conflictSetupTime = calculateSetupTimeForConflict(chromosome.getResult(),operation , machine, machineOption, conflictingGene);
            int conflictEarliestStartTime = conflictSetupStartTime + conflictSetupTime;

            machineCalculator.AddMachineAvailable(machine,geneDetails);

            /// 时间安排
            geneDetails = machineCalculator.getNextAvailableTime(machine, conflictEarliestStartTime, -1,
                    processingTimeTotal, chromosome.getResult(), false, true,processingTime, operation.getQuantity(), true);

            if (!geneDetails.isEmpty()) {
                 startTime = geneDetails.stream()
                        .mapToInt(ScheduleResultDetail::getStartTime)
                        .min()
                        .orElse(0);
                 endTime = geneDetails.stream()
                        .mapToInt(ScheduleResultDetail::getEndTime)
                        .max()
                        .orElse(0);
//                System.out.println("      重新安排时间: " + ConvertTime(startTime) + " - " + ConvertTime(endTime));
            }
        }


        GAScheduleResult result=new GAScheduleResult();
        result.setGroupId(operation.getGroupId());
        result.setOperationId(operation.getId());
        result.setExecId(operation.getExecId());
        result.setOrderId(operation.getOrderId());
        result.setOrderCode(operation.getOrderCode());
        result.setProductId(operation.getProductId());
        result.setProductName(operation.getProductName());
        result.setProductCode(operation.getProductCode());
        result.setMachineId(machine.getId());


        result.setStartTime(startTime);
        result.setEndTime(endTime);
        result.setOneTime(processingTime);
        result.setQuantity(operation.getQuantity());
        result.setChangeOverTime(setupTime);
        result.setPreTime(preTime);
        result.setTeardownTime(teardownTime);
        if(existingResult!=null) {
            result.setDesignatedStartTime(existingResult.getDesignatedStartTime());

        }


        result.setProcessingTime(processingTimeTotal);
        result.setGeneDetails(geneDetails);

//        System.out.println("huanxingshijian="+result.getChangeOverTime()+"-------------------"+result.getOrderId()+"--------"+result.getExecId()+"---------"+prev.getOrderId()+"--------"+prev.getExecId());
        chromosome.getResult().add(result);

//        FileHelper.writeLogFile("  结束    "+ConvertTime(startTime)+"--"+ConvertTime(endTime)+"   "+operation.getGroupId()+" : "+operation.getId()+",处理时间: " + processingTime + ", 后处理: " + teardownTime +
//                ", 前处理: " + preTime + ", 换型: " + setupTime+ ", 数量: " + operation.getQuantity()+ ", 设备: "+machine.getId()+ ", 是否可中断: "+operation.getIsInterrupt());


        return endTime;
    }

    /**
     * 计算前序结束时间
     * @param prevtime
     * @param currentOp
     * @param chromosome
     * @return
     */
    private  int CalPrevtime(int prevtime,Entry currentOp,Chromosome chromosome,double processTime,Machine machine) {
        List<OperationDependency> FsOperations = currentOp.getPrevEntryIds().stream()
                .filter(t -> t.getDependencyType() == DependencyType.FinishToStart)
                .collect(Collectors.toList());//串行
        if (FsOperations != null && FsOperations.size() > 0) {
            for (OperationDependency opid : FsOperations) {
                List<GAScheduleResult> prevOperations = chromosome.getResult().stream()
                        .filter(t -> t.getGroupId() == currentOp.GroupId && t.getOperationId() == opid.getPrevOperationId())
                        .collect(Collectors.toList());//多台
                for (GAScheduleResult prevOp : prevOperations) {
                    prevtime = Math.max(prevtime, prevOp.getEndTime() + prevOp.getTeardownTime());
                }
            }
        }
        List<OperationDependency> SSOperations = currentOp.getPrevEntryIds().stream()
                .filter(t -> t.getDependencyType() == DependencyType.StartToStart)
                .collect(Collectors.toList());//重叠
        if (SSOperations != null && SSOperations.size() > 0) {
            List<GAScheduleResult> newScheduleResult = new ArrayList<>();
            List<ScheduleResultDetail> newScheduleResultDetails = new ArrayList<>();

            for (OperationDependency opid : SSOperations) {

                List<GAScheduleResult> prevOperations = chromosome.getResult().stream()
                        .filter(t -> t.getGroupId() == currentOp.GroupId && t.getOperationId() == opid.getPrevOperationId())
                        .collect(Collectors.toList());//多台
                for (GAScheduleResult prevOp : prevOperations) {
                    newScheduleResult.add(prevOp);
                    newScheduleResultDetails.addAll(prevOp.getGeneDetails());



                }
            }

            int prevperationEndTime = newScheduleResult.stream()
                    .mapToInt(GAScheduleResult::getEndTime)
                    .max()
                    .orElse(0);
            prevtime = calculateNextOperationStartTime(newScheduleResult, newScheduleResultDetails, 0, processTime);
            // 下一工序结束时间需晚于上一工序结束时间一个产品加工时间
            double nextopplanend = prevperationEndTime + processTime;

            List<ScheduleResultDetail> geneDetails1 = machineCalculator.checkMachineStartTime(machine, (int) (processTime * currentOp.getQuantity()),
                    baseTime.plusSeconds((int) nextopplanend),
                    baseTime.plusSeconds(prevtime),
                    chromosome.getResult());

            if (geneDetails1 != null && !geneDetails1.isEmpty()) {
                prevtime = Math.max(prevtime,
                        geneDetails1.stream()
                                .mapToInt(ScheduleResultDetail::getStartTime)
                                .min()
                                .orElse(prevtime)
                );

            }
        }
        return prevtime;

    }

    private int getOperationBOMTime(Entry currentOp, Chromosome chromosome) {

        if(orderMaterials==null)
        {
            return  0;
        }

        List<OrderMaterialRequirement> opboms = orderMaterials.stream()
                .filter(t -> t.getOrderId().equals(currentOp.getOrderId()) && t.getOperationId() == currentOp.getId())
                .collect(Collectors.toList());
        int rawTime = 0, sfTime = 0;
        if (opboms != null && !opboms.isEmpty()) {
            // 计算RawTime
            if(_globalParam.isIsCheckMp()) {
                Optional<LocalDateTime> rawDateOpt = opboms.stream()
                        .filter(t -> t.getMaterialTypeName().equals("MP"))
                        .map(OrderMaterialRequirement::getUseTime)
                        .max(LocalDateTime::compareTo);
                if (rawDateOpt.isPresent()) {
                    rawTime = (int) Duration.between(baseTime, rawDateOpt.get()).getSeconds();
                }
            }

            // 计算SFTime
            List<OrderMaterialRequirement> sfBoms = opboms.stream()
                    .filter(t -> !t.getMaterialTypeName().equals("MP")
                            && t.getProductOrderID() != null && !t.getProductOrderID().isEmpty())
                    .collect(Collectors.toList());

            if (!sfBoms.isEmpty()&&sfBoms.size()>0) {
                for (OrderMaterialRequirement sf : sfBoms) {
                    for (int orderid : sf.getProductOrderID()) {
                        int sfTime1 = 0;
                        List<GAScheduleResult> result=chromosome.getResult();
                        List<GAScheduleResult> oe = result.stream()
                                .filter(t -> t.getGroupId() == orderid)
                                .collect(Collectors.toList());
                        if (!oe.isEmpty()) {
                            int CkeckLeadTime=0;
                            if(sf.getCheckLeadTime()!=null)
                            {
                                CkeckLeadTime=(int) (sf.getCheckLeadTime()*24*60);
                            }
                            sfTime1 = oe.stream().mapToInt(GAScheduleResult::getEndTime).max().orElse(0)
                                    +CkeckLeadTime;

                            sf.setUseTime(baseTime.plusSeconds(sfTime1));
                        }
                        sfTime = Math.max(sfTime, sfTime1);
                    }
                }
            }
        }
        return Math.max(rawTime, sfTime);
    }

    /**
     * 计算在上一工序生产后什么时间可以开工
     * @param details 工序详情列表
     * @param startindex 起始索引
     * @param time2 时间参数2
     * @return 可开工时间
     */
    private int calculateNextOperationStartTime(List<GAScheduleResult> results,List<ScheduleResultDetail> details,  int startindex,  double time2) {
       double qty= results.stream().mapToDouble(GAScheduleResult::getQuantity) // 替换为实际字段名
                .sum();

        double time1 = 0.0;
        for (GAScheduleResult r : results) {
            time1 += 1.0 / r.getOneTime();
        }

        int leadCount =(int) calculateLeadProductionItems(qty, time1, time2);

        if (leadCount == qty) {
            return details.stream()
                    .mapToInt(ScheduleResultDetail::getEndTime)
                    .max()
                    .orElse(0);
        }

        if (startindex > leadCount) {
            leadCount = startindex;
        }
        if(results.size()>1) {//多前置工序
            calculateWithMoreMachine(details, leadCount);
       }
        // 单设备时使用原逻辑
        return (int)calculateWithSingleMachine(details, leadCount, time1);
    }
       /**
     * 多设备并行时计算满足提前量的最早时间
     */
    private int calculateWithParallelMachines(List<ScheduleResultDetail> details, int leadCount, int time1) {
        // 收集所有设备的时间点（开始和结束）并去重排序
        Set<Integer> timePoints = new TreeSet<>();
        for (ScheduleResultDetail detail : details) {
            timePoints.add(detail.getStartTime());
            timePoints.add(detail.getEndTime());
        }
        List<Integer> sortedTimes = new ArrayList<>(timePoints);

        int accumulatedQty = 0;
        int prevTime = 0;

        for (int currTime : sortedTimes) {
            if (prevTime >= currTime) {
                prevTime = currTime;
                continue;
            }
            // 计算当前时间区间[prevTime, currTime)内的有效产能
            int duration = currTime - prevTime;
            int machinesWorking = 0;
            for (ScheduleResultDetail detail : details) {
                // 设备在当前区间内是否处于工作状态
                if (detail.getStartTime() <= prevTime && detail.getEndTime() >= currTime) {
                    machinesWorking++;
                }
            }
            // 区间内的产量（每台设备单位时间产能为1/time1，多设备累加）
            int qtyInInterval = (duration / time1) * machinesWorking;
            accumulatedQty += qtyInInterval;

            // 检查是否满足提前量
            if (accumulatedQty >= leadCount) {
                // 反推精确满足提前量的时间点
                int excess = accumulatedQty - leadCount;
                int timeNeeded = leadCount * time1 - (accumulatedQty - qtyInInterval) * time1;
                return prevTime + timeNeeded;
            }

            prevTime = currTime;
        }

        // 若所有时间点仍未满足，返回最后结束时间
        return details.stream().mapToInt(ScheduleResultDetail::getEndTime).max().orElse(0);
    }
    /**
     * 前置多工序多台，合并时间片段并计算满足前置产量的时间点
     * @param details 排产详情列表（包含开始时间、结束时间、单件工时）
     * @param leadCount 需要提前生产的数量
     * @return 满足前置产量的时间点
     */
    private int calculateWithMoreMachine(List<ScheduleResultDetail> details, int leadCount) {
        if (details == null || details.isEmpty() || leadCount <= 0) {
            return 0; // 边界条件处理
        }

        // 1. 收集所有时间点（开始和结束）并去重排序
        Set<Integer> timePoints = new TreeSet<>();
        for (ScheduleResultDetail detail : details) {
            timePoints.add(detail.getStartTime());
            timePoints.add(detail.getEndTime());
        }
        List<Integer> sortedTimes = new ArrayList<>(timePoints);
        if (sortedTimes.size() < 2) {
            return details.get(0).getEndTime(); // 无有效时间片段
        }

        // 2. 按时间片段计算累计产量
        double accumulatedQty = 0.0;
        for (int i = 0; i < sortedTimes.size() - 1; i++) {
            int startTime = sortedTimes.get(i);
            int endTime = sortedTimes.get(i + 1);
            int duration = endTime - startTime;
            if (duration <= 0) {
                continue; // 跳过无效时间段
            }

            // 计算当前时间段内所有运行的设备总效率（件/单位时间）
            //1秒生产的数量
            double totalEfficiency = details.stream()
                    .filter(detail -> detail.getStartTime() <= startTime
                            && detail.getEndTime() >= endTime)
                    .mapToDouble(detail -> 1.0 / detail.getOneTime()) // 单件工时的倒数即效率
                    .sum();

            // 当前时间段可生产的数量
            double segmentQty = totalEfficiency * duration;

            // 检查是否在当前时间段内满足前置产量
            if (accumulatedQty + segmentQty >= leadCount) {
                // 计算精确时间点（向上取整避免小数精度问题）
                double remainingQty = leadCount - accumulatedQty;
                int requiredTime = (int) Math.ceil(remainingQty / totalEfficiency);//数量除以每秒的数量，  每秒生产多少个，生产X用几秒
                return startTime + requiredTime;
            }

            accumulatedQty += segmentQty;
        }

        // 3. 所有片段累计仍未满足（返回最后结束时间）
        return details.stream()
                .mapToInt(ScheduleResultDetail::getEndTime)
                .max()
                .orElse(0);
    }

    /**
     * 单设备时使用原逻辑（保持兼容）
     */
    private double calculateWithSingleMachine(List<ScheduleResultDetail> details, int leadCount, double time1) {
        //上一工序的排产详情 - 需要提前生产出来的数量花费的时间
        double alltime = leadCount * time1;
        for (ScheduleResultDetail detail : details) {
            double time3 = alltime - detail.getProcessingTime();
            if (time3 < 0) {
                return detail.getEndTime() + time3;
            } else if (time3 == 0) {
                return detail.getEndTime();
            } else {
                alltime = time3;
            }
        }
        return details.get(details.size() - 1).getEndTime();
    }
    /**
     * 计算工序1需要提前生产的件数
     * @param qty 总订单量
     * @param time1 工序1单件工时
     * @param time2 工序2单件工时
     * @return 工序1需要提前生产的件数
     */
    private double calculateLeadProductionItems(double qty, double time1, double time2) {
        if (time1 < time2) {
            return 1;
        }
        if (qty <= 0 || time1 <= 0 || time2 <= 0) {
            throw new IllegalArgumentException("参数必须为正整数");
        }
        double totalTime1 = qty * time1;
        double totalTime2 = qty * time2;
        double timeDifference = totalTime2 - totalTime1;

        return (timeDifference / time1) > qty ? qty : (timeDifference / time1);
    }
    private String ConvertTime(int minute) {
        return baseTime.plusSeconds(minute).format(java.time.format.DateTimeFormatter.ofPattern("YYYY-MM-dd HH:mm"));
    }
    private int calculateSetupTime(List<GAScheduleResult> existingGenes, Entry operation, Machine machine, MachineOption machineOption) {
        GAScheduleResult lastGeneOnMachine = existingGenes.stream()
                .filter(g -> g.getMachineId() == machine.getId())
                .max(Comparator.comparingInt(GAScheduleResult::getEndTime))
                .orElse(null);

        if (lastGeneOnMachine == null) {
//            System.out.println("设备 " + machine.getId() + " 上无历史任务，换型时间为0");
            return 0;
        }
       Entry prev= _allOperations.stream().
                filter(t->t.getExecId().equals(lastGeneOnMachine.getExecId()))
                .findFirst().orElse(null);
        int setupTime=0;
        if(prev!=null)
        {
            //离散参数
          //  prev.getDiscreteParameter()

//            setupTime = (prev.getProductId() != operation.getProductId())
//                    ? (int) discreteParameterMatrixService.getDiscreteParameterMatrixValue(prev, operation)
//                    : 0;
            DiscreteParameterMatrixService service = SpringContextUtil.getBean(DiscreteParameterMatrixService.class);


                double discreteParameterMatrixValue = service.getDiscreteParameterMatrixValue( operation,prev);
                setupTime = (int) discreteParameterMatrixValue;



//                System.out.println("换型时间"+discreteParameterMatrixValue);
//                System.out.println(setupTime+"换型时间"+"huanxingshijian ");


        }

        operation.setChangeLineTime(setupTime);

//        System.out.println("换型时间111"+setupTime);

        return setupTime;
    }

    private int calculateSetupTimeForConflict(List<GAScheduleResult> existingGenes, Entry operation, Machine machine,
                                              MachineOption machineOption, GAScheduleResult conflictingGene) {
        int setupTime = (conflictingGene.getProductId() != operation.getProductId())
                ? machineOption.getSetupTime()
                : 0;

        if (existingGenes.stream().filter(g -> g.getMachineId() == machine.getId()).count() <= 1) {
            setupTime = 0;
        }

        if (setupTime > 0) {
//            System.out.println("设备 " + machine.getId() + " 需要换型，因为产品从 " + conflictingGene.getProductId() + " 变更为 " + operation.getProductId());
        }

        return setupTime;
    }

    private void calculateScheduleResult(Chromosome chromosome) {
        // 1. 最早完工时间（最小化）
        double makespan = chromosome.getResult().stream()
                .mapToInt(GAScheduleResult::getEndTime)
                .max()
                .orElse(0);

        // 2. 交付期满足情况（最小化延迟）
        double tardiness = 0;

        Map<Integer, List<GAScheduleResult>> orderGroups = chromosome.getResult().stream()
                .collect(Collectors.groupingBy(GAScheduleResult::getGroupId));

        for (Map.Entry<Integer, List<GAScheduleResult>> group : orderGroups.entrySet()) {
            int groupId = group.getKey();
            int orderCompletion = group.getValue().stream()
                    .mapToInt(GAScheduleResult::getEndTime)
                    .max()
                    .orElse(0);
            List<String> orderIds = group.getValue().stream()
                    .map(GAScheduleResult::getOrderId)
                    .distinct()
                    .sorted()
                    .collect(Collectors.toList());
            Order order = orders.stream()
                    .filter(t->orderIds.contains(t.getOrderId()))
                    .max(Comparator.comparing(Order::getDueDate))
                    .orElse(null);

            LocalDateTime dueDateTime=order.getDueDate();



            LocalDateTime completionTime =baseTime.plusSeconds(orderCompletion);


            if (completionTime.isAfter(dueDateTime)) {
                // 计算延迟小时数（修复时间计算）
                long hours = ChronoUnit.HOURS.between(dueDateTime, completionTime);
                long minutes = ChronoUnit.MINUTES.between(dueDateTime, completionTime) % 60;
                tardiness += hours*60 + (double) minutes ;
            }

        }

        // 3. 最小总换型时间
        double totalSetupTime = calculateTotalSetupTime(chromosome);

        // 4. 最小化总流程时间 所有工序加工时间的总和
        double totalFlowTime = calculateTotalFlowTime(chromosome);

        // 5. 机器负载均衡
        double machineLoadBalance = calculateMachineLoadBalance(chromosome);

        // 存储各目标值
        chromosome.setMakespan(makespan);
        chromosome.setTotalFlowTime(totalFlowTime);
        chromosome.setTotalChangeoverTime(totalSetupTime);
        chromosome.setMachineLoadStd(machineLoadBalance);
        chromosome.setDelayTime(tardiness);

        double[] Objectives=new double[5];
        Objectives[0] = makespan;
        Objectives[1] = totalFlowTime;
        Objectives[2] = totalSetupTime;
        Objectives[3] = machineLoadBalance;
        Objectives[4] = tardiness;
        chromosome.setObjectives(Objectives);
    }

    private double calculateTotalFlowTime(Chromosome chromosome) {
        return chromosome.getResult().stream()
                .mapToDouble(GAScheduleResult::getFlowTime)
                .sum();
    }



    // 计算总换型时间
    private double calculateTotalSetupTime(Chromosome chromosome) {
        return chromosome.getResult().stream()
                .mapToDouble(GAScheduleResult::getChangeOverTime)
                .sum();
    }

    // 计算机器负载均衡指标
    private double calculateMachineLoadBalance(Chromosome chromosome) {
        Map<Long, Double> machineUtilization = new HashMap<>();
        int sumWork = chromosome.getResult().stream()
                .mapToInt(GAScheduleResult::getFlowTime)
                .sum();//总的加工时间


        if (sumWork == 0) return 0;

        for (Machine machine : chromosome.getMachines()) {
            double busyTime = chromosome.getResult().stream()
                    .filter(g -> g.getMachineId() == machine.getId())
                    .mapToInt(g -> g.getFlowTime())
                    .sum();



            machineUtilization.put(machine.getId(), busyTime / sumWork);
        }

        double avgUtilization = machineUtilization.values().stream()
                .mapToDouble(Double::doubleValue)
                .sum()/ chromosome.getMachines().size();

        double variance = machineUtilization.values().stream()
                .mapToDouble(u -> Math.pow(u - avgUtilization, 2))
                .sum() / chromosome.getMachines().size();

        // 标准差与平均值的比值衡量负载离散程度，值越小说明均衡度越高
        return Math.sqrt(variance)/avgUtilization ;
    }
    /**
     * 补全：创建缓存键（核心逻辑，需与原 C# CreateCacheKey 一致）
     * 思路：将染色体的核心特征（机器选择+工序排序）拼接为字符串，确保相同染色体生成相同键
     */
    private String createCacheKey(Chromosome chromosome) {

        return  chromosome.getGeneStr();

        // 拼接机器选择：用 "," 分隔（例：1,3,2,4）
       // String machineStr = chromosome.getMachineStr();

        // 拼接工序排序：用 "|" 分隔（例：2|1|3|4）
      //  String operationStr = chromosome.getOperationStr();

        // 组合最终键（用 "_" 分隔两部分，避免冲突）
     //   return machineStr + "_" + operationStr;
    }
}
