package com.aps.demo;

import com.aps.ApsApplication;
import com.aps.entity.Algorithm.Chromosome;
import com.aps.entity.Gantt.ProductGanttVO;
import com.aps.entity.basic.Machine;
import com.aps.service.plan.PlanResultService;
import com.aps.service.plan.SceneService;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

import java.util.ArrayList;
import java.util.List;

@SpringBootTest(classes = ApsApplication.class)
public class PlanResultServiceTest {

    @Autowired
    private PlanResultService planResultService;

    @Autowired
    private SceneService sceneService;

    @Test
    public void testExecute() {
        planResultService.execute2("");
    }

    @Test
    public void testExecute2() {
        // 这里需要一个有效的SceneId来测试
        // 在实际测试中，您需要提供一个数据库中存在的SceneId
        String sceneId = "2BAB2BF160BE447EA6673DABACEF05D2";
        
        try {
//            Chromosome result = planResultService.execute2(sceneId);
//            System.out.println("执行成功，结果：" + (result != null ? "获得染色体对象" : "空结果"));
//
//            if (result != null) {
//                System.out.println("适应度: " + result.getFitness());
//                System.out.println("工序字符串: " + result.getOperationStr());
//            }
//            List<Double> splitCounts = new ArrayList<>();
//            splitCounts.add(10000.0);
//            splitCounts.add(10000.0);
//            splitCounts.add(10000.0);
//            splitCounts.add(10000.0);
//            splitCounts.add(10000.0);
////
////            planResultService.SpiltOperation(sceneId,1,splitCounts.toArray(new Double[0]));
//
//planResultService.SpiltOrder(sceneId,"2f24e563-1337-422b-a0ba-92da7e8c6584",splitCounts.toArray(new Double[0]));

            Chromosome schedule = sceneService.loadChromosomeFromFile(sceneId);

            // 转换为 ProductGanttVO 格式
            List<ProductGanttVO> productGanttVOList= new ArrayList<>();
            List<ProductGanttVO> resourceGanttVOs = planResultService.convertToProductGanttVO1(schedule);
            productGanttVOList.addAll(resourceGanttVOs);

            System.out.println("执行成功，结果：" + (productGanttVOList != null ? "获得染色体对象" : "空结果"));



        } catch (Exception e) {
            System.err.println("执行过程中发生异常: " + e.getMessage());
            e.printStackTrace();
        }
    }
}