package com.aps.entity.basic;
import com.aps.entity.MaterialPurchase;
import com.aps.entity.Stock;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * 物料实体类
 */
@Data
public class Material {
    /**
     * 物料ID
     */
    private String Id;

    /**
     * 物料名称
     */
    private String code;

    /**
     * 物料名称
     */
    private String name;

    /**
     * 当前库存
     */
    private double CurrentStock;

    /**
     * 库存详情
     */
    List<Stock> materialStocks=new ArrayList<>();

    /**
     * 在途物料（预计到货）
     */
    private List<MaterialSupply> InTransit = new ArrayList<>();

    /**
     * 原材料供应商 定义原材料采购周期，检验周期 价格
     */
    private List<MaterialPurchase> materialPurchases = new ArrayList<>();

    /**
     * 采购周期
     */
    private int PurchaseLeadTime;



    /**
     * 物料类型
     */
    private Long MaterialType;

    private String materialTypeName;

    /**
     * 检验周期
     */
    private Long CkeckLeadTime;

    @Override
    public String toString() {
        return "Material{" +
                "id=" + Id +
                ", name='" + name + '\'' +
                ", currentStock=" + CurrentStock +
                ", inTransit=" + InTransit +
                ", purchaseLeadTime=" + PurchaseLeadTime +
                ", type=" + MaterialType +
                '}';
    }
}

