package com.aps.service.Algorithm;

import com.aps.entity.Algorithm.Chromosome;

import java.util.List;

/**
 * 作者：佟礼
 * 时间：2025-11-24
 */
public class FitnessCalculator {
    /**
     * 多目标适应度计算（加权求和）
     */
    public double calculateFitness(Chromosome chromosome) {
        // 权重可根据实际需求调整
        double w1 = 0.3; // 最早完工时间（越小越好，归一化后取反）
        double w2 = 0.2; // 总流程时间（越小越好）
        double w3 = 0.15; // 总换型时间（越小越好）
        double w4 = 0.2; // 机器负载均衡（标准差越小越好）
        double w5 = 0.15; // 交付期延迟（越小越好）

        // 归一化（假设最大可能值，实际应根据问题规模调整）
        double normMakespan =1/ (1 +(double) chromosome.getMakespan());
        double normFlowTime = 1/ (1 + (double) chromosome.getTotalFlowTime() );
        double normChangeover = 1/ (1 + (double) chromosome.getTotalChangeoverTime());
        double normLoadStd =  chromosome.getMachineLoadStd();
        double normDelay = 1/ (1 + (double) chromosome.getDelayTime() );

        // 适应度值（越大越好）
        return w1 * normMakespan + w2 * normFlowTime + w3 * normChangeover + w4 * normLoadStd + w5 * normDelay;
    }
    /**
     * 计算种群适应度标准差（用于参数微调）
     * @param population 染色体种群数组
     * @return 适应度标准差
     */
    public double calculateFitnessStd(List<Chromosome> population) {
        int popSize = population.size();

        // 1. 计算平均适应度
        double avgFitness = 0.0f;
        for (Chromosome chromosome : population) {
            avgFitness += chromosome.getFitness();
        }
        avgFitness /= popSize;

        // 2. 计算每个个体与平均值的平方差之和
        float sumSqDiff = 0.0f;
        for (Chromosome chromosome : population) {
            double diff = chromosome.getWeightedObjective() - avgFitness;
            sumSqDiff += diff * diff;
        }

        // 3. 计算标准差
        return (double) Math.sqrt(sumSqDiff / popSize);
    }




}
