package com.aps.controller.gantt;


import com.aps.common.util.NumberUtils;
import com.aps.common.util.ParamValidator;
import com.aps.common.util.R;
import com.aps.entity.Algorithm.Chromosome;
import com.aps.entity.Algorithm.GAScheduleResult;
import com.aps.entity.basic.ScheduleChromosome;
import com.aps.entity.Gantt.ProductGanttVO;
import com.aps.entity.Gantt.ResourceGanttVO;
import com.aps.entity.Gantt.TaskVO;
import com.aps.entity.basic.*;
import com.aps.service.plan.PlanResultService;
import com.aps.service.plan.PlanSchedulerService;
import com.aps.service.plan.SceneService;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@RestController
@RequestMapping("/Gantt")
@Tag(name = "甘特图管理", description = "甘特图管理")
public class ResourceGanttController {

    @Autowired
    private PlanSchedulerService schedulingService;

    @Autowired
    private PlanResultService planResultService;

    @Autowired
    private SceneService sceneService;
    @GetMapping("/resourceGantt1")
    @Operation(summary = "获取资源甘特图数据", description = "获取资源甘特图数据")
    public List<ResourceGanttVO> getResourceGantt1(@RequestParam(required = false, defaultValue = "1") Long sceneId) {
        // 从PlanResultService获取ScheduleChromosome列表
        List<ScheduleChromosome> scheduleChromosomes = planResultService.execute();

        // 根据sceneId查找对应的ScheduleChromosome
        ScheduleChromosome targetChromosome = null;
        for (ScheduleChromosome chromosome : scheduleChromosomes) {
            if (chromosome.getSceneId() == sceneId) {
                targetChromosome = chromosome;
                break;
            }
        }

        // 如果找不到对应的场景，返回空列表
        if (targetChromosome == null) {
            return new ArrayList<>();
        }

        // 转换为 ResourceGanttVO 格式
        List<ResourceGanttVO> resourceGanttVOList = new ArrayList<>();
        List<ResourceGanttVO> resourceGanttVOs = convertToResourceGanttVO(targetChromosome);
        resourceGanttVOList.addAll(resourceGanttVOs);

        return resourceGanttVOList;
    }

    @GetMapping("/productGantt1")
    @Operation(summary = "获取产品甘特图数据", description = "获取产品甘特图数据")
    public List<ProductGanttVO> getProductGantt1(@RequestParam String sceneId) {
        // 从PlanResultService获取ScheduleChromosome列表
        List<ScheduleChromosome> scheduleChromosomes = planResultService.execute();

        // 根据sceneId查找对应的ScheduleChromosome
        ScheduleChromosome targetChromosome = null;
        for (ScheduleChromosome chromosome : scheduleChromosomes) {
            if (chromosome.getSceneId() == 1)  {
                targetChromosome = chromosome;
                break;
            }
        }

        // 如果找不到对应的场景，返回空列表
        if (targetChromosome == null) {
            return new ArrayList<>();
        }

        // 转换为 ProductGanttVO 格式
        List<ProductGanttVO> productGanttVOList = new ArrayList<>();
        List<ProductGanttVO> productGanttVOs = convertToProductGanttVO(targetChromosome);
        productGanttVOList.addAll(productGanttVOs);

        return productGanttVOList;
    }

    @GetMapping("/sceneIds")
    @Operation(summary = "获取所有场景ID", description = "获取所有场景ID")
    public List<String> getSceneIds() {
//        // 调用 PlanResultService 获取 ScheduleChromosome 列表
//        List<ScheduleChromosome> scheduleChromosomes = planResultService.execute();
//
//
//
//        // 提取所有场景ID
//        return scheduleChromosomes.stream()
//                .map(ScheduleChromosome::getSceneId)
//                .collect(Collectors.toList());

        ArrayList<String> strings = new ArrayList<>();
        strings.add("B571EF6682DB463AB2977B1055A74112");
        return strings;

    }

    @GetMapping("/getScene")
    @Operation(summary = "获取所有场景ID", description = "获取所有场景ID")
    public Chromosome getScene() {
        // 调用 PlanResultService 获取 ScheduleChromosome 列表
        Chromosome scheduleChromosomes = planResultService.execute1();

        // 提取所有场景ID
        return scheduleChromosomes;
    }

    @GetMapping("/getScene2")
    @Operation(summary = "获取所有场景ID", description = "获取所有场景ID")
    public Chromosome getScene2() {
        // 调用 PlanResultService 获取 ScheduleChromosome 列表
        Chromosome scheduleChromosomes = planResultService.execute2("B571EF6682DB463AB2977B1055A74112");

        // 提取所有场景ID
        return scheduleChromosomes;
    }

    @PostMapping("/operationMove")
    @Operation(summary = "操作移动", description = "操作移动")
    public R<String> operationMove(@RequestBody Map<String, Object> params) {

        // 1. 提取参数
        String sceneId = ParamValidator.getString(params, "sceneId", "场景ID");
        Integer opid = ParamValidator.getInteger(params, "id", "操作ID");
        LocalDateTime newStartTime = ParamValidator.getDateTime(params, "newStartTime", "新的开始时间");
        Long newMachineId = ParamValidator.getLong(params, "newMachineId", "新机器ID");

        // 2. 验证场景
        ParamValidator.validateSceneExists(sceneService, sceneId);

        // 3. 执行业务
        Chromosome result = planResultService.Move(sceneId, opid, newStartTime, newMachineId);

        return R.ok("移动成功");
    }

    @PostMapping("/operationedit")
    @Operation(summary = "修改工单", description = "修改工单")
    public R<Chromosome> operationedit(@RequestBody Map<String, Object> params) {
        log.info("operationedit 请求参数: {}", params);

        String sceneId = ParamValidator.getString(params, "sceneId", "场景ID");
        ParamValidator.validateSceneExists(sceneService, sceneId);

        // 处理Entry对象
        Entry entry = (Entry) params.get("operation");


        Chromosome result = planResultService.EditOperation(sceneId, entry);
        return R.ok(result);
    }

    @PostMapping("/changebasetime")
    @Operation(summary = "修改基础时间", description = "修改基础时间")
    public R<String> changeBaseTime(@RequestBody Map<String, Object> params) {
        log.info("changeBaseTime 请求参数: {}", params);

        String sceneId = ParamValidator.getString(params, "sceneId", "场景ID");
        LocalDateTime baseTime = ParamValidator.getDateTime(params, "baseTime", "基础时间");
        ParamValidator.validateSceneExists(sceneService, sceneId);

        Chromosome result = planResultService.ChangeBaseTime(sceneId, baseTime);
        return R.ok("保存成功");
    }

    @PostMapping("/operationspilt")
    @Operation(summary = "工单拆分", description = "工单拆分")
    public R<String> spiltOperation(@RequestBody Map<String, Object> params) {
        log.info("spiltOperation 请求参数: {}", params);

        String sceneId = ParamValidator.getString(params, "sceneId", "场景ID");
        Integer opid = ParamValidator.getInteger(params, "id", "操作ID");
        List<?> splitCounts = ParamValidator.getList(params, "splitCounts", "拆分数量");

        // 类型转换
        Double[] splitCountsArray = ParamValidator.convertToDoubleArray(splitCounts, "拆分数量");
        ParamValidator.validateSceneExists(sceneService, sceneId);

        Chromosome result = planResultService.SpiltOperation(sceneId, opid, splitCountsArray);
        return R.ok("拆分成功");
    }




    @PostMapping("/operationdel")
    @Operation(summary = "删除工单", description = "删除工单")
    public R<String> delOperation(@RequestBody Map<String, Object> params) {
        log.info("delOperation 请求参数: {}", params);

        String sceneId = ParamValidator.getString(params, "sceneId", "场景ID");
        Integer opid = ParamValidator.getInteger(params, "id", "操作ID");
        ParamValidator.validateSceneExists(sceneService, sceneId);

        Chromosome result = planResultService.DelOperation(sceneId, opid);
        return R.ok("删除成功");
    }

    @PostMapping("/operationlocked")
    @Operation(summary = "工单锁定", description = "订工单锁定")
    public R<String> lockedOperation(@RequestBody Map<String, Object> params) {
        log.info("lockedOperation 请求参数: {}", params);

        String sceneId = ParamValidator.getString(params, "sceneId", "场景ID");
        Integer opid = ParamValidator.getInteger(params, "id", "操作ID");
        Boolean isLocked = ParamValidator.getBoolean(params, "locked", "锁定状态");
        ParamValidator.validateSceneExists(sceneService, sceneId);

        Chromosome result = planResultService.LockOperation(sceneId, opid, isLocked);
        return R.ok("锁定成功");
    }

    @PostMapping("/orderspilt")
    @Operation(summary = "订单拆分", description = "订单拆分")
    public R<String> spiltOrder(@RequestBody Map<String, Object> params) {
        log.info("spiltOrder 请求参数: {}", params);

        String sceneId = ParamValidator.getString(params, "sceneId", "场景ID");
        String orderid = ParamValidator.getString(params, "orderid", "订单ID");
        List<?> splitCounts = ParamValidator.getList(params, "splitCounts", "拆分数量");

        Double[] splitCountsArray = ParamValidator.convertToDoubleArray(splitCounts, "拆分数量");
        ParamValidator.validateSceneExists(sceneService, sceneId);

        Chromosome result = planResultService.SpiltOrder(sceneId, orderid, splitCountsArray);
        return R.ok("拆分成功");
    }



    @PostMapping("/orderCopy")
    @Operation(summary = "订单复制", description = "订单复制")
    public R<String> copyOrder(@RequestBody Map<String, Object> params) {
        log.info("copyOrder 请求参数: {}", params);

        String sceneId = ParamValidator.getString(params, "sceneId", "场景ID");
        String orderid = ParamValidator.getString(params, "orderId", "订单ID");
        Double copyCount = ParamValidator.getDouble(params, "copyCount", "复制数量");

        Double[] splitCountsArray = new Double[2]; // 创建一个空的Double数组，可以根据实际需求调整大小或初始化值
        splitCountsArray[0] = 0.0;
        splitCountsArray[1] = copyCount;

        ParamValidator.validateSceneExists(sceneService, sceneId);

        Chromosome result = planResultService.SpiltOrder(sceneId, orderid, splitCountsArray);
        return R.ok("复制成功");
    }







    @PostMapping("/ordermerge")
    @Operation(summary = "订单合并", description = "订单合并")
    public R<String> orderMerge(@RequestBody Map<String, Object> params) {
        log.info("orderMerge 请求参数: {}", params);

        String sceneId = ParamValidator.getString(params, "sceneId", "场景ID");
        String sourceorderid = ParamValidator.getString(params, "sourceorderid", "源订单ID");
        String targetorderid = ParamValidator.getString(params, "targetorderid", "目标订单ID");
        ParamValidator.validateSceneExists(sceneService, sceneId);

        Chromosome result = planResultService.MergeOrder(sceneId, sourceorderid, targetorderid);
        return R.ok("合并成功");
    }

    /**
     * 将 ScheduleChromosome 转换为 ResourceGanttVO 列表
     * @param scheduleChromosome 调度结果
     * @return 转换后的数据
     */
    private List<ResourceGanttVO> convertToResourceGanttVO(ScheduleChromosome scheduleChromosome) {
        List<ResourceGanttVO> resourceGanttVOList = new ArrayList<>();

        // 遍历所有机器资源
        if (scheduleChromosome.getMachines() != null) {
            for (int i = 0; i < scheduleChromosome.getMachines().size(); i++) {
                Machine machine = scheduleChromosome.getMachines().get(i);

                ResourceGanttVO resourceGanttVO = new ResourceGanttVO();
                resourceGanttVO.setId(machine.getId());
                resourceGanttVO.setName(machine.getName() != null ? machine.getName() : "设备-" + machine.getId());
                resourceGanttVO.setType("设备类型"+machine.getId()); // 需要从原始数据获取
                resourceGanttVO.setChange(0); // 默认值
                resourceGanttVO.setSplit(0); // 默认值
                resourceGanttVO.setDepartmentId(machine.getId()); // 默认值
                resourceGanttVO.setDepartmentName(machine.getId()+"号线"); // 默认值
                resourceGanttVO.setShopName(machine.getId()+"车间"); // 默认值
                resourceGanttVO.setShopId(machine.getId()); // 默认值
                resourceGanttVO.setCode("设备编码-" + machine.getId()); // 默认值
                resourceGanttVO.setShift(convertToVO(machine));
                // 转换任务列表
                List<TaskVO> taskVOList = new ArrayList<>();
                if (scheduleChromosome.getGenes() != null) {
                    // 筛选出属于当前设备的任务
                    List<Gene> machineGenes = scheduleChromosome.getGenes().stream()
                            .filter(gene -> gene.getMachineId()==(machine.getId()))
                            .collect(Collectors.toList());

                    // 按开始时间排序
                    machineGenes.sort((g1, g2) -> Integer.compare(g1.getStartTime(), g2.getStartTime()));

                    for (Gene gene : machineGenes) {
                        TaskVO taskVO = new TaskVO();
                        taskVO.setId(String.valueOf(gene.getId())); // 临时处理
                        taskVO.setPlanId(String.valueOf(gene.getOrderId())); // 默认值
                        taskVO.setProductType(0); // 默认值
                        taskVO.setProductName("产品"+gene.getProductId());
                        taskVO.setProductId(String.valueOf(gene.getProductId())); // 默认值
                        taskVO.setQuantity(gene.getBatchSize());
                        taskVO.setStart(scheduleChromosome.getBaseTime().plusMinutes(gene.getAbsoluteStartTime()));
                        taskVO.setEnd(scheduleChromosome.getBaseTime().plusMinutes(gene.getAbsoluteEndTime()));
                        taskVO.setSetup(gene.getAbsolutePreparationTime()*60); // 默认值
                        taskVO.setTeardown(gene.getAbsoluteTeardownTime()*60); // 默认值
                        taskVO.setEquipChange(gene.getSetupTime()*60); // 默认值
                        taskVO.setEquipCooling(0); // 默认值
                        taskVO.setEquipType(resourceGanttVO.getType());
                        taskVO.setEquipName(resourceGanttVO.getName());
//                        taskVO.setDuration(calculateDuration(
//                                scheduleChromosome.getBaseTime().plusMinutes(gene.getStartTime()),
//                                scheduleChromosome.getBaseTime().plusMinutes(gene.getEndTime()))); // 计算持续时间

                        taskVO.setDuration(0); //
                        taskVO.setEquipId(machine.getId());
                        taskVO.setShopId(machine.getId());
                        taskVO.setShopName(resourceGanttVO.getShopName());
                        taskVO.setStatus(0); // 默认值

                        taskVO.setDetailId((long) gene.getProductId() * 1000 + gene.getOperationId()); // 将productId和operationID组合为detailId
                        taskVO.setHeaderId(gene.getProductId()); // 默认值
                        taskVO.setHeaderName("工艺"+gene.getProductId()); // 默认值
                        taskVO.setSeq(gene.getSequenceId()); // 使用工序ID
                        taskVO.setSeqName( "工序名称"+gene.getSequenceId());
                        taskVO.setProcessingTime((int)gene.getProcessingTime()*60);
                        taskVO.setAbsoluteStart(scheduleChromosome.getBaseTime().plusMinutes(gene.getStartTime()));
                        taskVO.setAbsoluteEnd(scheduleChromosome.getBaseTime().plusMinutes(gene.getEndTime()));
                        taskVOList.add(taskVO);

                        // 调试：检查machine中的shifts状态
//                        if (machine.getShifts() != null) {
//                            for (Shift shift : machine.getShifts()) {
//                                System.out.println("Before setting shifts - Shift status: " + shift.getStatus());
//                            }
//                        }

                        taskVO.setAbsolutePreparationTime(gene.getTeardownTime());



                    }
                }

                resourceGanttVO.setList(taskVOList);
                resourceGanttVOList.add(resourceGanttVO);
            }
        }

        return resourceGanttVOList;
    }

    /**
     * 将 ScheduleChromosome 转换为 ProductGanttVO 列表
     * @param scheduleChromosome 调度结果
     * @return 转换后的数据
     */
    private List<ProductGanttVO> convertToProductGanttVO(ScheduleChromosome scheduleChromosome) {
        List<ProductGanttVO> productGanttVOList = new ArrayList<>();

        // 按产品ID和工单ID分组基因
        if (scheduleChromosome.getGenes() != null) {
            // 按工单ID分组
            scheduleChromosome.getGenes().stream()
                    .collect(Collectors.groupingBy(Gene::getOrderId))
                    .forEach((orderId, genes) -> {
                        if (!genes.isEmpty()) {
                            ProductGanttVO productGanttVO = new ProductGanttVO();
                            Gene firstGene = genes.get(0);
                            productGanttVO.setId(String.valueOf(firstGene.getId()));
                            productGanttVO.setProductName("产品"+firstGene.getProductId()); // 默认值，实际应从订单数据获取
                            productGanttVO.setProductType(0);
                            productGanttVO.setProductId(String.valueOf(firstGene.getProductId()));
                            // 计算总数量（假设同一批次）
                            productGanttVO.setQuantity(firstGene.getBatchSize());
                            productGanttVO.setCode("编号"+firstGene.getProductId()); // 默认值
                            productGanttVO.setShopId(firstGene.getMachineId()); // 默认值
                            productGanttVO.setShopName(firstGene.getMachineId()+"号线"); // 默认值
                            productGanttVO.setStatus("已发布");
                            productGanttVO.setHeaderId(firstGene.getProductId());
                            productGanttVO.setHeaderName("工艺"+firstGene.getProductId()); // 默认值

                            // 计算开始和结束时间
                            int minStartTime = genes.stream()
                                    .mapToInt(Gene::getStartTime)
                                    .min()
                                    .orElse(0);
                            int maxEndTime = genes.stream()
                                    .mapToInt(Gene::getEndTime)
                                    .max()
                                    .orElse(0);

                            productGanttVO.setStartDate(scheduleChromosome.getBaseTime().plusMinutes(minStartTime));
                            productGanttVO.setEndDate(scheduleChromosome.getBaseTime().plusMinutes(maxEndTime));

                            // 转换任务列表
                            List<TaskVO> taskVOList = new ArrayList<>();
                            // 按工序顺序排序
                            genes.sort((g1, g2) -> Integer.compare(g1.getSequenceId(), g2.getSequenceId()));

                            for (int i = 0; i < genes.size(); i++) {
                                Gene gene = genes.get(i);
                                TaskVO taskVO = new TaskVO();
                                taskVO.setId(String.valueOf(gene.getId())); // 生成唯一ID
                                taskVO.setPlanId(String.valueOf(orderId));
                                taskVO.setProductType(0);
                                taskVO.setProductName("产品"+gene.getProductId());
                                taskVO.setProductId(String.valueOf(gene.getProductId()));
                                taskVO.setQuantity(gene.getBatchSize());
                                taskVO.setStart(scheduleChromosome.getBaseTime().plusMinutes(gene.getAbsoluteStartTime()));
                                taskVO.setEnd(scheduleChromosome.getBaseTime().plusMinutes(gene.getAbsoluteEndTime()));
                                taskVO.setSetup(gene.getAbsolutePreparationTime()*60); // 默认值
                                taskVO.setTeardown(gene.getAbsoluteTeardownTime()*60); // 默认值
                                taskVO.setEquipChange(gene.getSetupTime()*60); // 默认值
                                taskVO.setEquipCooling(0); // 默认值
//                            taskVO.setEquipType("PTT-" + (i+1) + "-" + gene.getOperationName().toUpperCase().substring(0, Math.min(3, gene.getOperationName().length())));
//                            taskVO.setEquipName(gene.getOperationName());
                                taskVO.setDuration(calculateDuration(
                                        scheduleChromosome.getBaseTime().plusMinutes(gene.getStartTime()),
                                        scheduleChromosome.getBaseTime().plusMinutes(gene.getEndTime())));
                                taskVO.setEquipId(gene.getMachineId()); // 生成设备ID
                                taskVO.setShopId(gene.getMachineId());
                                taskVO.setShopName(gene.getMachineId()+"车间");
                                taskVO.setStatus(0);
                                taskVO.setDetailId((long) gene.getProductId() * 1000 + gene.getOperationId());
                                taskVO.setHeaderId(gene.getProductId());
                                taskVO.setHeaderName("工艺"+gene.getProductId());
                                taskVO.setSeq(gene.getSequenceId());
                                taskVO.setSeqName("工序名称"+gene.getSequenceId());
                                taskVO.setAbsoluteStart(scheduleChromosome.getBaseTime().plusMinutes(gene.getStartTime()));
                                taskVO.setAbsoluteEnd(scheduleChromosome.getBaseTime().plusMinutes(gene.getEndTime()));

                                taskVOList.add(taskVO);
                            }

                            productGanttVO.setList(taskVOList);
                            productGanttVOList.add(productGanttVO);
                        }
                    });
        }

        return productGanttVOList;
    }

    /**
     * 计算任务持续时间（分钟）
     * @param start 开始时间
     * @param end 结束时间
     * @return 持续时间（分钟）
     */
    private Integer calculateDuration(LocalDateTime start, LocalDateTime end) {
        if (start == null || end == null) {
            return 0;
        }
        return Math.toIntExact(java.time.Duration.between(start, end).toMinutes());
    }


    private ShiftVO convertToVO(Machine machine) {
        ShiftVO shiftVO= new ShiftVO();
        shiftVO.setId(machine.getId());
        shiftVO.setName(machine.getName());
        shiftVO.setShifts(machine.getShifts());
        shiftVO.setMaintenanceWindows(machine.getMaintenanceWindows());
        // 注意：tasks 字段需要在其他地方设置，因为 Machine 类中没有任务信息
        return shiftVO;
    }






    private List<ResourceGanttVO> convertToResourceGanttVO1(Chromosome scheduleChromosome) {
        List<ResourceGanttVO> resourceGanttVOList = new ArrayList<>();

        List<Machine> machineList = planResultService.InitCalendarToAllMachines1(scheduleChromosome.getScenarioID());
        // 遍历所有机器资源
        if (machineList != null) {
            for (int i = 0; i < machineList.size(); i++) {
                Machine machine = machineList.get(i);

                ResourceGanttVO resourceGanttVO = new ResourceGanttVO();
                resourceGanttVO.setId(machine.getId());
                resourceGanttVO.setName(machine.getId()+"号设备");
                resourceGanttVO.setShift(convertToVO(machine));
                // 转换任务列表
                List<TaskVO> taskVOList = new ArrayList<>();
                if (scheduleChromosome.getResult() != null) {
                    // 筛选出属于当前设备的任务
                    List<GAScheduleResult> machineGenes = scheduleChromosome.getResult().stream()
                            .filter(gene -> gene.getMachineId()==(machine.getId()))
                            .collect(Collectors.toList());

                    // 按开始时间排序
                    machineGenes.sort((g1, g2) -> Integer.compare(g1.getStartTime(), g2.getStartTime()));

                    for (GAScheduleResult gene : machineGenes) {
                        TaskVO taskVO = new TaskVO();
//                        taskVO.setId(gene.getId()); // 临时处理
                        taskVO.setPlanId(gene.getOrderId()); // 默认值
//                        taskVO.setProductType(0); // 默认值
//                        taskVO.setProductName("产品"+gene.getProductId());
                        taskVO.setProductId(gene.getProductId()); // 默认值
                        taskVO.setQuantity(gene.getQuantity());
                        taskVO.setStart(scheduleChromosome.getBaseTime().plusSeconds(gene.getStartTime()));
                        taskVO.setEnd(scheduleChromosome.getBaseTime().plusSeconds(gene.getEndTime()));
                        taskVO.setSetup(0); // 默认值
                        taskVO.setTeardown(gene.getTeardownTime()); // 默认值
                        taskVO.setEquipChange(gene.getChangeoverTime()); // 默认值
                        taskVO.setEquipCooling(0); // 默认值
                        taskVO.setEquipType(resourceGanttVO.getType());
                        taskVO.setEquipName(resourceGanttVO.getName());
//                        taskVO.setDuration(calculateDuration(
//                                scheduleChromosome.getBaseTime().plusMinutes(gene.getStartTime()),
//                                scheduleChromosome.getBaseTime().plusMinutes(gene.getEndTime()))); // 计算持续时间

                        taskVO.setDuration(0); //
                        taskVO.setEquipId(machine.getId());
                        taskVO.setShopId(machine.getId());
                        taskVO.setShopName(resourceGanttVO.getShopName());
                        taskVO.setStatus(0); // 默认值

                        taskVO.setDetailId((long) gene.getStartTime()); // 将productId和operationID组合为detailId
                        taskVO.setHeaderId(gene.getEndTime()); // 默认值
//                        taskVO.setHeaderName("工艺"+gene.getProductId()); // 默认值
//                        taskVO.setSeq(gene.getSequenceId()); // 使用工序ID
//                        taskVO.setSeqName( "工序名称"+gene.getSequenceId());
                        taskVO.setProcessingTime(gene.getProcessingTime());
//                        taskVO.setAbsoluteStart(scheduleChromosome.getBaseTime().plusMinutes(gene.getStartTime()));
//                        taskVO.setAbsoluteEnd(scheduleChromosome.getBaseTime().plusMinutes(gene.getEndTime()));
                        taskVOList.add(taskVO);

                        // 调试：检查machine中的shifts状态
//                        if (machine.getShifts() != null) {
//                            for (Shift shift : machine.getShifts()) {
//                                System.out.println("Before setting shifts - Shift status: " + shift.getStatus());
//                            }
//                        }

                        taskVO.setAbsolutePreparationTime(gene.getTeardownTime());



                    }
                }

                resourceGanttVO.setList(taskVOList);
                resourceGanttVOList.add(resourceGanttVO);
            }
        }

        return resourceGanttVOList;
    }





    /**
     * 将 ScheduleChromosome 转换为 ProductGanttVO 列表
     * @param scheduleChromosome 调度结果
     * @return 转换后的数据
     */
    private List<ProductGanttVO> convertToProductGanttVO1(Chromosome scheduleChromosome) {
        List<ProductGanttVO> productGanttVOList = new ArrayList<>();

        // 按产品ID和工单ID分组基因
        if (scheduleChromosome.getResult() != null) {
            // 按工单ID分组
            scheduleChromosome.getResult().stream()
                    .collect(Collectors.groupingBy(GAScheduleResult::getOrderId))
                    .forEach((orderId, genes) -> {
                        if (!genes.isEmpty()) {
                            ProductGanttVO productGanttVO = new ProductGanttVO();
                            GAScheduleResult firstGene = genes.get(0);
                            productGanttVO.setId(firstGene.getOrderId());
                            productGanttVO.setProductName("产品"+firstGene.getProductId()); // 默认值，实际应从订单数据获取
                            productGanttVO.setProductType(0);
                            productGanttVO.setProductId(firstGene.getProductId());
                            // 计算总数量（假设同一批次）
                            productGanttVO.setQuantity(firstGene.getQuantity());
                            productGanttVO.setCode("编号"+firstGene.getProductId()); // 默认值
                            productGanttVO.setShopId(firstGene.getMachineId()); // 默认值
                            productGanttVO.setShopName(firstGene.getMachineId()+"号线"); // 默认值
                            productGanttVO.setStatus("已发布");
//                            productGanttVO.setHeaderId(firstGene.getProductId());
                            productGanttVO.setHeaderName("工艺"+firstGene.getProductId()); // 默认值

                            // 计算开始和结束时间
                            int minStartTime = genes.stream()
                                    .mapToInt(GAScheduleResult::getStartTime)
                                    .min()
                                    .orElse(0);
                            int maxEndTime = genes.stream()
                                    .mapToInt(GAScheduleResult::getEndTime)
                                    .max()
                                    .orElse(0);

                            productGanttVO.setStartDate(scheduleChromosome.getBaseTime().plusMinutes(minStartTime));
                            productGanttVO.setEndDate(scheduleChromosome.getBaseTime().plusMinutes(maxEndTime));

                            // 转换任务列表
                            List<TaskVO> taskVOList = new ArrayList<>();
//                            // 按工序顺序排序
//                            genes.sort((g1, g2) -> Integer.compare(g1.getSequenceId(), g2.getSequenceId()));

                            for (int i = 0; i < genes.size(); i++) {
                                GAScheduleResult gene = genes.get(i);
                                TaskVO taskVO = new TaskVO();
                                taskVO.setId(gene.getOrderId()); // 生成唯一ID
                                taskVO.setPlanId(String.valueOf(orderId));
                                taskVO.setProductType(0);
                                taskVO.setProductName("产品"+gene.getProductId());
                                taskVO.setProductId(String.valueOf(gene.getProductId()));
                                taskVO.setQuantity(gene.getQuantity());
                                taskVO.setStart(scheduleChromosome.getBaseTime().plusSeconds(gene.getStartTime()));
                                taskVO.setEnd(scheduleChromosome.getBaseTime().plusSeconds(gene.getEndTime()));
                                taskVO.setSetup(0); // 默认值
                                taskVO.setTeardown(gene.getTeardownTime()); // 默认值
                                taskVO.setEquipChange(gene.getChangeoverTime()); // 默认值
                                taskVO.setEquipCooling(0); // 默认值
//                            taskVO.setEquipType("PTT-" + (i+1) + "-" + gene.getOperationName().toUpperCase().substring(0, Math.min(3, gene.getOperationName().length())));
//                            taskVO.setEquipName(gene.getOperationName());
                                taskVO.setDuration(calculateDuration(
                                        scheduleChromosome.getBaseTime().plusMinutes(gene.getStartTime()),
                                        scheduleChromosome.getBaseTime().plusMinutes(gene.getEndTime())));
                                taskVO.setEquipId(gene.getMachineId()); // 生成设备ID
                                taskVO.setShopId(gene.getMachineId());
                                taskVO.setShopName(gene.getMachineId()+"车间");
                                taskVO.setStatus(0);
//                                taskVO.setDetailId((long) gene.getProductId() * 1000 + gene.getOperationId());
//                                taskVO.setHeaderId(gene.getProductId());
                                taskVO.setHeaderName("工艺"+gene.getProductId());
//                                taskVO.setSeq(gene.getSequenceId());
//                                taskVO.setSeqName("工序名称"+gene.getSequenceId());
//                                taskVO.setAbsoluteStart(scheduleChromosome.getBaseTime().plusMinutes(gene.getStartTime()));
//                                taskVO.setAbsoluteEnd(scheduleChromosome.getBaseTime().plusMinutes(gene.getEndTime()));

                                taskVOList.add(taskVO);
                            }

                            productGanttVO.setList(taskVOList);
                            productGanttVOList.add(productGanttVO);
                        }
                    });
        }

        return productGanttVOList;
    }









    @GetMapping("/productGantt")
    @Operation(summary = "获取资源甘特图数据", description = "获取资源甘特图数据")
    public List<ProductGanttVO> productGantt(@RequestParam String sceneId) {
        // 从PlanResultService获取ScheduleChromosome列表
        Chromosome schedule = sceneService.loadChromosomeFromFile(sceneId);
        if ( schedule == null) {
            return new ArrayList<>();
        }

        // 转换为 ProductGanttVO 格式
        List<ProductGanttVO> productGanttVOList= new ArrayList<>();
        List<ProductGanttVO> resourceGanttVOs = planResultService.convertToProductGanttVO1(schedule);
        productGanttVOList.addAll(resourceGanttVOs);

        return productGanttVOList;
    }


    @GetMapping("/resourceGantt")
    @Operation(summary = "获取资源甘特图数据", description = "获取资源甘特图数据")
    public List<ResourceGanttVO> resourceGantt(@RequestParam String sceneId) {
        // 从PlanResultService获取ScheduleChromosome列表
        Chromosome schedule = sceneService.loadChromosomeFromFile(sceneId);
        // 如果找不到对应的场景，返回空列表
        if ( schedule == null) {
            return new ArrayList<>();
        }

        List<Machine> machineList = planResultService.InitCalendarToAllMachines1(sceneId);

        // 转换为 ResourceGanttVO 格式
        List<ResourceGanttVO> resourceGanttVOList = new ArrayList<>();
        List<ResourceGanttVO> resourceGanttVOs = planResultService.convertToResourceGanttVO1(schedule, machineList);
        resourceGanttVOList.addAll(resourceGanttVOs);

        return resourceGanttVOList;
    }



    @PostMapping("/getResourceGantt")
    @Operation(summary = "获取资源甘特图数据", description = "获取资源甘特图数据")
    public R<List<ResourceGanttVO>> getResourceGantt(@RequestBody Map<String, Object> params) {
        // 从参数中获取sceneId
        String sceneId = (String) params.get("sceneId");

        // 校验sceneId是否存在
        if (sceneId == null || sceneId.isEmpty()) {
            throw new IllegalArgumentException("场景ID不能为空");
        }

        // 校验能否获取对应的文件
        Chromosome schedule = sceneService.loadChromosomeFromFile(sceneId);
        if (schedule == null) {
            throw new RuntimeException("未找到对应的场景文件");
        }

        List<Machine> machineList = planResultService.InitCalendarToAllMachines1(schedule.getScenarioID());

        // 转换为 ResourceGanttVO 格式
        List<ResourceGanttVO> resourceGanttVOList = new ArrayList<>();
        List<ResourceGanttVO> resourceGanttVOs = planResultService.convertToResourceGanttVO1(schedule, machineList);
        resourceGanttVOList.addAll(resourceGanttVOs);

        System.out.println("完成甘特图请求");
        return R.ok(resourceGanttVOList);
    }




    @PostMapping("/getProductGantt")
    @Operation(summary = "获取产品甘特图数据", description = "获取产品甘特图数据")
    public R<List<ProductGanttVO>> getProductGantt(@RequestBody Map<String, Object> params) {
        // 从参数中获取sceneId
        String sceneId = (String) params.get("sceneId");

        // 校验sceneId是否存在
        if (sceneId == null || sceneId.isEmpty()) {
            throw new IllegalArgumentException("场景ID不能为空");
        }

        // 校验能否获取对应的文件
        Chromosome schedule = sceneService.loadChromosomeFromFile(sceneId);
        if (schedule == null) {
            throw new RuntimeException("未找到对应的场景文件");
        }

        // 转换为 ProductGanttVO 格式
        List<ProductGanttVO> productGanttVOList= new ArrayList<>();
        List<ProductGanttVO> resourceGanttVOs = planResultService.convertToProductGanttVO1(schedule);
        productGanttVOList.addAll(resourceGanttVOs);

        return R.ok(productGanttVOList);
    }



}