package com.aps.entity.basic;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

@Data
public class Machine {
    private long id;
    private String name;
    private int earliestTime=0;
    private double totalTaskTime=0;
    private List<Shift> shifts;
    private List<MaintenanceWindow> maintenanceWindows;
    private List<TimeSegment> availability;
    private String code;
    private List<Holiday> holidays;

    private double actualWorkTime;
    private double rate;
    private String department;

    // 事件回调
    private Consumer<Void> shiftsChanged;
    private Consumer<Void> maintenanceWindowsChanged;

    public Machine() {
        this.shifts = new ArrayList<>();
        this.maintenanceWindows = new ArrayList<>();
        this.availability = new ArrayList<>();
    }

    public Machine(int id, String name) {
        this();
        this.id = id;
        this.name = name;
    }

    // 添加维护窗口的方法
    public void addMaintenanceWindow(MaintenanceWindow window) {
        maintenanceWindows.add(window);
        if (maintenanceWindowsChanged != null) {
            maintenanceWindowsChanged.accept(null);
        }
    }

    public void addShift(Shift shift) {
        shifts.add(shift);
        if (shiftsChanged != null) {
            shiftsChanged.accept(null);
        }
    }

    // 重写equals和hashCode方法，只基于id进行比较
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Machine machine = (Machine) o;
        return id == machine.id;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}