package com.aps.entity.basic;

import lombok.Data;

import java.util.List;

/**
 * 基因表示
 */
@Data
public class Gene {
    private int orderId;
    private int productId;
    private int operationId;
    private String operationName; // 添加工序名称
    private Long machineId;
    private int startTime; // 相对开始时间（分钟）
    private int endTime; // 相对结束时间（分钟）
    private int batchSize; // 批次大小（订单可拆分）
    private List<GeneDetail> geneDetails; // 时间详情
    private double processingTime; // 绝对处理时间（分钟）
    private int Id;
    private int sequenceId;
    private int setupTime; // 换型时
    private int teardownTime; // 后处理时间（收尾时间）
    private int contantTime; // 常数时间
    private int preTime;
    private int absoluteStartTime; // 相对开始时间（分钟）
    private int absoluteEndTime; // 相对结束时间（分钟）
    private int absolutePreparationTime;   // 新增：绝对前处理时间

    private int absoluteTeardownTime;     // 新增：绝对后处理时间

    private int absoluteSetupTime;     // 新增：绝对换型时间

}