package com.aps.service.Algorithm;

import com.aps.common.util.ProductionDeepCopyUtil;
import com.aps.entity.Algorithm.Chromosome;
import com.aps.entity.Algorithm.GAScheduleResult;
import com.aps.entity.Algorithm.GlobalOperationInfo;
import com.aps.entity.Algorithm.IDAndChildID.GroupResult;
import com.aps.entity.Algorithm.IDAndChildID.NodeInfo;
import com.aps.entity.Algorithm.ScheduleResultDetail;
import com.aps.entity.basic.Entry;
import com.aps.entity.basic.GlobalParam;
import com.aps.entity.basic.MachineOption;
import com.aps.service.plan.MachineSchedulerService;
import org.apache.commons.lang3.StringUtils;

import javax.xml.transform.Result;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/**
 * 作者：佟礼
 * 时间：2025-11-30
 */
public class ScheduleOperationService {
    /**
        * 移动工序方法
     * @param chromosome 染色体对象
     * @param opId 工序ID
     * @param newStartTime 新开始时间
     * @param newMachineId 新设备ID
     */
    public void moveOperation(Chromosome chromosome, int opId, int newStartTime,
                              Long newMachineId, GlobalParam globalParam) {
        List<Entry> allOperations = chromosome.getAllOperations();
        // 获取目标结果和工序
        GAScheduleResult targetResult = chromosome.getResult().stream()
                .filter(r -> r.getOperationId() == opId)
                .findFirst()
                .orElseThrow(() -> new NoSuchElementException("Operation not found: " + opId));

        Entry targetOp = allOperations.stream()
                .filter(o -> o.getId() == opId)
                .findFirst()
                .orElseThrow(() -> new NoSuchElementException("Operation not found: " + opId));

        int machineOptionIndex = targetOp.getMachineOptions().stream()
                .map(MachineOption::getMachineId)
                .collect(Collectors.toList())
                .indexOf(newMachineId) + 1;

        if (machineOptionIndex == 0) {
            throw new NoSuchElementException("Machine not found: " + newMachineId);
        }

        // 设置约束
        targetResult.setDesignatedStartTime(newStartTime);
        targetResult.setForcedMachineId(newMachineId);

        // 更新设备选择序列
        int globalOpIndex = chromosome.getGlobalOpList().stream()
                .filter(g -> g.getOp().getId() == opId)
                .findFirst()
                .map(GlobalOperationInfo::getGlobalOpId)
                .orElseThrow(() -> new NoSuchElementException("Global operation not found: " + opId));


        chromosome.getMachineSelection().set(globalOpIndex, machineOptionIndex);

        // 生成新的工序顺序
        Map<Integer, Integer> opTimeMap = chromosome.getResult().stream()
                .collect(Collectors.toMap(
                        GAScheduleResult::getOperationId,
                        r -> r.getOperationId() == opId ? newStartTime : r.getStartTime()
                ));

        List<Integer> operationSequencing = allOperations.stream()
                .sorted((op1, op2) -> {
                    int time1 = opTimeMap.getOrDefault(op1.getId(), Integer.MAX_VALUE);
                    int time2 = opTimeMap.getOrDefault(op2.getId(), Integer.MAX_VALUE);
                    if (time1 != time2) {
                        return Integer.compare(time1, time2);
                    } else {
                        return Integer.compare(op1.getSequence(), op2.getSequence());
                    }
                })
                .map(Entry::getGroupId)
                .collect(Collectors.toList());

        chromosome.setOperationSequencing(operationSequencing);
// 重新解码
        redecode(chromosome, chromosome.getBaseTime(), globalParam);


    }

    public void SpiltOperation(Chromosome chromosome, int opId,Double[] splitCounts, GlobalParam globalParam)
    {
        List<Entry> allOperations = chromosome.getAllOperations();

        List<GroupResult> OperatRels = chromosome.getOperatRel();

        Entry targetOp = allOperations.stream()
                .filter(o -> o.getId() == opId)
                .findFirst()
                .orElseThrow(() -> new NoSuchElementException("Operation not found: " + opId));

        GAScheduleResult targetSr = chromosome.getResult().stream()
                .filter(o -> o.getOperationId() == opId)
                .findFirst()
                .orElseThrow(() -> new NoSuchElementException("Operation not found: " + opId));

        // 找到原来的组和父子级
        GroupResult groupResult = OperatRels.get(targetOp.GroupId-1);
        List<NodeInfo> nodeInfoList = groupResult.getNodeInfoList();

        NodeInfo Oprel = nodeInfoList.stream()
                .filter(o -> o.getGlobalSerial() == opId)
                .findFirst()
                .orElseThrow(() -> new NoSuchElementException("Operation not found: " + opId));


        int targetGroupIndex = targetOp.GroupId - 1;
        List<Integer> newParentIds = Oprel.getNewParentIds();
        List<Integer> newChildIds = Oprel.getNewChildIds();
        //记录新的工序ID和数量
        Map<String,Double> newids=new HashMap<>();
        String MainId = UUID.randomUUID().toString().replace("-", "");

        for (int i=0;i<splitCounts.length;i++) {

            String newId = UUID.randomUUID().toString().replace("-", "");
            if (i == 0) {
                newids.put(targetOp.ExecId, splitCounts[i]);
            } else {
                newids.put(newId, splitCounts[i]);
                // 添加新节点
                OperatRels = IdGroupingWithDualSerial.addNode(OperatRels, targetGroupIndex, newId, newParentIds, newChildIds,targetOp.getExecId());
            }
         }
        chromosome.setOperatRel(OperatRels);
        //当前组的
         groupResult = OperatRels.get(targetGroupIndex);

         nodeInfoList = groupResult.getNodeInfoList();
         //全局ID
        int globalOpId = chromosome.getGlobalOpList().stream()
                .mapToInt(GlobalOperationInfo::getGlobalOpId)
                .max()
                .orElse(0)+1;

        //找到原工序用的设备序号
        List<MachineOption> optionalMachines = targetOp.getMachineOptions();
        OptionalInt index = IntStream.range(0, optionalMachines.size())
                .filter(i -> targetSr.getMachineId()==optionalMachines.get(i).getMachineId())
                .findFirst();
        int machineSeq =index.orElse(0)+1 ;
        List<Integer> OperationSequencing=  chromosome.getOperationSequencing();
        OptionalInt OperationIndex = IntStream.range(0, OperationSequencing.size())
                .filter(i -> OperationSequencing.get(i).equals(targetOp.GroupId)) // 过滤出值为1的索引
                .skip(targetOp.Sequence-1) // 跳过第一个匹配项
                .findFirst(); // 取第二个匹配项
       int targetOpIndex= OperationIndex.getAsInt()+1;
        for (NodeInfo nodeInfo : nodeInfoList) {
            Entry entry = allOperations.stream()
                    .filter(o -> o.getId() == nodeInfo.getGlobalSerial())
                    .findFirst()
                    .orElse(null);
            if(entry!=null)
            {
                //存在则修改顺和前后序
                entry.setSequence(nodeInfo.getGroupSerial());
                entry.setPrevEntryIds(nodeInfo.getNewParentIds());
                entry.setNextEntryIds(nodeInfo.getNewChildIds());

                GlobalOperationInfo info= chromosome.getGlobalOpList().stream()
                        .filter(t->t.getOp().getId()==entry.getId())
                        .findFirst()
                        .orElse(null);

                if(info!=null) {
                    info.setSequence(nodeInfo.getGroupSerial());
                }
                if(entry.getId()==targetOp.getId())
                {
                    entry.setMainId(MainId);
                    entry.setState(1);
                    entry.setQuantity(newids.get(nodeInfo.getOriginalId()));
                }
            }else {
                //不存在创建新的
                Entry newOp = ProductionDeepCopyUtil.deepCopy(targetOp);
                newOp.setId(nodeInfo.getGlobalSerial());
                newOp.setSequence(nodeInfo.getGroupSerial());
                newOp.setExecId(nodeInfo.getOriginalId());
                newOp.setPrevEntryIds(nodeInfo.getNewParentIds());
                newOp.setNextEntryIds(nodeInfo.getNewChildIds());
                newOp.setQuantity(newids.get(nodeInfo.getOriginalId()));
                newOp.setMainId(MainId);
                newOp.setState(2);
                //工序基本信息
                chromosome.getAllOperations().add(newOp);
                // 运算的全局变量
                GlobalOperationInfo info = new GlobalOperationInfo();
                info.setGlobalOpId(globalOpId);
                info.setGroupId(newOp.getGroupId());
                info.setSequence(newOp.getSequence());
                info.setOp(newOp);
                chromosome.getGlobalOpList().add(info);
                globalOpId++;
                //排产的机器选择部分
                chromosome.getMachineSelection().add(machineSeq);
                chromosome.getOperationSequencing().add(targetOpIndex,newOp.getGroupId());
                targetOpIndex++;
            }
        }

        redecode(chromosome, chromosome.getBaseTime(), globalParam);

    }
    public void LockOperation(Chromosome chromosome,int opId, boolean isLocked, GlobalParam globalParam)
    {
        GAScheduleResult targetResult = chromosome.getResult().stream()
                .filter(r -> r.getOperationId() == opId)
                .findFirst()
                .orElseThrow(() -> new NoSuchElementException("Operation not found: " + opId));

        targetResult.setIsLocked(isLocked);

        // 若解锁，重新解码受影响工序
        if (!isLocked)
        {
            redecode(chromosome, chromosome.getBaseTime(), globalParam);
        }
    }

    public void DelOperation(Chromosome chromosome, int opId, GlobalParam globalParam) {

        List<Entry> allOperations = chromosome.getAllOperations();

        List<GroupResult> OperatRels = chromosome.getOperatRel();

        OperatRels = IdGroupingWithDualSerial.deleteNodeByGlobalSerial(OperatRels, opId);
        chromosome.setOperatRel(OperatRels);
        Entry targetOp = allOperations.stream()
                .filter(o -> o.getId() == opId)
                .findFirst()
                .orElseThrow(() -> new NoSuchElementException("Operation not found: " + opId));


        List<Entry> entrys = allOperations.stream()
                .filter(o -> o.GroupId == targetOp.GroupId)
                .collect(Collectors.toList());
        //当前组的
        GroupResult groupResult = OperatRels.get(targetOp.GroupId-1);
        List<NodeInfo> nodeInfoList = groupResult.getNodeInfoList();


        nodeInfoList = groupResult.getNodeInfoList();
        for (Entry entry : entrys) {
            NodeInfo node = nodeInfoList.stream()
                    .filter(o -> o.getGlobalSerial() == entry.getId())
                    .findFirst()
                    .orElse(null);
            if(node!=null)
            {
                entry.setSequence(node.getGroupSerial());
                entry.setPrevEntryIds(node.getNewParentIds());
                entry.setNextEntryIds(node.getNewChildIds());
                GlobalOperationInfo info= chromosome.getGlobalOpList().stream()
                        .filter(t->t.getOp().getId()==entry.getId())
                        .findFirst()
                        .orElse(null);

                if(info!=null) {
                    info.setSequence(node.getGroupSerial());
                }
            }else {
                if(StringUtils.isBlank(entry.getMainId())) {
                    //拆分的工序数量补齐到其他的
                    Entry main = entrys.stream().
                            filter(t -> t.MainId == entry.getMainId())
                            .findFirst()
                            .orElse(null);
                    if (main != null) {
                        main.setQuantity(main.getQuantity() + entry.getQuantity());
                    }
                }

            }
        }
        List<Integer> OperationSequencing=  chromosome.getOperationSequencing();

        OptionalInt OperationIndex = IntStream.range(0, OperationSequencing.size())
                .filter(i -> OperationSequencing.get(i).equals(targetOp.GroupId)) // 过滤出值为1的索引
                .skip(targetOp.Sequence-1) // 跳过第一个匹配项
                .findFirst();
        chromosome.getOperationSequencing().remove(OperationIndex.getAsInt());


        List<GlobalOperationInfo> globalOpList = chromosome.getGlobalOpList();

        int globalOpIndex = IntStream.range(0, globalOpList.size())
                .filter(i -> globalOpList.get(i).getOp().getId() == opId)
                .findFirst()
                .orElseThrow(() -> new NoSuchElementException("Global operation not found: " + opId));


        chromosome.getMachineSelection().remove(globalOpIndex);
        globalOpList.remove(globalOpIndex);

        List<Entry> operations = chromosome.getAllOperations();

        IntStream.range(0, operations.size())
                .filter(i -> operations.get(i).getId() == opId)
                .findFirst()
                .ifPresent(operations::remove);

        List<GAScheduleResult> results = chromosome.getResult();

        IntStream.range(0, results.size())
                .filter(i -> results.get(i).getOperationId() == opId)
                .findFirst()
                .ifPresent(results::remove);

        redecode(chromosome, chromosome.getBaseTime(), globalParam);

    }

    /**
     * 重新解码
     * @param chromosome 原方案
     * @param baseTime 基础时间
     * @param globalParam 全局参数
     */
    public void redecode(Chromosome chromosome,LocalDateTime baseTime, GlobalParam globalParam)
    {
        MachineSchedulerService machineScheduler = new MachineSchedulerService(baseTime);
        GeneticDecoder decoder = new GeneticDecoder(globalParam,baseTime, chromosome.getInitMachines(),
                chromosome.getOrders(), null, machineScheduler);
        chromosome.setMachines(chromosome.getInitMachines());
        chromosome.setResultOld(ProductionDeepCopyUtil.deepCopyList(chromosome.getResult()));

        chromosome.getResult().clear();
        List<GAScheduleResult> Resultlock= chromosome.getResult().stream()
                .filter(o -> o.isIsLocked() == true)
                .collect(Collectors.toList());
        chromosome.setResult(ProductionDeepCopyUtil.deepCopyList(Resultlock));


        decoder.decode(chromosome);
        if(chromosome.getFitness()==0) {
            FitnessCalculator fitnessCalc = new FitnessCalculator();
            chromosome.setFitness(fitnessCalc.calculateFitness(chromosome));
        }

    }
}
