package com.aps.entity.basic;

import lombok.Data;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Set;

@Data
public class Shift {
    private LocalTime startTime;
    private LocalTime endTime;
    private Set<Integer> days; // 改为Integer类型，便于JSON反序列化
    private LocalDateTime shiftDate;
    private LocalDateTime startDate;
    private LocalDateTime endDate;
    private boolean isTemporaryShift;
    private int priority;

    private Integer status;//0:正常班次 1:临时班次 2:维修
    
    // 添加设备ID和名称字段
    private Long machineId;
    private String machineName;

    public Shift() {}


    public LocalTime getStartTime() {
        return startTime;
    }

    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    public LocalTime getEndTime() {
        return endTime;
    }

    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    public Set<Integer> getDays() {
        return days;
    }

    public void setDays(Set<Integer> days) {
        this.days = days;
    }



    public LocalDateTime getShiftDate() {
        return shiftDate;
    }

    public void setShiftDate(LocalDateTime shiftDate) {
        this.shiftDate = shiftDate;
    }

    public boolean isTemporaryShift() {
        return isTemporaryShift;
    }

    public void setTemporaryShift(boolean temporaryShift) {
        isTemporaryShift = temporaryShift;
    }

    public int getPriority() {
        return priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }
    
    public Integer getStatus() {
        return status;
    }
    
    public void setStatus(Integer status) {
        this.status = status;
    }
    
    public Long getMachineId() {
        return machineId;
    }
    
    public void setMachineId(Long machineId) {
        this.machineId = machineId;
    }
    
    public String getMachineName() {
        return machineName;
    }
    
    public void setMachineName(String machineName) {
        this.machineName = machineName;
    }
}