package com.aps.service.Algorithm;

import com.aps.entity.*;
import com.aps.entity.Algorithm.DependencyType;
import com.aps.entity.Algorithm.IDAndChildID.GroupResult;
import com.aps.entity.Algorithm.IDAndChildID.NodeInfo;
import com.aps.entity.Algorithm.OperationDependency;
import com.aps.entity.basic.Entry;
import com.aps.entity.basic.MachineOption;
import com.aps.service.*;
import com.aps.service.plan.SceneService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 作者：佟礼
 * 时间：2025-12-09
 */
@Service
public class RoutingDataService {

    @Autowired
    private ProdLaunchOrderService _prodLaunchOrderService;

    @Autowired
    private ProdProcessExecService _prodProcessExecService;

    @Autowired
    private ProdEquipmentService _prodEquipmentService;

    @Autowired
    private PlanResourceService _PlanResourceService;

    @Autowired
    private SceneService _sceneService;

    @Autowired
    private ProdOrderProcessService _prodOrderProcessService;

    @Autowired
    private  RoutingDiscreteParamService _routingDiscreteParamService;
    @Autowired
    private  DiscreteParameterMatrixService _discreteParameterMatrixService;

    public Map<Integer, Object> InitEntrys(String SceneId, List<ProdEquipment> ProdEquipments, List<ProdLaunchOrder> ProdLaunchOrders)
    {
        Map<Integer, Object> list=new HashMap<>();
        List<ProdProcessExec> ProdProcessExecs=  _prodProcessExecService.lambdaQuery()
                .eq(ProdProcessExec::getSceneId,SceneId)
                .list();

// 获取op列表中所有的routingDetailId
        List<Long> routingDetailIds = ProdProcessExecs.stream()
                .map(ProdProcessExec::getRoutingDetailId)
                .filter(Objects::nonNull)
                .distinct()
                .collect(Collectors.toList());

// 查询RoutingDiscreteParam中routingDetailId在上述列表中的所有记录
        List<RoutingDiscreteParam> routingDiscreteParams = _routingDiscreteParamService.lambdaQuery()
                .in(RoutingDiscreteParam::getRoutingDetailId, routingDetailIds)
                .eq(RoutingDiscreteParam::getIsDeleted, 0)
                .list();


        List<ProdOrderProcess> ProdOrderProcesss = _prodOrderProcessService.lambdaQuery()
                .eq(ProdOrderProcess::getSceneId,SceneId)
                .list();

       return CreateEntry( SceneId,  ProdEquipments,  ProdLaunchOrders, routingDiscreteParams, ProdOrderProcesss, ProdProcessExecs,null );

    }

    public Map<Integer, Object> CreateEntry(String SceneId, List<ProdEquipment> ProdEquipments, List<ProdLaunchOrder> ProdLaunchOrders,List<RoutingDiscreteParam> routingDiscreteParams,List<ProdOrderProcess> ProdOrderProcesss,List<ProdProcessExec> ProdProcessExecs,List<GroupResult> existingResults)
    {
        Map<Integer, Object> list=new HashMap<>();
        List<String> soutceExecId = ProdOrderProcesss.stream()
                .map(ProdOrderProcess::getExecId)
                .distinct() // 提取Exec_ID
                .collect(Collectors.toList());

        List<String> targetExecId = ProdOrderProcesss.stream()
                .map(ProdOrderProcess::getTargetExecId)
                .distinct() // 提取TARGET_Exec_ID
                .collect(Collectors.toList());

        List<String> ExecIdNoChild=  ProdProcessExecs.stream()
                .filter(e -> !soutceExecId.contains(e.getExecId())&&!targetExecId.contains(e.getExecId()))  // 过滤条件
                .map(ProdProcessExec::getExecId)
                .distinct()
                .collect(Collectors.toList());

        if(ExecIdNoChild!=null&&ExecIdNoChild.size()>0)
        {
            for (String ExecId : ExecIdNoChild) {
                soutceExecId.add(ExecId);
                targetExecId.add("");
            }
        }
        List<GroupResult> results;
        int index=0;
        if(existingResults==null||existingResults.size()==0) {
            results = IdGroupingWithDualSerial.groupAndOrderIds(soutceExecId, targetExecId);
        }else {
            index=existingResults.size();
            results = IdGroupingWithDualSerial.addNewDataWithIsolatedGroup(existingResults,soutceExecId, targetExecId);
        }

        List<Entry> entrys=new ArrayList<>();

        for (int i = index; i < results.size(); i++) {
            GroupResult groupResult = results.get(i);
            List<NodeInfo> nodeInfoList = groupResult.getNodeInfoList();
            // System.out.println("分组" + (i + 1) + "顺序：" + nodeInfoList);
            for (NodeInfo nodeInfo : nodeInfoList) {
//                System.out.printf("原始ID：%s → 全局序号：%d，分组内序号：%d，新父ID列表：%s，新子ID列表：%s%n",
//                        nodeInfo.getOriginalId(),
//                        nodeInfo.getGlobalSerial(),
//                        nodeInfo.getGroupSerial(),
//                        nodeInfo.getNewParentIds().isEmpty() ? "无" : nodeInfo.getNewParentIds(),
//                        nodeInfo.getNewChildIds());

                Entry entry = new Entry();

                entry.setId(nodeInfo.getGlobalSerial());
                entry.setGroupId(i + 1);
                entry.setSequence(nodeInfo.getGroupSerial());
                entry.setExecId(nodeInfo.getOriginalId());
                ProdProcessExec op= ProdProcessExecs.stream()
                        .filter(t->t.getExecId().equals(entry.getExecId()))
                        .findFirst().orElse(null);
                if(nodeInfo.getNewParentIds()!=null)
                {

                    List<OperationDependency> OperationDependency=new ArrayList<>();
                    for (int id : nodeInfo.getNewParentIds()) {
                        OperationDependency od=new OperationDependency();
                        od.setPrevOperationId(id);

                        if (op != null) {
                            od.setDependencyType(DependencyType.fromValueSafe(op.getConnectProperty()));
                        } else {
                            od.setDependencyType(DependencyType.FinishToStart);
                        }
                        OperationDependency.add(od);
                    }
                    entry.setPrevEntryIds(OperationDependency);
                }



                if(nodeInfo.getNewChildIds()!=null)
                {
                    List<OperationDependency> OperationDependency=new ArrayList<>();
                    for (int id : nodeInfo.getNewChildIds()) {
                        OperationDependency od=new OperationDependency();
                        od.setNextOperationId(id);
                        // 记录属性
                        if (op != null) {
                            od.setDependencyType(DependencyType.fromValueSafe(op.getConnectProperty()));
                        } else {
                            od.setDependencyType(DependencyType.FinishToStart);
                        }



                        OperationDependency.add(od);
                    }
                    entry.setNextEntryIds(OperationDependency);
                }



                if(op!=null)
                {
                    entry.setDiscreteParameter(routingDiscreteParams.stream().filter(t -> t.getRoutingDetailId().equals(op.getRoutingDetailId())).collect(Collectors.toList()));
                    entry.setEquipTypeID(op.getMachineId());
                    entry.setOrderId(op.getOrderId());
                    entry.setQuantity(op.getPlanQty());
                    entry.setRoutingId(op.getRoutingId());
                    entry.setRoutingDetailId(op.getRoutingDetailId());
                    entry.setTaskSeq(op.getTaskSeq());
                    entry.setRoutingDetailName(op.getRoutingDetailName());
                    ProdLaunchOrder order = ProdLaunchOrders.stream()
                            .filter(t -> t.getOrderId().equals(op.getOrderId()))
                            .findFirst().orElse(null);
                    if (order != null) {
                        entry.setProductId(order.getMaterialId());
                    }
                    List<ProdEquipment> Equipments = ProdEquipments.stream()
                            .filter(t -> t.getExecId().equals(op.getExecId()))
                            .collect(Collectors.toList());
                    if (Equipments != null && Equipments.size() > 0) {
                        List<MachineOption> mos = new ArrayList<>();
                        for (ProdEquipment e : Equipments) {
                            MachineOption mo = new MachineOption();
                            mo.setMachineId(e.getEquipId());
                            mo.setProcessingTime(e.getSpeed());
                            mo.setContantTime(op.getConstTime());
                            mo.setSetupTime(op.getChangeLineTime());
                            mo.setTeardownTime(op.getPostprocessingTime());
                            mo.setPreTime(e.getSetupTime());

                            mos.add(mo);
                        }
                        entry.setMachineOptions(mos);
                    }
                }
                entry.setPriority(1);
                entrys.add(entry);
            }
            // 输出每个节点的详细信息

            System.out.println("------------------------");
        }
        list.put(1,entrys);
        list.put(2,results);

        return  list;

    }
}
