package com.aps.service.plan;

import com.aps.common.util.DateGroupUtil;
import com.aps.common.util.FileHelper;
import com.aps.common.util.JsonFileReader;
import com.aps.common.util.ProductionDeepCopyUtil;
import com.aps.controller.gantt.FileUploadController;
import com.aps.entity.*;
import com.aps.entity.Algorithm.*;
import com.aps.entity.Algorithm.IDAndChildID.GroupResult;
import com.aps.entity.Algorithm.IDAndChildID.NodeInfo;
import com.aps.entity.basic.ScheduleChromosome;
import com.aps.entity.Schedule.GenVO;
import com.aps.entity.Schedule.MachineVO;
import com.aps.entity.basic.*;
import com.aps.mapper.ConfigMapper;
import com.aps.mapper.MaterialInfoMapper;
import com.aps.service.*;
import com.aps.service.Algorithm.*;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

@Service
public class PlanResultService {
    // 注入FileUploadController
    @Autowired
    private FileUploadController fileUploadController;

    @Autowired
    private MesHolidayService _MesHolidayService;

    @Autowired
    private ProdEquipSpecialCalService _prodEquipSpecialCalService;

    @Autowired
    private MesShiftWorkSchedService _MesShiftWorkSchedService;


    @Autowired
    private ProdLaunchOrderService _prodLaunchOrderService;

    @Autowired
    private ProdProcessExecService _prodProcessExecService;

    @Autowired
    private ProdEquipmentService _prodEquipmentService;

    @Autowired
    private PlanResourceService _PlanResourceService;

    @Autowired
    private SceneService _sceneService;

    @Autowired
    private ProdOrderProcessService _prodOrderProcessService;

    @Autowired
    private  RoutingDiscreteParamService _routingDiscreteParamService;
    @Autowired
    private  DiscreteParameterMatrixService _discreteParameterMatrixService;

    @Autowired
    private RoutingDataService _routingDataService;

    @Autowired
    private ConfigService _configService;

    @Autowired
    private ConfigMapper configMapper;



    @Autowired
    private StrategyRuleService _strategyRuleService;

    @Autowired
    private OrderSortService orderSortService;

    @Autowired
    private MaterialInfoService materialInfoService;

    @Autowired
    private MaterialInfoMapper materialInfoMapper;

    @Autowired
    private StockService stockService;

    @Autowired
    private SjzPfWhStockService sjzPfWhStockService;

    @Autowired
    private PurchaseReceiptService purchaseReceiptService;

    @Autowired
    private ErpPurchaseOrderService erpPurchaseOrderService;

    @Autowired
    private MaterialRequirementService materialRequirementService;

    private  LocalDateTime baseTime = LocalDateTime.of(2025, 11, 1, 0, 0, 0);

    public List<ScheduleChromosome> execute() {
        try {
            // 1. 读取数据
            List<Machine> machines = loadData("machines.json", Machine.class);
            List<Product> products = loadData("products.json", Product.class);
            List<Order> orders = loadData("orders.json", Order.class);

            // 设置机器信息到班次中
            for (Machine machine : machines) {
                if (machine.getShifts() != null) {
                    for (Shift shift : machine.getShifts()) {
                        shift.setMachineId(machine.getId());
                        shift.setMachineName(machine.getName());
                    }
                }

                // 调试：打印机器和班次信息
                System.out.println("Machine: " + machine.getId() + ", Name: " + machine.getName());
                if (machine.getShifts() != null) {
                    for (Shift shift : machine.getShifts()) {
                        System.out.println("  Shift: " + shift.getStartTime() + " - " + shift.getEndTime() +
                                         ", Status: " + shift.getStatus() +
                                         ", MachineId: " + shift.getMachineId() +
                                         ", MachineName: " + shift.getMachineName());
                    }
                }
            }

            // 创建节假日
            List<Holiday> holidays = Arrays.asList(
                    new Holiday(LocalDateTime.of(2025, 10, 1, 0, 0),
                            LocalDateTime.of(2025, 10, 7, 23, 59))
            );

            // 将节假日添加到所有设备中
            addHolidaysToAllMachines(machines, holidays);

            // 3. 创建调度服务
            MachineSchedulerService machineScheduler = new MachineSchedulerService(
                    holidays, LocalDateTime.of(2025, 10, 1, 0, 0, 0));

            // 4. 初始化机器时间线
            for (Machine machine : machines) {
                MachineTimeline timeline = machineScheduler.getOrCreateTimeline(machine);
                machine.setAvailability(timeline.getSegments());
            }

            // 5. 执行调度算法
            AlgorithmScheduler7 scheduler = new AlgorithmScheduler7(products, machines, orders, machineScheduler);
            List<ScheduleChromosome> scheduleChromosomes = scheduler.RunAll();

            // 对调度结果按照 fitness 由高到低排序
            scheduleChromosomes.sort((c1, c2) -> Double.compare(c2.getFitness(), c1.getFitness()));

            // 为每个 ScheduleChromosome 分配场景ID（基于排序后的位置）
            for (int i = 0; i < scheduleChromosomes.size(); i++) {
                scheduleChromosomes.get(i).setSceneId(i + 1); // 场景ID从1开始
            }

            return scheduleChromosomes;

        } catch (Exception e) {
            throw new RuntimeException("调度执行失败", e);
        }
    }



       public Chromosome  execute1() {
        try {

//List<ScheduleResultDetail>  details=new ArrayList<>();
//            ScheduleResultDetail detail1=new ScheduleResultDetail();
//
//            detail1.setOneTime(100);//单件工时
//
//
//            ScheduleResultDetail detail2=new ScheduleResultDetail();
//
//            detail2.setOneTime(200);//单件工时
//            details.add(detail1);
//            details.add(detail2);


          //  mergeSegmentsWithDifferentOneTime(details, 50);
            // 1. 读取数据
            List<Machine> machines = loadData("machines.json", Machine.class);
            List<Product> products = loadData("products.json", Product.class);
            List<Order> orders = loadData("orders.json", Order.class);

            // 设置机器信息到班次中
            for (Machine machine : machines) {
                if (machine.getShifts() != null) {
                    for (Shift shift : machine.getShifts()) {
                        shift.setMachineId(machine.getId());
                        shift.setMachineName(machine.getName());
                    }
                }

                // 调试：打印机器和班次信息
                System.out.println("Machine: " + machine.getId() + ", Name: " + machine.getName());
                if (machine.getShifts() != null) {
                    for (Shift shift : machine.getShifts()) {
                        System.out.println("  Shift: " + shift.getStartTime() + " - " + shift.getEndTime() +
                                ", Status: " + shift.getStatus() +
                                ", MachineId: " + shift.getMachineId() +
                                ", MachineName: " + shift.getMachineName());
                    }
                }
            }
            ScheduleParams param = new ScheduleParams();
            param.setBaseTime(LocalDateTime.of(2025, 11, 1, 0, 0, 0));


            // List<MesHoliday> holidays=  _MesHolidayService.list();

            // 创建节假日


            // 将节假日添加到所有设备中
           // addHolidaysToAllMachines(machines);

            // 3. 创建调度服务
            MachineSchedulerService machineScheduler = new MachineSchedulerService(
                     param.getBaseTime());

            // 4. 初始化机器时间线
            for (Machine machine : machines) {
                MachineTimeline timeline = machineScheduler.getOrCreateTimeline(machine);
                machine.setAvailability(timeline.getSegments());
            }
            // 3. 构建订单-工序数据
            List<Entry> allOperations = new ArrayList<>();
            Random rnd = new Random(); // 注意：此处变量声明但未使用，可根据实际需求保留或移除

            int id = 1;
            for (Order order : orders) {
order.setDueDate(LocalDateTime.of(2025, 12, 1,0,0,0));
                // 假设products是一个List<Product>，根据Product的Id查找对应的产品
                Product product = products.stream()
                        .filter(p -> p.getId() == order.getProductId())
                        .findFirst()
                        .orElseThrow(() -> new IllegalArgumentException("未找到对应产品: " + order.getProductId()));

                int sequence = 1;
                for (Operation o : product.getOperations()) { // 假设Product类有getOperations()方法返回工序列表
                    Entry entry = new Entry();
                    entry.setId(id);
                   // entry.setGroupId(order.getId());
                    entry.setSequence(sequence);
                    entry.setMachineOptions(o.getMachineOptions()); // 假设Operation类有获取机器选项的方法
                    entry.setPriority(order.getPriority());
                    entry.setQuantity(order.getQuantity());
                    // entry.setMaterialRequirements(o.getMaterialRequirements()); // 假设Operation类有获取物料需求的方法

                    if (sequence != 1) {
                        OperationDependency od=new OperationDependency();
                        od.setPrevOperationId(id - 1);

                        entry.getPrevEntryIds().add(od); // 假设Entry类有getPrevEntryIds()返回List<Integer>
                    }

                    allOperations.add(entry);

                    sequence++;
                    id++;
                }
            }
            GlobalParam globalParam=new GlobalParam();
            // 5. 执行调度算法
            param.initAdaptiveParams(allOperations.size());
            GeneticAlgorithm scheduler =new GeneticAlgorithm(globalParam,machines,orders,null,machineScheduler,null,materialRequirementService); //new GeneticAlgorithm(products, machines, orders, machineScheduler);
            Chromosome Chromosomes =scheduler.Run(param,allOperations);
            WriteScheduleSummary(Chromosomes);
            ScheduleOperationService ScheduleOperation=new ScheduleOperationService();
            LocalDateTime ds=  LocalDateTime.of(2025, 12, 7, 23, 59);
           // ScheduleOperation.moveOperation(Chromosomes,3, (int)ChronoUnit.SECONDS.between(param.getBaseTime(), ds),(Long)2,param.getBaseTime(), globalParam);
           WriteScheduleSummary(Chromosomes);

            return Chromosomes;

        } catch (Exception e) {
            throw new RuntimeException("调度执行失败", e);
        }
    }

    public Chromosome  execute2(String SceneId) {
        try {
            ScheduleParams param = new ScheduleParams();
            param.setBaseTime(LocalDateTime.of(2025, 11, 1, 0, 0, 0));



            // 1. 读取数据
            //  List<Machine> machines = loadData("machines.json", Machine.class);
            //  List<Product> products = loadData("products.json", Product.class);
            // List<Order> orders = loadData("orders.json", Order.class);

            List<ProdEquipment> ProdEquipments=  _prodEquipmentService.lambdaQuery()
                    .eq(ProdEquipment::getSceneId,SceneId)
                    .list();

            List<ProdLaunchOrder> ProdLaunchOrders=  _prodLaunchOrderService.lambdaQuery()
                    .eq(ProdLaunchOrder::getSceneId,SceneId)
                    .list();
            // 3. 创建调度服务
            MachineSchedulerService machineScheduler = new MachineSchedulerService(
                    param.getBaseTime());
            List<Machine> machines= InitCalendarToAllMachines(SceneId, ProdEquipments,machineScheduler);
            // 3. 构建订单-工序数据

           List<Order> orders=InitOrder(ProdLaunchOrders);
            List<Material> Materials= InitMaterial();

            Map<Integer,Object> list= InitEntrys(SceneId,ProdEquipments,orders);
           List<Entry> entrys=(List<Entry>)list.get(1);



            List<GroupResult> entryRel=(List<GroupResult>)list.get(2);






            GlobalParam globalParam=InitGlobalParam();
            // 5. 执行调度算法
            GeneticAlgorithm scheduler =new GeneticAlgorithm(globalParam,machines,orders,Materials,machineScheduler,entryRel,materialRequirementService); //new GeneticAlgorithm(products, machines, orders, machineScheduler);
            param.initAdaptiveParams(entrys.size());
            double[] customWeights = new double[] { 0.2, 0.1, 0.1, 0.1, 0.5 }; // 延迟时间权重提升到0.5

            scheduler.Init(null,false);
            Chromosome chromosome =scheduler.Run(param,entrys);

            KpiCalculator kpiCalculator=new KpiCalculator(chromosome);
            kpiCalculator.calculatekpi();
            _sceneService.saveChromosomeToFile(chromosome, SceneId);

           // Chromosomes.forEach(this::WriteScheduleSummary);

            return chromosome;

        } catch (Exception e) {
            throw new RuntimeException("调度执行失败", e);
        }
    }



    public Chromosome  EditOperation(String SceneId,Entry operation) {
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);
        if (chromosome == null || chromosome.getAllOperations() == null) {
            return chromosome; // 直接返回，空值由上层处理
        }
        List<Entry> operations = chromosome.getAllOperations();
        // 直接查找匹配元素的索引（避免先找元素再查索引的冗余）
        int position = IntStream.range(0, operations.size())
                .filter(i -> {
                    Entry t = operations.get(i);
                    return t.getId()==operation.getId();
                })
                .findFirst()
                .orElse(-1);
        // 索引有效时替换
        if (position != -1) {
            operations.set(position, operation);
        }

        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        GlobalParam globalParam=new GlobalParam();
        ScheduleOperation.redecode(chromosome,chromosome.getBaseTime(), globalParam);

        return  chromosome;
    }

    public Chromosome  ChangeBaseTime(String SceneId,LocalDateTime BaseTime) {
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);
        if (chromosome == null || chromosome.getAllOperations() == null) {
            return chromosome; // 直接返回，空值由上层处理
        }

        chromosome.setBaseTime(BaseTime);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        GlobalParam globalParam=new GlobalParam();
        ScheduleOperation.redecode(chromosome,chromosome.getBaseTime(), globalParam);

        return  chromosome;
    }
    public Chromosome  Move(String SceneId,int opId, LocalDateTime newStartTime,
                            Long newMachineId) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);


        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        ScheduleOperation.moveOperation(chromosome,opId, (int)ChronoUnit.SECONDS.between(chromosome.getBaseTime(), newStartTime),newMachineId, globalParam);
      //  WriteScheduleSummary(chromosome);

        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }

    public Chromosome  SpiltOperation(String SceneId,int opId,Double[] splitCounts) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);

        //this.baseTime=param.getBaseTime();
        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        ScheduleOperation.SpiltOperation(chromosome,opId,splitCounts, globalParam);
        WriteScheduleSummary(chromosome);

        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }

    public Chromosome  DelOperation(String SceneId,int opId) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);

        //this.baseTime=param.getBaseTime();
        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        ScheduleOperation.DelOperation(chromosome,opId, globalParam);
       // WriteScheduleSummary(chromosome);

        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }

    public Chromosome  LockOperation(String SceneId,int opId,boolean isLocked) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);

        //this.baseTime=param.getBaseTime();
        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        ScheduleOperation.LockOperation(chromosome,opId,isLocked, globalParam);
        //WriteScheduleSummary(chromosome);

        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }

    public Chromosome  SpiltOrder(String SceneId,String orderId,Double[] splitCounts) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);

        //this.baseTime=param.getBaseTime();
        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        ScheduleOperation.SpiltOrder(chromosome,orderId,splitCounts, globalParam);
        WriteScheduleSummary(chromosome);

        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }
    public Chromosome  MergeOrder(String SceneId,String sourceorderId,String targetorderId) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);

        //this.baseTime=param.getBaseTime();
        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        ScheduleOperation.MergeOrder(chromosome,sourceorderId,targetorderId, globalParam);
        WriteScheduleSummary(chromosome);
        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }











        public Chromosome  schedule(String SceneId) {
        try {
            ScheduleParams param = new ScheduleParams();

//            param.setBaseTime(baseTime);

            param.setBaseTime(LocalDateTime.of(2025, 11, 1, 0, 0, 0));





            // 1. 读取数据
            //  List<Machine> machines = loadData("machines.json", Machine.class);
            //  List<Product> products = loadData("products.json", Product.class);
            // List<Order> orders = loadData("orders.json", Order.class);




            List<ProdEquipment> ProdEquipments=  _prodEquipmentService.lambdaQuery()
                    .eq(ProdEquipment::getSceneId,SceneId)
                    .list();

            List<ProdLaunchOrder> ProdLaunchOrders=  _prodLaunchOrderService.lambdaQuery()
                    .eq(ProdLaunchOrder::getSceneId,SceneId)
                    .list();
            // 3. 创建调度服务
            MachineSchedulerService machineScheduler = new MachineSchedulerService(
                    param.getBaseTime());
            List<Machine> machines= InitCalendarToAllMachines(SceneId, ProdEquipments,machineScheduler);
            // 3. 构建订单-工序数据

            List<Order> orders=InitOrder(ProdLaunchOrders);


            Map<Integer,Object> list= InitEntrys(SceneId,ProdEquipments,orders);
            List<Entry> entrys=(List<Entry>)list.get(1);
            List<GroupResult> entryRel=(List<GroupResult>)list.get(2);


            GlobalParam globalParam=InitGlobalParam();
            // 5. 执行调度算法
            GeneticAlgorithm scheduler =new GeneticAlgorithm(globalParam,machines,orders,null,machineScheduler,entryRel,materialRequirementService); //new GeneticAlgorithm(products, machines, orders, machineScheduler);
            param.initAdaptiveParams(entrys.size());
           // double[] customWeights = new double[] { 0.2, 0.1, 0.1, 0.1, 0.5 }; // 延迟时间权重提升到0.5

            scheduler.Init(null,true);
            Chromosome  chromosomes =scheduler.Run(param,entrys);
            KpiCalculator kpiCalculator=new KpiCalculator(chromosomes);
            kpiCalculator.calculatekpi();
            chromosomes.setScenarioID(SceneId);
            chromosomes.setBaseTime(param.getBaseTime());
            chromosomes.setOperatRel(entryRel);
            // 保存chromosomes到文件
            _sceneService.saveChromosomeToFile(chromosomes, SceneId);

            // Chromosomes.forEach(this::WriteScheduleSummary);

            return chromosomes;

        } catch (Exception e) {
            throw new RuntimeException("调度执行失败", e);
        }
    }


    public void WriteScheduleSummary(Chromosome schedule) {
        // 写入日志
        FileHelper.writeLogFile(String.format("\n=== Schedule Summary === %f", schedule.getFitness()));
        FileHelper.writeLogFile(String.format("Operation: %s", schedule.getOperationStr()));
        FileHelper.writeLogFile(String.format("Makespan: %f minutes", schedule.getMakespan()));
        FileHelper.writeLogFile(String.format("Total Tardiness: %f hours", schedule.getDelayTime()));
        FileHelper.writeLogFile(String.format("Setup Time: %f minutes", schedule.getTotalChangeoverTime()));
        FileHelper.writeLogFile(String.format("Flow Time: %f minutes", schedule.getTotalFlowTime()));
        FileHelper.writeLogFile(String.format("Machine Load Balance: %.2f%%", schedule.getMachineLoadStd() * 100));
        FileHelper.writeLogFile("-------------------------");

        // 按订单分组写入
        Map<Integer, List<GAScheduleResult>> orderGroups = schedule.getResult().stream()
                .collect(Collectors.groupingBy(GAScheduleResult::getGroupId));

        for (Map.Entry<Integer, List<GAScheduleResult>> group : orderGroups.entrySet()) {
            List<GAScheduleResult> sortedJobs = group.getValue().stream()
                    .sorted(Comparator.comparingInt(GAScheduleResult::getOperationId))
                    .collect(Collectors.toList());

            for (GAScheduleResult job : sortedJobs) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(String.format(
                            "[%d-%d]:[%s-%s] Order %d,  Machine %d, Operation %d, Batch %.1f, processingTime %%.1f",
                            job.getStartTime(),
                            job.getEndTime(),
                            ConvertTime(job.getStartTime()),
                            ConvertTime(job.getEndTime()),
                            job.getGroupId(),

                            job.getMachineId(),
                            job.getOperationId(),
                            job.getQuantity(),
                            job.getProcessingTime()
                    ));

                    // 追加基因详情
                    for (ScheduleResultDetail d : job.getGeneDetails()) {
                        sb.append(String.format(
                                "\n\t\t\t\t\t\t\t\t\t\t [%d-%d]:[%s-%s] %d",
                                d.getStartTime(),
                                d.getEndTime(),
                                ConvertTime(d.getStartTime()),
                                ConvertTime(d.getEndTime()),
                                d.getEndTime() - d.getStartTime()
                        ));
                    }

                    FileHelper.writeLogFile(sb.toString());

            }
            FileHelper.writeLogFile("");
        }
    }
    private String ConvertTime(int minute) {
        return baseTime.plusSeconds(minute).format(java.time.format.DateTimeFormatter.ofPattern("MM-dd HH:mm"));
    }

    /**
     * 加载数据，优先从上传文件夹加载，如果不存在则从resources加载
     *
     * @param fileName 文件名
     * @param clazz    类型
     * @param <T>      泛型
     * @return 数据列表
     * @throws IOException IO异常
     */
    private <T> List<T> loadData(String fileName, Class<T> clazz) throws IOException {
        // 检查是否有上传的文件
        if (fileUploadController.isFileUploaded(fileName)) {
            String filePath = fileUploadController.getUploadedFilePath(fileName);
            return JsonFileReader.readListFromFile(filePath, clazz);
        } else {
            // 使用默认的resources文件
            return JsonFileReader.readListFromResources(fileName, clazz);
        }
    }

    /**
     * 将假期添加到所有设备的维护窗口中
     * @param machines 设备列表
     * @param holidays 假期列表
     */
    private void addHolidaysToAllMachines(List<Machine> machines, List<Holiday> holidays) {
        if (machines == null || holidays == null) {
            return;
        }

        for (Machine machine : machines) {
            // 确保维护窗口列表不为null
            if (machine.getMaintenanceWindows() == null) {
                machine.setMaintenanceWindows(new ArrayList<>());
            }

            for (Holiday holiday : holidays) {
                // 将假期转换为维护窗口并添加到设备中
                MaintenanceWindow maintenanceWindow = new MaintenanceWindow(holiday, "Holiday Period");
                machine.addMaintenanceWindow(maintenanceWindow);
            }
        }
    }

    private List<Machine> InitCalendarToAllMachines(String SceneId,List<ProdEquipment> ProdEquipments,MachineSchedulerService machineScheduler) {
        // 按设备分组
        return  _routingDataService.InitCalendarToAllMachines(SceneId,ProdEquipments,machineScheduler);




    }
private  GlobalParam InitGlobalParam()
{
    GlobalParam globalParam=new GlobalParam();



    LambdaQueryWrapper<Config> queryWrapper = new LambdaQueryWrapper<Config>()
            .eq(Config::getComponent, "setting")
            .orderByDesc(Config::getId); // 按更新时间降序

    Page<Config> page = new Page<>(1, 1);
    configMapper.selectPage(page, queryWrapper);

// 3. 提取最后一条记录
    Config config = page.getRecords().isEmpty()
            ? null
            : page.getRecords().get(0);



    List<ConfigSetting> configs=  _configService.getComponentSettingsByPageAndNote(config.getId(),"setting");
    for (ConfigSetting c : configs) {
        if(c.getTitle().equals("日历"))
        {
            globalParam.setIsUseCalendar(c.isValue());
        }
        else if(c.getTitle().equals("设置时间"))
        {
            globalParam.setIsUseCalendar(c.isValue());
        }else if(c.getTitle().equals("原材料"))
        {
            globalParam.setIsCheckBom(c.isValue());
        }
        else if(c.getTitle().equals("设置时间平滑"))
        {
            globalParam.set_smoothSetup(c.isValue());
        }
    }

    return  globalParam;
}
    private List<Order> InitOrder(List<ProdLaunchOrder> ProdLaunchOrders)
    {
        orderSortService.initializeFieldExtractors();
        List<Order> orders=new ArrayList<>();
        for (ProdLaunchOrder lo : ProdLaunchOrders) {
            Order order=new Order();
            order.setMaterialCode(lo.getMaterialCode());
            order.setSerie(lo.getSerie()==null?"":lo.getSerie());
            order.setOrderCode(lo.getOrderCode());
            order.setOrderId(lo.getOrderId());
            order.setRoutingId(lo.getRoutingId());
            order.setMaterialId(lo.getMaterialId());
            order.setStartDate(lo.getStartDate());
            order.setDueDate(lo.getEndDate());
            order.setPriority(lo.getOrderPriority());
            order.setActualPriority(lo.getOrderPriority());
            order.setQuantity(lo.getQuantity());
            orders.add(order);
        }
        OrderSortRule rule = createMultiConditionRule(orders);

        // 执行
        orderSortService.assignPriority(orders, rule);

        // 按照优先级排序
        orders.sort(
                Comparator.comparing(Order::getActualPriority).reversed()
        );

       return orders;
    }
    private OrderSortRule createMultiConditionRule(List<Order> orders) {
        try {
            OrderSortRule rule = new OrderSortRule();
            rule.setEnabled(true);
            List<OrderSortRule.SortCondition> conditions = new ArrayList<>();
            StrategyRule strategyRules = _strategyRuleService.lambdaQuery()
                    .eq(StrategyRule::getIsDeleted, 0)
                    .eq(StrategyRule::getIsGlobal, 1)
                    .one();

            List<StrategyScheduling> StrategySchedulings = _strategyRuleService.getForwardSchedulingByRuleId(strategyRules.getId());
            Set<String> files = new HashSet<>();
            if (StrategySchedulings != null) {
                List<StrategyScheduling> selecteds = StrategySchedulings.stream().filter(t -> t.isValue() == true).sorted(Comparator.comparingInt(StrategyScheduling::getSort) ).collect(Collectors.toList());
                if (selecteds != null && selecteds.size() > 0) {
                    int i = 1;
                    for (StrategyScheduling strategy : selecteds) {

                       int Amplitude= strategy.getAmplitude();
                        if (strategy.getName().equals("customer_due_date")) {
                            OrderSortRule.SortCondition condition = new OrderSortRule.SortCondition();
                            condition.setSequence(i);
                            if(Amplitude>0) {
                                condition.setFieldName("groupDueDate");
                                DateGroupUtil.calculateGroupDueDate(orders, "dueDate", "groupDueDate", strategy.getAmplitude());

                            }else {
                                condition.setFieldName("dueDate");
                            }
                            condition.setReverse(false); // 递增
                            conditions.add(condition);
                            files.add("groupDueDate");
                            i++;


                        } else if (strategy.getName().equals("startd_date") ) {
                            OrderSortRule.SortCondition condition = new OrderSortRule.SortCondition();
                            condition.setSequence(i);
                            if(Amplitude>0) {
                                condition.setFieldName("groupStartDate");
                                DateGroupUtil.calculateGroupDueDate(orders, "startDate", "groupStartDate", strategy.getAmplitude());

                            }else {
                                condition.setFieldName("startDate");
                            }
                            condition.setReverse(false); // 递增
                            conditions.add(condition);
                            files.add("groupStartDate");
                            i++;

                        } else if (strategy.getName().equals("gathering_series")) {
                            OrderSortRule.SortCondition condition = new OrderSortRule.SortCondition();
                            condition.setSequence(i);
                            condition.setFieldName("serie");
                            condition.setReverse(false); // 递增
                            conditions.add(condition);
                            files.add("serie");
                            i++;
                        } else if (strategy.getName() .equals( "Minimum_wo_priority") && !files.contains("priority")) {
                            OrderSortRule.SortCondition condition = new OrderSortRule.SortCondition();
                            condition.setSequence(i);
                            condition.setFieldName("priority");
                            condition.setReverse(false); // 递增
                            conditions.add(condition);
                            files.add("priority");
                            i++;
                        } else if (strategy.getName() .equals( "maximum_wo_priority") && !files.contains("priority")) {
                            OrderSortRule.SortCondition condition = new OrderSortRule.SortCondition();
                            condition.setSequence(i);
                            condition.setFieldName("priority");
                            condition.setReverse(true); // 高优先级在前
                            conditions.add(condition);
                            files.add("priority");
                            i++;
                        } else if (strategy.getName() .equals( "material_rise")) {
                            OrderSortRule.SortCondition condition = new OrderSortRule.SortCondition();
                            condition.setSequence(i);
                            condition.setFieldName("materialCode");
                            condition.setReverse(true); // 递增
                            conditions.add(condition);
                            files.add("materialCode");
                            i++;
                        } else if (strategy.getName() .equals( "plan_rise") && !files.contains("orderCode")) {
                            OrderSortRule.SortCondition condition = new OrderSortRule.SortCondition();
                            condition.setSequence(i);
                            condition.setFieldName("orderCode");
                            condition.setReverse(true); // 递增
                            conditions.add(condition);
                            files.add("orderCode");
                            i++;
                        } else if (strategy.getName() .equals( "plan_drop") && !files.contains("orderCode")) {
                            OrderSortRule.SortCondition condition = new OrderSortRule.SortCondition();
                            condition.setSequence(i);
                            condition.setFieldName("orderCode");
                            condition.setReverse(false); // 递减
                            conditions.add(condition);
                            files.add("orderCode");
                            i++;
                        }

                    }

                } else {
                    OrderSortRule.SortCondition condition3 = new OrderSortRule.SortCondition();
                    condition3.setSequence(1);
                    condition3.setFieldName("priority");
                    condition3.setReverse(true); // 高优先级在前
                    conditions.add(condition3);
                }

            } else {
                OrderSortRule.SortCondition condition3 = new OrderSortRule.SortCondition();
                condition3.setSequence(1);
                condition3.setFieldName("priority");
                condition3.setReverse(true); // 高优先级在前
                conditions.add(condition3);

            }

            rule.setConditions(conditions);
            return rule;
        } catch (Exception e) {
            // 捕获异常（字段不存在/类型错误/空值等）
            e.printStackTrace();
            return null;
        }

    }
    private final Map<String, Object> CommonCache = new HashMap<>();
    private List<Material> InitMaterial() {
        List<Material> materials=new ArrayList<>();

//       List<MaterialInfo> materiallist=  materialInfoService.lambdaQuery()
//                .eq(MaterialInfo::getIsdeleted,0)
//               .list();

        List<Material> cmaterials= (List<Material>)CommonCache.get("material");
        if(cmaterials!=null)
        {

            return cmaterials;

        }
        LambdaQueryWrapper<MaterialInfo> MaterialInfoWrapper = new LambdaQueryWrapper<>();
        MaterialInfoWrapper.eq(MaterialInfo::getIsdeleted,0);





            List<String> ids=new ArrayList<>();

        MaterialInfoWrapper.in(MaterialInfo::getId,ids);
        List<MaterialInfo> materiallist=     materialInfoMapper.selectList(MaterialInfoWrapper);




      //  List<ProdEquipSpecialCal> ProdEquipSpecialCals=  _prodEquipSpecialCalService.list(ProdEquipSpecialCalWrapper);





        List<Stock> Stocklist=  stockService.lambdaQuery()
                .eq(Stock::getIsdeleted,0)
                .gt(Stock::getTotal,0)
                .list();

        materiallist.forEach(m -> {
            Material material=new Material();
            material.setId(m.getId());
            material.setMaterialType(m.getMaterialType());
            material.setMaterialTypeName(m.getMaterialTypeName());
            material.setCkeckLeadTime(m.getInspectDuration());
            material.setPurchaseLeadTime(m.getPurchaseDuration());
          double stock=  Stocklist.stream()
                    .filter(t->t.getMaterialId().equals(m.getId()))
                    .mapToDouble(Stock::getTotal)
                    .sum();
            material.setCurrentStock(stock);
            materials.add(material);
        });
        CommonCache.put("material",materials);
        return materials;
    }

    private Map<Integer, Object> InitEntrys(String SceneId,List<ProdEquipment> ProdEquipments,List<Order> ProdLaunchOrders)
    {
        return  _routingDataService.InitEntrys(SceneId,ProdEquipments,ProdLaunchOrders);
    }



    public GenVO convertGeneToGenVO(Gene gene, LocalDateTime baseTime) {
        GenVO genVO = new GenVO();
        genVO.setOrderId(String.valueOf(gene.getOrderId()));
        genVO.setOperationId(gene.getOperationId());
        genVO.setEquipId(gene.getMachineId());
        genVO.setQuantity(BigDecimal.valueOf(gene.getBatchSize()));
        genVO.setStartTime(baseTime.plusMinutes(gene.getStartTime()));
        genVO.setEndTime(baseTime.plusMinutes(gene.getEndTime()));
        genVO.setOperationName(""); // 从其他数据源获取
        genVO.setEquipName(""); // 从其他数据源获取
        return genVO;
    }

    // 批量转换
    public List<GenVO> convertGeneListToGenVO(List<Gene> geneList, LocalDateTime baseTime) {
        return geneList.stream()
                .map(gene -> convertGeneToGenVO(gene, baseTime))
                .collect(Collectors.toList());
    }

    public List<MachineVO> convertMachineListToVO(List<Machine> machines) {
        return machines.stream()
                .map(this::convertToVO)
                .collect(Collectors.toList());
    }

    private MachineVO convertToVO(Machine machine) {
        MachineVO machineVO = new MachineVO();
        machineVO.setId(machine.getId());
        machineVO.setEquipId(String.valueOf(machine.getId()));
        machineVO.setEquipName(machine.getName());
        // 注意：tasks 字段需要在其他地方设置，因为 Machine 类中没有任务信息
        return machineVO;
    }





    public List<Machine> InitCalendarToAllMachines1(String SceneId) {
        // 按设备分组
        List<ProdEquipment> ProdEquipments=  _prodEquipmentService.lambdaQuery()
                .eq(ProdEquipment::getSceneId,SceneId)
                .list();
        List<Long> MachineIds = ProdEquipments.stream()
                .map(ProdEquipment::getEquipId)
                .distinct()
                .sorted()
                .collect(Collectors.toList());

        List<Machine> machines=new ArrayList<>();

        for (Long id : MachineIds) {
            Machine machine=new Machine();
            machine.setId(id);
            machines.add(machine);
        }
        //节假日
        List<MesHoliday> holidays=  _MesHolidayService.list();

        LambdaQueryWrapper<ProdEquipSpecialCal> ProdEquipSpecialCalWrapper = new LambdaQueryWrapper<>();
        ProdEquipSpecialCalWrapper.eq(ProdEquipSpecialCal::getSceneId, SceneId);

        List<PlanResource> PlanResources=  _PlanResourceService.lambdaQuery()
                .eq(PlanResource::getIsdeleted,0)
                .list();



        List<ProdEquipSpecialCal> ProdEquipSpecialCals=  _prodEquipSpecialCalService.list(ProdEquipSpecialCalWrapper);

        List<MesShiftWorkSched> MesShiftWorkScheds=  _MesShiftWorkSchedService.lambdaQuery()
                .eq(MesShiftWorkSched::getIsdeleted,0).list();


        if (machines == null) {
            return null;
        }

        for (Machine machine : machines) {
            // 确保维护窗口列表不为null
            if (machine.getMaintenanceWindows() == null) {
                machine.setMaintenanceWindows(new ArrayList<>());
            }
            List<ProdEquipSpecialCal> machineProdEquipSpecialCals = ProdEquipSpecialCals.stream()
                    .filter(t -> t.getEquipId() == machine.getId()&&t.getReferenceType()==1)
                    .collect(Collectors.toList());
            List<Shift> shifts1=new ArrayList<>();
            for (ProdEquipSpecialCal machineProdEquipSpecialCal : machineProdEquipSpecialCals) {

                List<MesShiftWorkSched> ShiftWorkScheds = MesShiftWorkScheds.stream()
                        .filter(t -> (long) t.getWeekWorkSchedId() == machineProdEquipSpecialCal.getReferenceId())
                        .collect(Collectors.toList());
                List<Shift> Shifts = mergeShiftData(ShiftWorkScheds);
                for (Shift shift : Shifts) {

                    shift.setMachineId(machine.getId());
                    shift.setStartDate(machineProdEquipSpecialCal.getStartDate());
                    shift.setEndDate(machineProdEquipSpecialCal.getEndDate());
                    shifts1.add(shift);
                }
            }





            // 转换为列表返回
            List<Shift> result = new ArrayList<>();
            for (Shift shift : shifts1) {
                // 处理跨天班次（开始时间晚于结束时间的情况，如 7:30 到 3:30）
                if (shift.getEndTime().isBefore(shift.getStartTime())) {
                    // 创建第一天的班次 (开始时间到24:00)
                    Shift firstShift = new Shift();
                    firstShift.setStartTime(shift.getStartTime());
                    firstShift.setEndTime(LocalTime.of(23, 59, 59)); // 23:59:59代替24:00
                    firstShift.setDays(new HashSet<>(shift.getDays()));
                    firstShift.setStatus(shift.getStatus());

                    // 创建第二天的班次 (00:00到结束时间)
                    Shift secondShift = new Shift();
                    secondShift.setStartTime(LocalTime.MIDNIGHT);
                    secondShift.setEndTime(shift.getEndTime());
                    secondShift.setDays(new HashSet<>(shift.getDays()));
                    secondShift.setStatus(shift.getStatus());

                    result.add(firstShift);
                    result.add(secondShift);
                } else {
                    // 正常班次直接添加
                    result.add(shift);
                }
            }
            machine.setShifts(result);


            List<ProdEquipSpecialCal> Holidays = ProdEquipSpecialCals.stream()
                    .filter(t -> t.getEquipId() == machine.getId()&&t.getReferenceType()==2)
                    .collect(Collectors.toList());
            List<Holiday> Holidays1=new ArrayList<>();
            for (ProdEquipSpecialCal machineProdEquipSpecialCal : Holidays) {

                Holiday holiday=new Holiday();
                holiday.setStart(machineProdEquipSpecialCal.getStartDate());
                holiday.setEnd(machineProdEquipSpecialCal.getEndDate());
                Holidays1.add(holiday);
            }
            machine.setHolidays(Holidays1);



        }


        return  machines;


    }
    /**
     * 合并重复的ShiftData，将serialNumber收集为列表
     * @param originalList 原始数据列表
     * @return 合并后的MergedShiftData列表
     */
    public static List<Shift> mergeShiftData(List<MesShiftWorkSched> originalList) {
        // 按shiftStart和shiftEnd分组
        Map<String, Shift> groupMap = new HashMap<>();

        for (MesShiftWorkSched data : originalList) {
            // 用shiftStart+shiftEnd作为分组key
            String groupKey = data.getShiftStart().toString() + "_" + data.getShiftEnd().toString();

            if (groupMap.containsKey(groupKey)) {
                // 已存在分组：添加serialNumber到列表
                Shift merged = groupMap.get(groupKey);
                merged.getDays().add(data.getStartWeekDay());
            } else {
                // 新分组：创建MergedShiftData并初始化
                Shift merged = new Shift();

                merged.setStartTime(data.getShiftStart().toLocalTime());
                merged.setEndTime(data.getShiftEnd().toLocalTime());
                merged.setStatus(0);

                // 初始化序号列表
                Set<Integer> serials =new HashSet<>();
                serials.add(data.getStartWeekDay());
                merged.setDays(serials);
                groupMap.put(groupKey, merged);
            }
        }

        // 转换为列表返回
        return new ArrayList<>(groupMap.values());
    }



    /**
     * 将 ScheduleChromosome 转换为 ResourceGanttVO 列表
     * @param scheduleChromosome 调度结果
     * @param machineList 机器列表
     * @return 转换后的数据
     */
    public List<com.aps.entity.Gantt.ResourceGanttVO> convertToResourceGanttVO1(Chromosome scheduleChromosome, List<Machine> machineList) {
        List<com.aps.entity.Gantt.ResourceGanttVO> resourceGanttVOList = new ArrayList<>();


        List<Entry> allOperations = scheduleChromosome.getAllOperations();
        // 遍历所有机器资源
        if (machineList != null) {
            for (int i = 0; i < machineList.size(); i++) {
                Machine machine = machineList.get(i);

                com.aps.entity.Gantt.ResourceGanttVO resourceGanttVO = new com.aps.entity.Gantt.ResourceGanttVO();
                resourceGanttVO.setId(machine.getId());
                resourceGanttVO.setName(machine.getId()+"号设备");
                resourceGanttVO.setShift(convertToShiftVO(machine));
                resourceGanttVO.setCode(machine.getCode());
                // 转换任务列表
                List<com.aps.entity.Gantt.TaskVO> taskVOList = new ArrayList<>();
                if (scheduleChromosome.getResult() != null) {
                    // 筛选出属于当前设备的任务
                    List<GAScheduleResult> machineGenes = scheduleChromosome.getResult().stream()
                            .filter(gene -> gene.getMachineId()==(machine.getId()))
                            .collect(Collectors.toList());

                    // 按开始时间排序
                    machineGenes.sort((g1, g2) -> Integer.compare(g1.getStartTime(), g2.getStartTime()));

                    for (GAScheduleResult gene : machineGenes) {

                        Entry entry = allOperations.stream()
                                .filter(t -> t.getId() == gene.getOperationId()).findFirst().orElse(null);


                        com.aps.entity.Gantt.TaskVO taskVO = new com.aps.entity.Gantt.TaskVO();
                        taskVO.setId(String.valueOf(gene.getOperationId()));
                        taskVO.setPlanId(gene.getOrderId()); // 默认值
//                        taskVO.setProductType(0); // 默认值
//                        taskVO.setProductName("产品"+gene.getProductId());
                        taskVO.setProductId(gene.getProductId()); // 默认值
                        taskVO.setQuantity(gene.getQuantity());
                        taskVO.setStart(scheduleChromosome.getBaseTime().plusSeconds(gene.getStartTime()));
                        taskVO.setEnd(scheduleChromosome.getBaseTime().plusSeconds(gene.getEndTime()));
                        taskVO.setSetup(0); // 默认值
                        taskVO.setTeardown(gene.getTeardownTime()); // 默认值
                        taskVO.setEquipChange(gene.getChangeoverTime()); // 默认值
                        taskVO.setEquipCooling(0); // 默认值
                        taskVO.setEquipType(resourceGanttVO.getType());
                        taskVO.setEquipName(resourceGanttVO.getName());
                        taskVO.setLocked(gene.isIsLocked()); // 默认值
                        if (entry != null) {
                            taskVO.setSeq(Math.toIntExact(entry.getTaskSeq())); // 使用工序ID
                            taskVO.setSeqName(entry.getRoutingDetailName());
                        }

//                        taskVO.setDuration(calculateDuration(
//                                scheduleChromosome.getBaseTime().plusMinutes(gene.getStartTime()),
//                                scheduleChromosome.getBaseTime().plusMinutes(gene.getEndTime()))); // 计算持续时间

                        taskVO.setDuration(0); //
                        taskVO.setEquipId(machine.getId());
                        taskVO.setShopId(machine.getId());
                        taskVO.setShopName(resourceGanttVO.getShopName());
                        taskVO.setStatus(0); // 默认值
                        taskVO.setDetailId((long) gene.getStartTime()); // 将productId和operationID组合为detailId
                        taskVO.setHeaderId(gene.getEndTime()); // 默认值
//                        taskVO.setHeaderName("工艺"+gene.getProductId()); // 默认值
//                        taskVO.setSeq(gene.getSequenceId()); // 使用工序ID
//                        taskVO.setSeqName( "工序名称"+gene.getSequenceId());
                        taskVO.setProcessingTime(gene.getProcessingTime());
//                        taskVO.setAbsoluteStart(scheduleChromosome.getBaseTime().plusMinutes(gene.getStartTime()));
//                        taskVO.setAbsoluteEnd(scheduleChromosome.getBaseTime().plusMinutes(gene.getEndTime()));
                        taskVOList.add(taskVO);

                        // 调试：检查machine中的shifts状态
//                        if (machine.getShifts() != null) {
//                            for (Shift shift : machine.getShifts()) {
//                                System.out.println("Before setting shifts - Shift status: " + shift.getStatus());
//                            }
//                        }

                        taskVO.setAbsolutePreparationTime(gene.getTeardownTime());



                    }
                }

                resourceGanttVO.setList(taskVOList);
                resourceGanttVOList.add(resourceGanttVO);
            }
        }

        return resourceGanttVOList;
    }

    /**
     * 将 ScheduleChromosome 转换为 ProductGanttVO 列表
     * @param scheduleChromosome 调度结果
     * @return 转换后的数据
     */
    public List<com.aps.entity.Gantt.ProductGanttVO> convertToProductGanttVO1(Chromosome scheduleChromosome) {
        List<com.aps.entity.Gantt.ProductGanttVO> productGanttVOList = new ArrayList<>();

        // 按产品ID和工单ID分组基因
        if (scheduleChromosome.getResult() != null) {
            // 按工单ID分组
            scheduleChromosome.getResult().stream()
                    .collect(Collectors.groupingBy(GAScheduleResult::getOrderId))
                    .forEach((orderId, genes) -> {
                        if (!genes.isEmpty()) {
                            com.aps.entity.Gantt.ProductGanttVO productGanttVO = new com.aps.entity.Gantt.ProductGanttVO();
                            GAScheduleResult firstGene = genes.get(0);
                            productGanttVO.setId(firstGene.getOrderId());
                            productGanttVO.setProductName("产品"+firstGene.getProductId()); // 默认值，实际应从订单数据获取
                            productGanttVO.setProductType(0);
                            productGanttVO.setProductId(firstGene.getProductId());
                            // 计算总数量（假设同一批次）
                            productGanttVO.setQuantity(firstGene.getQuantity());
                            productGanttVO.setCode("编号"+firstGene.getProductId()); // 默认值
                            productGanttVO.setShopId(firstGene.getMachineId()); // 默认值
                            productGanttVO.setShopName(firstGene.getMachineId()+"号线"); // 默认值
                            productGanttVO.setStatus("已发布");
//                            productGanttVO.setHeaderId(firstGene.getProductId());
                            productGanttVO.setHeaderName("工艺"+firstGene.getProductId()); // 默认值

                            // 计算开始和结束时间
                            int minStartTime = genes.stream()
                                    .mapToInt(GAScheduleResult::getStartTime)
                                    .min()
                                    .orElse(0);
                            int maxEndTime = genes.stream()
                                    .mapToInt(GAScheduleResult::getEndTime)
                                    .max()
                                    .orElse(0);

                            productGanttVO.setStartDate(scheduleChromosome.getBaseTime().plusMinutes(minStartTime));
                            productGanttVO.setEndDate(scheduleChromosome.getBaseTime().plusMinutes(maxEndTime));

                            // 转换任务列表
                            List<com.aps.entity.Gantt.TaskVO> taskVOList = new ArrayList<>();
//                            // 按工序顺序排序
//                            genes.sort((g1, g2) -> Integer.compare(g1.getSequenceId(), g2.getSequenceId()));

                            for (int i = 0; i < genes.size(); i++) {
                                GAScheduleResult gene = genes.get(i);
                                com.aps.entity.Gantt.TaskVO taskVO = new com.aps.entity.Gantt.TaskVO();
                                taskVO.setId(String.valueOf(gene.getOperationId())); // 生成唯一ID
                                taskVO.setPlanId(String.valueOf(orderId));
                                taskVO.setProductType(0);
                                taskVO.setProductName("产品"+gene.getProductId());
                                taskVO.setProductId(String.valueOf(gene.getProductId()));
                                taskVO.setQuantity(gene.getQuantity());
                                taskVO.setStart(scheduleChromosome.getBaseTime().plusSeconds(gene.getStartTime()));
                                taskVO.setEnd(scheduleChromosome.getBaseTime().plusSeconds(gene.getEndTime()));
                                taskVO.setSetup(0); // 默认值
                                taskVO.setTeardown(gene.getTeardownTime()); // 默认值
                                taskVO.setEquipChange(gene.getChangeoverTime()); // 默认值
                                taskVO.setEquipCooling(0); // 默认值
//                            taskVO.setEquipType("PTT-" + (i+1) + "-" + gene.getOperationName().toUpperCase().substring(0, Math.min(3, gene.getOperationName().length())));
//                            taskVO.setEquipName(gene.getOperationName());
                                taskVO.setDuration(calculateDuration(
                                        scheduleChromosome.getBaseTime().plusMinutes(gene.getStartTime()),
                                        scheduleChromosome.getBaseTime().plusMinutes(gene.getEndTime())));
                                taskVO.setEquipId(gene.getMachineId()); // 生成设备ID
                                taskVO.setShopId(gene.getMachineId());
                                taskVO.setShopName(gene.getMachineId()+"车间");
                                taskVO.setStatus(0);
//                                taskVO.setDetailId((long) gene.getProductId() * 1000 + gene.getOperationId());
//                                taskVO.setHeaderId(gene.getProductId());
                                taskVO.setHeaderName("工艺"+gene.getProductId());
//                                taskVO.setSeq(gene.getSequenceId());
//                                taskVO.setSeqName("工序名称"+gene.getSequenceId());
//                                taskVO.setAbsoluteStart(scheduleChromosome.getBaseTime().plusMinutes(gene.getStartTime()));
//                                taskVO.setAbsoluteEnd(scheduleChromosome.getBaseTime().plusMinutes(gene.getEndTime()));

                                taskVOList.add(taskVO);
                            }

                            productGanttVO.setList(taskVOList);
                            productGanttVOList.add(productGanttVO);
                        }
                    });
        }

        return productGanttVOList;
    }




    private ShiftVO convertToShiftVO(Machine machine) {
        ShiftVO shiftVO= new ShiftVO();
        shiftVO.setId(machine.getId());
        shiftVO.setName(machine.getName());
        shiftVO.setShifts(machine.getShifts());
        shiftVO.setMaintenanceWindows(machine.getMaintenanceWindows());
        // 注意：tasks 字段需要在其他地方设置，因为 Machine 类中没有任务信息
        return shiftVO;
    }


    /**
     * 计算任务持续时间（分钟）
     * @param start 开始时间
     * @param end 结束时间
     * @return 持续时间（分钟）
     */
    private Integer calculateDuration(LocalDateTime start, LocalDateTime end) {
        if (start == null || end == null) {
            return 0;
        }
        return Math.toIntExact(java.time.Duration.between(start, end).toMinutes());
    }



}