package com.aps;

import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;
import javax.sql.DataSource;
import java.sql.Connection;

@Component
public class DatabaseTester implements CommandLineRunner {
    
    private final DataSource dataSource;
    
    public DatabaseTester(DataSource dataSource) {
        this.dataSource = dataSource;
    }
    
    @Override
    public void run(String... args) throws Exception {
        try (Connection conn = dataSource.getConnection()) {
            System.out.println("数据库连接成功！");
            System.out.println("数据库: " + conn.getMetaData().getDatabaseProductName());
        } catch (Exception e) {
            System.out.println("数据库连接失败: " + e.getMessage());
        }
    }
}