package com.aps.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.aps.common.util.R;
import com.aps.entity.ApsTimeConfig;
import com.aps.service.ApsTimeConfigService;

import java.util.Map;


/**
 * <p>
 * APS时间配置表 前端控制器
 * </p>
 *
 * @author MyBatis-Plus
 * @since 2025-12-23
 */

@RestController
@RequestMapping("/apsTimeConfig")
@Tag(name = "APS时间配置管理", description = "APS时间配置管理")
public class ApsTimeConfigController {
    
    @Autowired
    private ApsTimeConfigService apsTimeConfigService;
    
    /**
     * 获取APS时间配置
     */
    @GetMapping("/getConfig")
    @Operation(summary = "获取APS时间配置", description = "获取APS时间配置信息")
    public R<ApsTimeConfig> getConfig() {
        ApsTimeConfig config = apsTimeConfigService.getConfig();
        if (config != null) {
            return R.ok(config);
        } else {
            // 如果没有配置，返回默认配置
            config = new ApsTimeConfig();
            return R.ok(config);
        }
    }
    
    /**
     * 更新APS时间配置
     */
    @PutMapping("/updateConfig")
    @Operation(summary = "更新APS时间配置", description = "通过Map参数更新APS时间配置")
    public R<String> updateConfig(@RequestBody Map<String, Object> configMap) {
        boolean result = apsTimeConfigService.updateConfigFromMap(configMap);
        if (result) {
            return R.ok("配置更新成功");
        } else {
            return R.failed("配置更新失败");
        }
    }
}
