package com.aps.service.Algorithm;

import com.aps.common.util.ProductionDeepCopyUtil;
import com.aps.entity.Algorithm.*;
import com.aps.entity.Algorithm.IDAndChildID.GroupResult;
import com.aps.entity.Algorithm.IDAndChildID.NodeInfo;
import com.aps.entity.basic.*;
import com.aps.service.plan.MachineSchedulerService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.ScopeMetadata;

import javax.xml.transform.Result;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/**
 * 作者：佟礼
 * 时间：2025-11-30
 */
public class ScheduleOperationService {



    /**
     * 移动工序方法
     * @param chromosome 染色体对象
     * @param opIds 工序ID
     * @param newStartTime 新开始时间
     * @param newMachineId 新设备ID
     */
    public void moveOperation(Chromosome chromosome, List<Integer> opIds, int newStartTime,
                              Long newMachineId, GlobalParam globalParam) {
        List<Entry> allOperations = chromosome.getAllOperations();
int newStartTime1=newStartTime;
        Map<Integer, Integer> opTimeMap = chromosome.getResult().stream()
                .collect(Collectors.toMap(
                        GAScheduleResult::getOperationId,
                        r ->  r.getStartTime()
                ));
Integer newMachineId1=newMachineId.intValue();
        for (Integer opId:opIds) {


            // 获取目标结果和工序
            GAScheduleResult targetResult = chromosome.getResult().stream()
                    .filter(r -> r.getOperationId() == opId)
                    .findFirst()
                    .orElseThrow(() -> new NoSuchElementException("Operation not found: " + opId));

            Entry targetOp = allOperations.stream()
                    .filter(o -> o.getId() == opId)
                    .findFirst()
                    .orElseThrow(() -> new NoSuchElementException("Operation not found: " + opId));

            if(newMachineId1!=0) {
                int machineOptionIndex = targetOp.getMachineOptions().stream()
                        .map(MachineOption::getMachineId)
                        .collect(Collectors.toList())
                        .indexOf(newMachineId) + 1;

                if (machineOptionIndex == 0) {
                    throw new NoSuchElementException("Machine not found: " + newMachineId);
                }


                // 更新设备选择序列
                int globalOpIndex = chromosome.getGlobalOpList().stream()
                        .filter(g -> g.getOp().getId() == opId)
                        .findFirst()
                        .map(GlobalOperationInfo::getGlobalOpId)
                        .orElseThrow(() -> new NoSuchElementException("Global operation not found: " + opId));


                chromosome.getMachineSelection().set(globalOpIndex, machineOptionIndex);
                targetResult.setForcedMachineId(newMachineId);
            }else {
                newMachineId1=(int)targetResult.getMachineId();
            }
            // 设置约束
            targetResult.setDesignatedStartTime(newStartTime);


            if(targetOp.getSequence()==1) {
                opTimeMap.put(opId, newStartTime);
            }else {
                Entry targetOp1 = allOperations.stream()
                        .filter(o -> o.getGroupId() == targetOp.getGroupId()
                                &&o.getSequence()==targetOp.getSequence()-1)
                        .findFirst()
                        .orElseThrow(() -> new NoSuchElementException("Operation not found: " + opId));
                GAScheduleResult targetResult1 = chromosome.getResult().stream()
                        .filter(r -> r.getOperationId() == targetOp1.getId())
                        .findFirst()
                        .orElseThrow(() -> new NoSuchElementException("Operation not found: " + opId));
                if(targetResult1.getStartTime()<newStartTime)
                {
                    opTimeMap.put(opId, newStartTime);
                }else {
                    opTimeMap.put(opId, targetResult1.getStartTime()+1);
                }
            }
            newStartTime=newStartTime+1;
        }


        Long newMachineId2=newMachineId1.longValue();
            GAScheduleResult FirstMachineResult = chromosome.getResult().stream()
                    .filter(r -> r.getMachineId() ==newMachineId2 && r.getStartTime() >= newStartTime1)
                    .findFirst()
                    .orElse(null);
            if (FirstMachineResult != null) {
                if(opTimeMap.get(FirstMachineResult.getOperationId())<newStartTime)
                {
                    opTimeMap.put(FirstMachineResult.getOperationId(), newStartTime);
                }

            }

        // 生成新的工序顺序




        List<Integer> operationSequencing = allOperations.stream()
                .sorted((op1, op2) -> {
                    int time1 = opTimeMap.getOrDefault(op1.getId(), Integer.MAX_VALUE);
                    int time2 = opTimeMap.getOrDefault(op2.getId(), Integer.MAX_VALUE);
                    if (time1 != time2) {
                        return Integer.compare(time1, time2);
                    } else {
                        return Integer.compare(op1.getSequence(), op2.getSequence());
                    }
                })
                .map(Entry::getGroupId)
                .collect(Collectors.toList());

        chromosome.setOperationSequencing(operationSequencing);
// 重新解码
        redecode(chromosome, chromosome.getBaseTime(), globalParam);


    }



    public void editMachineOption(Chromosome chromosome,Entry operation,
                              Long newMachineId, GlobalParam globalParam) {
        List<Entry> allOperations = chromosome.getAllOperations();

        Map<Integer, Integer> opTimeMap = chromosome.getResult().stream()
                .collect(Collectors.toMap(
                        GAScheduleResult::getOperationId,
                        r ->  r.getStartTime()
                ));
        Integer newMachineId1=newMachineId.intValue();

        int opId = operation.getId();
            // 获取目标结果和工序
            GAScheduleResult targetResult = chromosome.getResult().stream()
                    .filter(r -> r.getOperationId() == opId)
                    .findFirst()
                    .orElseThrow(() -> new NoSuchElementException("Operation not found: " + opId));

            Entry targetOp = allOperations.stream()
                    .filter(o -> o.getId() == opId)
                    .findFirst()
                    .orElseThrow(() -> new NoSuchElementException("Operation not found: " + opId));

            if(newMachineId1!=0) {
                int machineOptionIndex = targetOp.getMachineOptions().stream()
                        .map(MachineOption::getMachineId)
                        .collect(Collectors.toList())
                        .indexOf(newMachineId) + 1;

                if (machineOptionIndex == 0) {
                    throw new NoSuchElementException("Machine not found: " + newMachineId);
                }


                // 更新设备选择序列
                int globalOpIndex = chromosome.getGlobalOpList().stream()
                        .filter(g -> g.getOp().getId() == opId)
                        .findFirst()
                        .map(GlobalOperationInfo::getGlobalOpId)
                        .orElseThrow(() -> new NoSuchElementException("Global operation not found: " + opId));


                chromosome.getMachineSelection().set(globalOpIndex, machineOptionIndex);
                targetResult.setForcedMachineId(newMachineId);
            }






        List<Integer> operationSequencing = allOperations.stream()
                .sorted((op1, op2) -> {
                    int time1 = opTimeMap.getOrDefault(op1.getId(), Integer.MAX_VALUE);
                    int time2 = opTimeMap.getOrDefault(op2.getId(), Integer.MAX_VALUE);
                    if (time1 != time2) {
                        return Integer.compare(time1, time2);
                    } else {
                        return Integer.compare(op1.getSequence(), op2.getSequence());
                    }
                })
                .map(Entry::getGroupId)
                .collect(Collectors.toList());

        chromosome.setOperationSequencing(operationSequencing);
// 重新解码
        redecode(chromosome, chromosome.getBaseTime(), globalParam);


    }





    public void editMachine(Chromosome chromosome,Entry operation,
                                  Long newMachineId, GlobalParam globalParam) {
        List<Entry> allOperations = chromosome.getAllOperations();

        Map<Integer, Integer> opTimeMap = chromosome.getResult().stream()
                .collect(Collectors.toMap(
                        GAScheduleResult::getOperationId,
                        r ->  r.getStartTime()
                ));
        Integer newMachineId1=newMachineId.intValue();

        int opId = operation.getId();
        // 获取目标结果和工序
        GAScheduleResult targetResult = chromosome.getResult().stream()
                .filter(r -> r.getOperationId() == opId)
                .findFirst()
                .orElseThrow(() -> new NoSuchElementException("Operation not found: " + opId));

        Entry targetOp = allOperations.stream()
                .filter(o -> o.getId() == opId)
                .findFirst()
                .orElseThrow(() -> new NoSuchElementException("Operation not found: " + opId));

        if(newMachineId1!=0) {
            int machineOptionIndex = targetOp.getMachineOptions().stream()
                    .map(MachineOption::getMachineId)
                    .collect(Collectors.toList())
                    .indexOf(newMachineId) + 1;

            if (machineOptionIndex == 0) {
                throw new NoSuchElementException("Machine not found: " + newMachineId);
            }

            // 更新设备选择序列
            int globalOpIndex = chromosome.getGlobalOpList().stream()
                    .filter(g -> g.getOp().getId() == opId)
                    .findFirst()
                    .map(GlobalOperationInfo::getGlobalOpId)
                    .orElseThrow(() -> new NoSuchElementException("Global operation not found: " + opId));


            chromosome.getMachineSelection().set(globalOpIndex, machineOptionIndex);
            targetResult.setForcedMachineId(newMachineId);
        }






        List<Integer> operationSequencing = allOperations.stream()
                .sorted((op1, op2) -> {
                    int time1 = opTimeMap.getOrDefault(op1.getId(), Integer.MAX_VALUE);
                    int time2 = opTimeMap.getOrDefault(op2.getId(), Integer.MAX_VALUE);
                    if (time1 != time2) {
                        return Integer.compare(time1, time2);
                    } else {
                        return Integer.compare(op1.getSequence(), op2.getSequence());
                    }
                })
                .map(Entry::getGroupId)
                .collect(Collectors.toList());

        chromosome.setOperationSequencing(operationSequencing);
// 重新解码
        redecode(chromosome, chromosome.getBaseTime(), globalParam);


    }










    /**
     * 增加设备维修保养
     * @param chromosome 染色体对象

     */
    public void AddMaintenanceWindow(Chromosome chromosome,Long machineId, MaintenanceWindow maintenanceWindow,
                               GlobalParam globalParam) {

       Machine machine= chromosome.getInitMachines().stream().filter(t->t.getId()==machineId)
                .findFirst().orElse(null);
       if(machine!=null)
       {
           // 检查时间是否与现有维护窗口重复
           if (isTimeOverlap(machine.getMaintenanceWindows(), maintenanceWindow)) {
               throw new RuntimeException("维修时间已存在");
           }

           maintenanceWindow.setEquipCode(machine.getCode());
           maintenanceWindow.setEquipName(machine.getName());

           maintenanceWindow.setId(UUID.randomUUID().toString());

           machine.getMaintenanceWindows().add(maintenanceWindow);

           MachineSchedulerService machineScheduler = new MachineSchedulerService(
                   chromosome.getBaseTime());

           machineScheduler.ClearMachineCache(machineId);
           MachineTimeline machineTimeline = machineScheduler.getOrCreateTimeline(machine);
           machine.setAvailability(machineTimeline.getSegments());
       }else {

           throw new RuntimeException("未找到设备");
       }

        redecode(chromosome, chromosome.getBaseTime(), globalParam);

    }

    /**
     * 检查新维护窗口是否与现有维护窗口时间重叠
     * @param existingWindows 现有维护窗口列表
     * @param newWindow 新维护窗口
     * @return 如果时间重叠返回true，否则返回false
     */
    private boolean isTimeOverlap(List<MaintenanceWindow> existingWindows, MaintenanceWindow newWindow) {
        if (existingWindows == null || existingWindows.isEmpty()) {
            return false;
        }

        for (MaintenanceWindow existingWindow : existingWindows) {
            // 检查时间是否重叠：新窗口开始时间 < 现有窗口结束时间 && 新窗口结束时间 > 现有窗口开始时间
            if (newWindow.getStartTime().isEqual(existingWindow.getEndTime()) &&
                newWindow.getEndTime().isEqual(existingWindow.getStartTime())) {
                return true;
            }
        }
        return false;
    }

    public List<MaintenanceWindow> GetMaintenanceWindow(Chromosome chromosome,Long machineId) {

        if(machineId==0)
        {
            return chromosome.getMachines().stream()
                    // 过滤掉null的机器对象
                    .filter(machine -> machine != null)
                    // 过滤掉维护窗口为null的机器（避免后续空指针）
                    .filter(machine -> machine.getMaintenanceWindows() != null)
                    // 提取维护窗口列表（此时流是 Stream<List<MaintenanceWindow>>）
                    .map(Machine::getMaintenanceWindows)
                    // 扁平化为 Stream<MaintenanceWindow>（核心：将嵌套列表“拍平”）
                    .flatMap(List::stream)
                    // 收集为最终的List结果
                    .collect(Collectors.toList());
        }

        Machine machine= chromosome.getMachines().stream().filter(t->t.getId()==machineId)
                .findFirst().orElse(null);
        if(machine!=null)
        {
           return machine.getMaintenanceWindows();
        }else {

            throw new RuntimeException("未找到设备");
        }
    }

    public void DelMaintenanceWindow(Chromosome chromosome,Long machineId,String maintenanceId,GlobalParam globalParam) {

        Machine machine= chromosome.getInitMachines().stream().filter(t->t.getId()==machineId)
                .findFirst().orElse(null);
        if(machine!=null)
        {
            List<MaintenanceWindow> maintenanceWindows= machine.getMaintenanceWindows();
            OptionalInt index = IntStream.range(0, maintenanceWindows.size())
                    .filter(i -> maintenanceId.equals(maintenanceWindows.get(i).getId()))
                    .findFirst();

            if (index.isPresent()) {
                machine.getMaintenanceWindows().remove(index.getAsInt());
                MachineSchedulerService machineScheduler = new MachineSchedulerService(
                        chromosome.getBaseTime());
                machineScheduler.ClearMachineCache(machineId);
                MachineTimeline machineTimeline = machineScheduler.getOrCreateTimeline(machine);
                machine.setAvailability(machineTimeline.getSegments());
            } else {
                throw new RuntimeException("未找到维护窗口");
            }

        }else {

            throw new RuntimeException("未找到设备");
        }

        redecode(chromosome, chromosome.getBaseTime(), globalParam);

    }

    /**
     * 批量删除维护窗口
     * @param chromosome 染色体对象
     * @param machineId 机器ID
     * @param maintenanceIds 要删除的维护窗口ID列表
     * @param globalParam 全局参数
     */
    public void DelMaintenanceWindowBatch(Chromosome chromosome, Long machineId, List<String> maintenanceIds, GlobalParam globalParam) {
        Machine machine = chromosome.getInitMachines().stream().filter(t -> t.getId() == machineId)
                .findFirst().orElse(null);
        if (machine != null) {
            List<MaintenanceWindow> maintenanceWindows = machine.getMaintenanceWindows();
            if (maintenanceWindows != null && maintenanceIds != null && !maintenanceIds.isEmpty()) {
                // 过滤出存在的维护窗口ID
                List<String> existingIds = maintenanceIds.stream()
                        .filter(id -> maintenanceWindows.stream().anyMatch(window -> id.equals(window.getId())))
                        .collect(Collectors.toList());
                
                if (existingIds.size() != maintenanceIds.size()) {
                    throw new RuntimeException("部分维护窗口未找到");
                }
                
                // 根据ID批量删除维护窗口
                maintenanceWindows.removeIf(window -> maintenanceIds.contains(window.getId()));
                
                MachineSchedulerService machineScheduler = new MachineSchedulerService(
                        chromosome.getBaseTime());
                MachineTimeline machineTimeline = machineScheduler.getOrCreateTimeline(machine);
                machine.setAvailability(machineTimeline.getSegments());
            }
        } else {
            throw new RuntimeException("未找到设备");
        }

        redecode(chromosome, chromosome.getBaseTime(), globalParam);
    }

        public void SpiltOperation(Chromosome chromosome, int opId,Double[] splitCounts, GlobalParam globalParam)
    {
        List<Entry> allOperations = chromosome.getAllOperations();

        List<GroupResult> OperatRels = chromosome.getOperatRel();

        Entry targetOp = allOperations.stream()
                .filter(o -> o.getId() == opId)
                .findFirst()
                .orElseThrow(() -> new NoSuchElementException("Operation not found: " + opId));

        GAScheduleResult targetSr = chromosome.getResult().stream()
                .filter(o -> o.getOperationId() == opId)
                .findFirst()
                .orElseThrow(() -> new NoSuchElementException("Operation not found: " + opId));

        // 找到原来的组和父子级
        GroupResult groupResult = OperatRels.get(targetOp.GroupId-1);
        List<NodeInfo> nodeInfoList = groupResult.getNodeInfoList();

        NodeInfo Oprel = nodeInfoList.stream()
                .filter(o -> o.getGlobalSerial() == opId)
                .findFirst()
                .orElseThrow(() -> new NoSuchElementException("Operation not found: " + opId));


        int targetGroupIndex = targetOp.GroupId - 1;
        List<Integer> newParentIds = Oprel.getNewParentIds();
        List<Integer> newChildIds = Oprel.getNewChildIds();
        //记录新的工序ID和数量
        Map<String,Double> newids=new HashMap<>();
        String MainId = UUID.randomUUID().toString().replace("-", "");

        for (int i=0;i<splitCounts.length;i++) {

            String newId = UUID.randomUUID().toString().replace("-", "");
            if (i == 0) {
                newids.put(targetOp.ExecId, splitCounts[i]);
            } else {
                newids.put(newId, splitCounts[i]);
                // 添加新节点
                OperatRels = IdGroupingWithDualSerial.addNode(OperatRels, targetGroupIndex, newId, newParentIds, newChildIds,targetOp.getExecId());
            }
         }
        chromosome.setOperatRel(OperatRels);
        //当前组的
         groupResult = OperatRels.get(targetGroupIndex);

         nodeInfoList = groupResult.getNodeInfoList();
         //全局ID
        int globalOpId = chromosome.getGlobalOpList().stream()
                .mapToInt(GlobalOperationInfo::getGlobalOpId)
                .max()
                .orElse(0)+1;

        //找到原工序用的设备序号
        List<MachineOption> optionalMachines = targetOp.getMachineOptions();
        OptionalInt index = IntStream.range(0, optionalMachines.size())
                .filter(i -> targetSr.getMachineId()==optionalMachines.get(i).getMachineId())
                .findFirst();
        int machineSeq =index.orElse(0)+1 ;
        List<Integer> OperationSequencing=  chromosome.getOperationSequencing();
        OptionalInt OperationIndex = IntStream.range(0, OperationSequencing.size())
                .filter(i -> OperationSequencing.get(i).equals(targetOp.GroupId)) // 过滤出值为1的索引
                .skip(targetOp.Sequence-1) // 跳过第一个匹配项
                .findFirst(); // 取第二个匹配项
       int targetOpIndex= OperationIndex.getAsInt()+1;
        for (NodeInfo nodeInfo : nodeInfoList) {
            Entry entry = allOperations.stream()
                    .filter(o -> o.getId() == nodeInfo.getGlobalSerial())
                    .findFirst()
                    .orElse(null);
            if(entry!=null)
            {
                //存在则修改顺和前后序
                entry.setSequence(nodeInfo.getGroupSerial());
               // entry.setPrevEntryIds(nodeInfo.getNewParentIds());
              //  entry.setNextEntryIds(nodeInfo.getNewChildIds());
                if(nodeInfo.getNewParentIds()!=null)
                {
                    List<OperationDependency> OperationDependency=new ArrayList<>();
                    for (int id : nodeInfo.getNewParentIds()) {
                        OperationDependency od=new OperationDependency();
                        od.setPrevOperationId(id);
                        OperationDependency.add(od);
                    }
                    entry.setPrevEntryIds(OperationDependency);
                }
                if(nodeInfo.getNewChildIds()!=null)
                {
                    List<OperationDependency> OperationDependency=new ArrayList<>();
                    for (int id : nodeInfo.getNewChildIds()) {
                        OperationDependency od=new OperationDependency();
                        od.setNextOperationId(id);
                        OperationDependency.add(od);
                    }
                    entry.setNextEntryIds(OperationDependency);
                }
                GlobalOperationInfo info= chromosome.getGlobalOpList().stream()
                        .filter(t->t.getOp().getId()==entry.getId())
                        .findFirst()
                        .orElse(null);

                if(info!=null) {
                    info.setSequence(nodeInfo.getGroupSerial());
                }
                if(entry.getId()==targetOp.getId())
                {
                    entry.setMainId(MainId);
                    entry.setState(1);
                    entry.setQuantity(newids.get(nodeInfo.getOriginalId()));
                }
            }else {
                //不存在创建新的
                Entry newOp = ProductionDeepCopyUtil.deepCopy(targetOp,Entry.class);
                newOp.setId(nodeInfo.getGlobalSerial());
                newOp.setSequence(nodeInfo.getGroupSerial());
                newOp.setExecId(nodeInfo.getOriginalId());
                newOp.setNewCreate(true);
               // newOp.setPrevEntryIds(nodeInfo.getNewParentIds());
               // newOp.setNextEntryIds(nodeInfo.getNewChildIds());
                if(nodeInfo.getNewParentIds()!=null)
                {
                    List<OperationDependency> OperationDependency=new ArrayList<>();
                    for (int id : nodeInfo.getNewParentIds()) {
                        OperationDependency od=new OperationDependency();
                        od.setPrevOperationId(id);
                        OperationDependency.add(od);
                    }
                    newOp.setPrevEntryIds(OperationDependency);
                }
                if(nodeInfo.getNewChildIds()!=null)
                {
                    List<OperationDependency> OperationDependency=new ArrayList<>();
                    for (int id : nodeInfo.getNewChildIds()) {
                        OperationDependency od=new OperationDependency();
                        od.setNextOperationId(id);
                        OperationDependency.add(od);
                    }
                    newOp.setNextEntryIds(OperationDependency);
                }
                newOp.setQuantity(newids.get(nodeInfo.getOriginalId()));
                newOp.setMainId(MainId);
                newOp.setState(2);
                //工序基本信息
                chromosome.getAllOperations().add(newOp);
                // 运算的全局变量
                GlobalOperationInfo info = new GlobalOperationInfo();
                info.setGlobalOpId(globalOpId);
                info.setGroupId(newOp.getGroupId());
                info.setSequence(newOp.getSequence());
                info.setOp(newOp);
                chromosome.getGlobalOpList().add(info);
                globalOpId++;
                //排产的机器选择部分
                chromosome.getMachineSelection().add(machineSeq);
                chromosome.getOperationSequencing().add(targetOpIndex,newOp.getGroupId());
                targetOpIndex++;
            }
        }

        redecode(chromosome, chromosome.getBaseTime(), globalParam);

    }
    public void SpiltOrder(Chromosome chromosome, String orderId,Double[] splitCounts, GlobalParam globalParam)
    {
        List<Entry> allOperations = chromosome.getAllOperations();

        List<Order> orders = chromosome.getOrders();

        List<GroupResult> OperatRels = chromosome.getOperatRel();

        List<Entry> targetOps = allOperations.stream()
                .filter(o -> o.getOrderId().equals(orderId) )
                .sorted(Comparator.comparing(Entry::getSequence))
                .collect(Collectors.toList());

        List<GAScheduleResult> targetSrs = chromosome.getResult().stream()
                .filter(o -> o.getOrderId().equals(orderId))
                .collect(Collectors.toList());

        Order order=orders.stream()
                .filter(o -> o.getOrderId().equals(orderId)  )
                .findFirst()
                .orElseThrow(() -> new NoSuchElementException("Order not found: " + orderId));

        int maxorderId =OperatRels.size() ;

        int maxgroupId =maxorderId ;

        //记录新的工序ID和数量
        List<Entry> newEntrys=new ArrayList<>();

        List<String> newIdList = new ArrayList<>();
        List<String> newChildIdList = new ArrayList<>();
        for (int i = 1; i < splitCounts.length; i++) {
            maxorderId++;
            Order neworder = ProductionDeepCopyUtil.deepCopy(order,Order.class);
            neworder.setOrderId(UUID.randomUUID().toString().replace("-", ""));
            if(splitCounts[0]!=0&&i==1) {// 数组第一个是0，为复制
                order.setQuantity(splitCounts[0]);
            }else {
                order.setQuantity(splitCounts[i]);
            }
            neworder.setMainId(order.getOrderId());
            neworder.setNewCreate(true);
            orders.add(neworder);
            for (Entry entry : targetOps) {
                if(splitCounts[0]!=0&&i==1) {// 数组第一个是0，为复制
                    entry.setQuantity(splitCounts[0]);
                }

                String newId = UUID.randomUUID().toString().replace("-", "");
                Entry newOp = ProductionDeepCopyUtil.deepCopy(entry,Entry.class);
                newOp.setExecId(newId);
                newOp.setOrderId(neworder.getOrderId());
                newOp.setOrderCode(neworder.getOrderCode());
                newOp.setGroupId(maxorderId);
                newOp.setQuantity(splitCounts[i]);
                newOp.setNewCreate(true);
                newEntrys.add(newOp);
            }
        }
        for (Entry entry : newEntrys) {
            if(entry.getNextEntryIds().size()>0)
            {
                for (OperationDependency od : entry.getNextEntryIds()) {

                    Entry nextentry=  newEntrys.stream()
                            .filter(t->t.getGroupId()==entry.getGroupId()&&t.getId()==od.getNextOperationId())
                            .findFirst()
                            .orElse(null);
                    if(nextentry!=null) {
                        newIdList.add(entry.getExecId());
                        newChildIdList.add(nextentry.getExecId());
                    }
                }
            }else if(entry.getSequence()==1)
            {
                newIdList.add(entry.getExecId());
                newChildIdList.add("");
            }
        }

        // 添加新数据
        OperatRels = IdGroupingWithDualSerial.addNewDataWithIsolatedGroup(OperatRels, newIdList, newChildIdList);
        chromosome.setOperatRel(OperatRels);
        //全局ID
        int globalOpId = chromosome.getGlobalOpList().stream()
                .mapToInt(GlobalOperationInfo::getGlobalOpId)
                .max()
                .orElse(0)+1;
        for (int i = maxgroupId; i < OperatRels.size(); i++) {
            GroupResult groupResult = OperatRels.get(i);
            List<NodeInfo> nodeInfoList = groupResult.getNodeInfoList();
            // System.out.println("分组" + (i + 1) + "顺序：" + nodeInfoList);
            for (NodeInfo nodeInfo : nodeInfoList) {
                Entry entry=  newEntrys.stream()
                        .filter(t->t.getExecId().equals(nodeInfo.getOriginalId()))
                        .findFirst()
                        .orElse(null);
                GAScheduleResult targetSr=  targetSrs.stream()
                        .filter(t->t.getOperationId()==entry.getId())
                        .findFirst()
                        .orElse(null);

                entry.setId(nodeInfo.getGlobalSerial());
                entry.setGroupId(i+1);
                entry.setSequence(nodeInfo.getGroupSerial());
                entry.setExecId(nodeInfo.getOriginalId());
               // entry.setPrevEntryIds(nodeInfo.getNewParentIds());
               // entry.setNextEntryIds(nodeInfo.getNewChildIds());
                if(nodeInfo.getNewParentIds()!=null)
                {
                    List<OperationDependency> OperationDependency=new ArrayList<>();
                    for (int id : nodeInfo.getNewParentIds()) {
                        OperationDependency od=new OperationDependency();
                        od.setPrevOperationId(id);
                        OperationDependency.add(od);
                    }
                    entry.setPrevEntryIds(OperationDependency);
                }
                if(nodeInfo.getNewChildIds()!=null)
                {
                    List<OperationDependency> OperationDependency=new ArrayList<>();
                    for (int id : nodeInfo.getNewChildIds()) {
                        OperationDependency od=new OperationDependency();
                        od.setNextOperationId(id);
                        OperationDependency.add(od);
                    }
                    entry.setNextEntryIds(OperationDependency);
                }
                entry.setMainId("");
                entry.setState(2);
                //工序基本信息
                chromosome.getAllOperations().add(entry);

                // 运算的全局变量
                GlobalOperationInfo info = new GlobalOperationInfo();
                info.setGlobalOpId(globalOpId);
                info.setGroupId(entry.getGroupId());
                info.setSequence(entry.getSequence());
                info.setOp(entry);
                chromosome.getGlobalOpList().add(info);
                globalOpId++;
                List<MachineOption> optionalMachines = entry.getMachineOptions();
                OptionalInt index = IntStream.range(0, optionalMachines.size())
                        .filter(h -> targetSr.getMachineId()==optionalMachines.get(h).getMachineId())
                        .findFirst();
                int machineSeq =index.orElse(0)+1 ;
                chromosome.getMachineSelection().add(machineSeq);

            }
        }


        for (Entry entry : targetOps) {
            List<Integer> OperationSequencing=  chromosome.getOperationSequencing();

            OptionalInt OperationIndex = IntStream.range(0, OperationSequencing.size())
                    .filter(i -> OperationSequencing.get(i).equals(entry.GroupId)) // 过滤出值为1的索引
                    .skip(entry.Sequence-1) // 跳过第一个匹配项
                    .findFirst();
            int targetOpIndex= OperationIndex.getAsInt()+1;
            for (int i = maxgroupId; i < OperatRels.size(); i++) {
                chromosome.getOperationSequencing().add(targetOpIndex, i+1);
                targetOpIndex++;
            }

        }

        redecode(chromosome, chromosome.getBaseTime(), globalParam);

    }
    public void MergeOrder(Chromosome chromosome, String sourceorderId,String targetorderId, GlobalParam globalParam) {
        List<Entry> allOperations = chromosome.getAllOperations();
        List<GlobalOperationInfo> globalOpList=  chromosome.getGlobalOpList();
        List<Order> orders = chromosome.getOrders();
        List<Integer> OperationSequencing=  chromosome.getOperationSequencing();
        List<GAScheduleResult> ScheduleResults = chromosome.getResult();

        Order sourceorder=orders.stream()
                .filter(o -> o.getOrderId().equals(sourceorderId)  )
                .findFirst()
                .orElseThrow(() -> new NoSuchElementException("Order not found: " + sourceorderId));

        Order targetorder=orders.stream()
                .filter(o -> o.getOrderId().equals(targetorderId)  )
                .findFirst()
                .orElseThrow(() -> new NoSuchElementException("Order not found: " + targetorderId));

        targetorder.setQuantity(targetorder.getQuantity()+sourceorder.getQuantity());
        List<Entry> targetOps = allOperations.stream()
                .filter(o -> o.getOrderId().equals(targetorderId) )
                .sorted(Comparator.comparing(Entry::getSequence))
                .collect(Collectors.toList());

        for (Entry entry : targetOps) {

            entry.setQuantity(entry.getQuantity()+sourceorder.getQuantity());


        }
        List<Entry> sourceOps = allOperations.stream()
                .filter(o -> o.getOrderId().equals(sourceorderId) )
                .sorted(Comparator.comparing(Entry::getSequence))
                .collect(Collectors.toList());
       int GroupId=0;
        for (Entry entry : sourceOps) {
            GroupId= entry.GroupId;
            OptionalInt index = IntStream.range(0, allOperations.size())
                    .filter(h -> entry.getId()==allOperations.get(h).getId())
                    .findFirst();
            allOperations.remove(index.orElse(0));

            OptionalInt index1 = IntStream.range(0, globalOpList.size())
                    .filter(h -> entry.getId()==globalOpList.get(h).getOp().getId())
                    .findFirst();
            globalOpList.remove(index1.orElse(0));

            chromosome.getMachineSelection().remove(index1.orElse(0));

            OptionalInt OperationIndex = IntStream.range(0, OperationSequencing.size())
                    .filter(i -> OperationSequencing.get(i).equals(entry.GroupId)) // 过滤出值为1的索引
                    .findFirst();
            int targetOpIndex= OperationIndex.getAsInt();
            OperationSequencing.remove(targetOpIndex);

            OptionalInt OperationIndex1 = IntStream.range(0, ScheduleResults.size())
                    .filter(i -> ScheduleResults.get(i).getOperationId()==entry.getId()) // 过滤出值为1的索引
                    .findFirst();

//锁定需要删除
            ScheduleResults.remove(OperationIndex1.getAsInt());

        }
        AtomicInteger globalOpId = new AtomicInteger(0);
        globalOpList.forEach(t-> {

            t.setGlobalOpId(globalOpId.getAndIncrement());

        });
        // chromosome.getOperatRel().remove(GroupId-1);
        orders.remove(sourceorder);
        redecode(chromosome, chromosome.getBaseTime(), globalParam);
    }
    public void LockOperation(Chromosome chromosome,int opId, boolean isLocked, GlobalParam globalParam)
    {
        GAScheduleResult targetResult = chromosome.getResult().stream()
                .filter(r -> r.getOperationId() == opId)
                .findFirst()
                .orElseThrow(() -> new NoSuchElementException("Operation not found: " + opId));

        targetResult.setIsLocked(isLocked);

        // 若解锁，重新解码受影响工序
        if (!isLocked)
        {
            redecode(chromosome, chromosome.getBaseTime(), globalParam);
        }
    }

    public void DelOperation(Chromosome chromosome, int opId, GlobalParam globalParam) {

        List<Entry> allOperations = chromosome.getAllOperations();

        List<GroupResult> OperatRels = chromosome.getOperatRel();

        OperatRels = IdGroupingWithDualSerial.deleteNodeByGlobalSerial(OperatRels, opId);
        chromosome.setOperatRel(OperatRels);
        Entry targetOp = allOperations.stream()
                .filter(o -> o.getId() == opId)
                .findFirst()
                .orElseThrow(() -> new NoSuchElementException("Operation not found: " + opId));


        List<Entry> entrys = allOperations.stream()
                .filter(o -> o.GroupId == targetOp.GroupId)
                .collect(Collectors.toList());
        //当前组的
        GroupResult groupResult = OperatRels.get(targetOp.GroupId-1);
        List<NodeInfo> nodeInfoList = groupResult.getNodeInfoList();

        List<GlobalOperationInfo> globalOpList = chromosome.getGlobalOpList();

        nodeInfoList = groupResult.getNodeInfoList();
        for (Entry entry : entrys) {
            NodeInfo node = nodeInfoList.stream()
                    .filter(o -> o.getGlobalSerial() == entry.getId())
                    .findFirst()
                    .orElse(null);
            if(node!=null)
            {
                entry.setSequence(node.getGroupSerial());
              //  entry.setPrevEntryIds(node.getNewParentIds());
              //  entry.setNextEntryIds(node.getNewChildIds());
                if(node.getNewParentIds()!=null)
                {
                    List<OperationDependency> OperationDependency=new ArrayList<>();
                    for (int id : node.getNewParentIds()) {
                        OperationDependency od=new OperationDependency();
                        od.setPrevOperationId(id);
                        OperationDependency.add(od);
                    }
                    entry.setPrevEntryIds(OperationDependency);
                }
                if(node.getNewChildIds()!=null)
                {
                    List<OperationDependency> OperationDependency=new ArrayList<>();
                    for (int id : node.getNewChildIds()) {
                        OperationDependency od=new OperationDependency();
                        od.setNextOperationId(id);
                        OperationDependency.add(od);
                    }
                    entry.setNextEntryIds(OperationDependency);
                }
                GlobalOperationInfo info= chromosome.getGlobalOpList().stream()
                        .filter(t->t.getOp().getId()==entry.getId())
                        .findFirst()
                        .orElse(null);

                if(info!=null) {
                    info.setSequence(node.getGroupSerial());
                    info.setOp(entry);
                }



            }else {
                if(entry.getMainId()!=null&&!entry.getMainId().equals("")) {
                    //拆分的工序数量补齐到其他的

                    Entry main = entrys.stream().
                            filter(t -> t.MainId.equals(entry.getMainId()) &&t.getId()!=entry.getId())
                            .findFirst()
                            .orElse(null);
                    if (main != null) {
                        main.setQuantity(main.getQuantity() + entry.getQuantity());

                        GlobalOperationInfo operationInfo= globalOpList.stream()
                                .filter(i -> i.getOp().getId() == main.getId())
                                .findFirst()
                                .orElseThrow(() -> new NoSuchElementException("Global operation not found: " + entry.getId()));
                        operationInfo.setOp(main);
                    }
                }

            }
        }
        List<Integer> OperationSequencing=  chromosome.getOperationSequencing();

        OptionalInt OperationIndex = IntStream.range(0, OperationSequencing.size())
                .filter(i -> OperationSequencing.get(i).equals(targetOp.GroupId)) // 过滤出值为1的索引
                .skip(targetOp.Sequence-1) // 跳过第一个匹配项
                .findFirst();
        chromosome.getOperationSequencing().remove(OperationIndex.getAsInt());



        int globalOpIndex = IntStream.range(0, globalOpList.size())
                .filter(i -> globalOpList.get(i).getOp().getId() == opId)
                .findFirst()
                .orElseThrow(() -> new NoSuchElementException("Global operation not found: " + opId));


        chromosome.getMachineSelection().remove(globalOpIndex);
        globalOpList.remove(globalOpIndex);


        AtomicInteger globalOpId = new AtomicInteger(0);
        globalOpList.forEach(t-> {

        t.setGlobalOpId(globalOpId.getAndIncrement());

        });


        List<Entry> operations = chromosome.getAllOperations();

        IntStream.range(0, operations.size())
                .filter(i -> operations.get(i).getId() == opId)
                .findFirst()
                .ifPresent(operations::remove);

        List<GAScheduleResult> results = chromosome.getResult();

        IntStream.range(0, results.size())
                .filter(i -> results.get(i).getOperationId() == opId)
                .findFirst()
                .ifPresent(results::remove);

        redecode(chromosome, chromosome.getBaseTime(), globalParam);

    }

    public void DelOrder(Chromosome chromosome, String orderId, GlobalParam globalParam) {
        List<Entry> allOperations = chromosome.getAllOperations();
        List<GlobalOperationInfo> globalOpList=  chromosome.getGlobalOpList();
        List<Order> orders = chromosome.getOrders();
        List<Integer> OperationSequencing=  chromosome.getOperationSequencing();
        List<GAScheduleResult> ScheduleResults = chromosome.getResult();
        Order sourceorder=orders.stream()
                .filter(o -> o.getOrderId().equals(orderId)  )
                .findFirst()
                .orElseThrow(() -> new NoSuchElementException("Order not found: " + orderId));

        List<Entry> sourceOps = allOperations.stream()
                .filter(o -> o.getOrderId().equals(orderId) )
                .sorted(Comparator.comparing(Entry::getSequence))
                .collect(Collectors.toList());
        int GroupId=0;
        for (Entry entry : sourceOps) {
            GroupId= entry.GroupId;
            OptionalInt index = IntStream.range(0, allOperations.size())
                    .filter(h -> entry.getId()==allOperations.get(h).getId())
                    .findFirst();
            allOperations.remove(index.orElse(0));

            OptionalInt index1 = IntStream.range(0, globalOpList.size())
                    .filter(h -> entry.getId()==globalOpList.get(h).getOp().getId())
                    .findFirst();
            globalOpList.remove(index1.orElse(0));

            chromosome.getMachineSelection().remove(index1.orElse(0));

            OptionalInt OperationIndex = IntStream.range(0, OperationSequencing.size())
                    .filter(i -> OperationSequencing.get(i).equals(entry.GroupId)) // 过滤出值为1的索引
                    .findFirst();
            int targetOpIndex= OperationIndex.getAsInt();
            OperationSequencing.remove(targetOpIndex);

            OptionalInt OperationIndex1 = IntStream.range(0, ScheduleResults.size())
                    .filter(i -> ScheduleResults.get(i).getOperationId()==entry.getId()) // 过滤出值为1的索引
                    .findFirst();

//锁定需要删除
            ScheduleResults.remove(OperationIndex1.getAsInt());

        }


        AtomicInteger globalOpId = new AtomicInteger(0);
        globalOpList.forEach(t-> {

            t.setGlobalOpId(globalOpId.getAndIncrement());

        });

        // chromosome.getOperatRel().remove(GroupId-1);
        orders.remove(sourceorder);
        redecode(chromosome, chromosome.getBaseTime(), globalParam);

    }


    /**
     * 重新解码
     * @param chromosome 原方案
     * @param baseTime 基础时间
     * @param globalParam 全局参数
     */
    public void redecode(Chromosome chromosome,LocalDateTime baseTime, GlobalParam globalParam)
    {
        MachineSchedulerService machineScheduler = new MachineSchedulerService(baseTime);
        chromosome.setMachines(ProductionDeepCopyUtil.deepCopyList(chromosome.getInitMachines(),Machine.class) );

        GeneticDecoder decoder = new GeneticDecoder(globalParam,baseTime, chromosome.getMachines(),
                chromosome.getOrders(), null, machineScheduler,chromosome.getOrderMaterials());
        chromosome.setResultOld(ProductionDeepCopyUtil.deepCopyList(chromosome.getResult(),GAScheduleResult.class));

        chromosome.getResult().clear();
        CopyOnWriteArrayList<GAScheduleResult> Resultlock= chromosome.getResult().stream()
                .filter(o -> o.isIsLocked() == true)
                .collect(Collectors.toCollection(CopyOnWriteArrayList::new));
        chromosome.setResult(ProductionDeepCopyUtil.deepCopyList(Resultlock,GAScheduleResult.class));


        decoder.decode(chromosome);

        KpiCalculator kpiCalculator=new KpiCalculator(chromosome);
        kpiCalculator.calculatekpi();

//        if(chromosome.getWeightedObjective()==0) {
//
//            double[] normalized = objectiveWeights.normalizeObjectives(chromosome.getObjectives(), null, null);
//            if (objectiveWeights.isPureNSGAIIMode()) {
//                chromosome.setWeightedObjective(objectiveWeights.calculateObjective(normalized));
//            } else {
//                chromosome.setWeightedObjective(objectiveWeights.calculateWeightedObjective(normalized));
//            }
//        }

//        if(chromosome.getFitness()==0) {
//            FitnessCalculator fitnessCalc = new FitnessCalculator();
//            chromosome.setFitness(fitnessCalc.calculateFitness(chromosome));
//        }

    }
}
