package com.aps.controller;

import com.aps.entity.MaterialInfo;
import com.aps.service.MaterialInfoService;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 物料主数据表 前端控制器
 * </p>
 *
 * @author yourName
 * @since 2025-09-25
 */
@RestController
@RequestMapping("/materialInfo")
@Tag(name = "test", description = "物料信息相关接口")
public class MaterialInfoController {

    @Autowired
    MaterialInfoService  materialInfoService;
    
    @Operation(summary = "获取单个物料信息", description = "返回第一个物料数据")
    @GetMapping("/test")
    public MaterialInfo test(){
        List<MaterialInfo> list = materialInfoService.list();
        
        // 检查列表是否为空，避免IndexOutOfBoundsException
        if (list == null || list.isEmpty()) {
            return null; // 自定义异常
        }

        return list.get(0);
    }



}