package com.aps.entity.Gantt;

import com.aps.entity.Equipinfo;
import com.aps.entity.ScheduledTask;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.ibatis.type.Alias;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author jvs
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@Schema(name = "排产结果可视化——资源任务甘特图", description = "排产结果可视化——资源任务甘特图")
@Alias("PlanResourceTaskGanttVO")
public class PlanResourceTaskGanttVO  {

    @Schema(description = "任务计划最早开始时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime earliestTaskStartTime;

    @Schema(description = "最近任务派工截止时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime lastTaskAssignmentTime;

    @Schema(description = "资源集合")
    private List<SimpleEquipinfo> resources;

    @Schema(description = "任务集合")
    private List<ScheduledTask> tasks;
}