// MachineSchedulerController.java
package com.aps.controller.plan;

import com.aps.common.util.R;
import com.aps.entity.Schedule.PlanResourceTaskGanttVO;
import com.aps.service.plan.PlanSchedulerService;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@RestController
@RequestMapping("/gantt")
@Tag(name = "机器调度管理", description = "机器调度相关API")
public class PlanSchedulerController {
    
    @Autowired
    private PlanSchedulerService schedulingService;

    @GetMapping("/scheduleresource")
    @Operation(summary = "执行机器调度", description = "执行机器调度并返回甘特图数据")
    @ApiResponses({
        @ApiResponse(responseCode = "200", description = "成功返回调度结果")
    })
    public R<List<PlanResourceTaskGanttVO>> runScheduling() {
        List<PlanResourceTaskGanttVO> execute = schedulingService.execute();
        return R.ok(execute);
    }
    
    @GetMapping("/health")
    @Operation(summary = "健康检查", description = "检查服务是否正常运行")
    @ApiResponses({
        @ApiResponse(responseCode = "200", description = "服务正常运行")
    })
    public String healthCheck() {
        return "Machine Scheduler Service is running!";
    }
}