package com.aps.service.impl;

import com.aps.entity.ProdEquipSpecialCal;
import com.aps.entity.EquipCapacityDef;
import com.aps.mapper.ProdEquipSpecialCalMapper;
import com.aps.service.ProdEquipSpecialCalService;
import com.aps.service.EquipCapacityDefService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;



/**
 * <p>
 * 设备特殊日历配置表：记录特定工位/设备在指定时间段的特殊日历规则（如节假日、维护期等） 服务实现类
 * </p>
 *
 * @author MyBatis-Plus
 * @since 2025-11-26
 */
@Service
public class ProdEquipSpecialCalServiceImpl extends ServiceImpl<ProdEquipSpecialCalMapper, ProdEquipSpecialCal> implements ProdEquipSpecialCalService {

    @Autowired
    private EquipCapacityDefService equipCapacityDefService;

    /**
     * 从EquipCapacityDef表中复制is_deleted为0的数据到ProdEquipSpecialCal表
     */
    @Override
    public void copyFromEquipCapacityDef(String sceneId) {
        // 查询EquipCapacityDef表中is_deleted为0的所有记录
        List<EquipCapacityDef> capacityDefs = equipCapacityDefService.list();
        
        // 过滤出is_deleted为0的记录
        List<EquipCapacityDef> activeCapacityDefs = capacityDefs.stream()
                .filter(e -> e.getIsDeleted() != null && e.getIsDeleted() == 0 && e.getReferenceId() != null)
                .collect(Collectors.toList());
        
        // 转换对象并设置必要字段

        List<ProdEquipSpecialCal> specialCals = activeCapacityDefs.stream()
                .map(capacityDef -> convertToProdEquipSpecialCal(capacityDef, sceneId))
                .collect(Collectors.toList());
        
        // 批量保存到ProdEquipSpecialCal表
        if (!specialCals.isEmpty()) {
            this.saveBatch(specialCals);
        }
    }


    /**
     * 将EquipCapacityDef转换为ProdEquipSpecialCal
     * @param capacityDef 源对象
     * @return 转换后的对象
     */
    private ProdEquipSpecialCal convertToProdEquipSpecialCal(EquipCapacityDef capacityDef,String sceneId) {
        ProdEquipSpecialCal specialCal = new ProdEquipSpecialCal();
        
        // 设置特定字段
        specialCal.setEquipId(capacityDef.getEquipId() != null ? (int)capacityDef.getEquipId() : null);
        specialCal.setEquipCode(capacityDef.getEquipCode());
        specialCal.setStartDate(capacityDef.getEffectiveStartTime());
        specialCal.setEndDate(capacityDef.getEffectiveEndTime());
        specialCal.setEfficiencyCoeff(capacityDef.getEfficiencyCoeff() != null ? 
                      capacityDef.getEfficiencyCoeff().longValue() : null);
        specialCal.setReferenceId(capacityDef.getReferenceId());
        specialCal.setReferenceName(capacityDef.getReferenceName());
        specialCal.setCreatorUserId(capacityDef.getCreatorUserId());
        specialCal.setCreationTime(LocalDateTime.now());
        specialCal.setSceneId(sceneId);
        return specialCal;
    }
}