package com.aps.entity;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class ProdProcessExec {
private String execId;
private String sceneId;
private String orderId;
private String routingDetailId;
private String taskSeq;
private String routingDetailName;
private Long machineId;
private String resourceGroup;
private BigDecimal planQty;
private BigDecimal actualQty;
private Long planDuration;
private Long usedDuration;
private Long remainDuration;
private String processStatus;
private Long standardCapacity;
private Long minCapacity;
private Long maxCapacity;
private Long prepDuration;
private Long changeDuration;
private Short logicalOrder;
private LocalDateTime targetStartDate;
private LocalDateTime targetEndDate;

    /**
     * 工序准备工时（小时）
     * 注释: 工序准备工时
     */

    private BigDecimal setupTime;

    /**
     * 换线时间（小时）
     * 注释: 换线时间
     */

    private BigDecimal changeLineTime;

    /**
     * 常数时间
     * 注释: 常数时间
     */

    private BigDecimal constTime;

    /**
     * 前处理时间（秒）
     * 注释: 前处理时间（秒）
     */

    private Long preprocessingTime;

    /**
     * 后处理时间（秒）
     * 注释: 后处理时间（秒）
     */

    private Long postprocessingTime;

    //速度
    private BigDecimal speed;
}