package com.aps.service.Algorithm;

import com.aps.common.util.DateTimeUtil;
import com.aps.common.util.DeepCopyUtil;
import com.aps.common.util.FileHelper;
import com.aps.common.util.ProductionDeepCopyUtil;
import com.aps.entity.Algorithm.*;
import com.aps.entity.Algorithm.IDAndChildID.GroupResult;
import com.aps.entity.basic.*;
import com.aps.service.plan.MachineSchedulerService;
import org.springframework.beans.factory.annotation.Autowired;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 作者：佟礼
 * 时间：2025-11-21
 */

public class GeneticAlgorithm {
    private final Random rnd = new Random();
    private final List<Machine> machines;
    private final MachineSchedulerService machineScheduler;
    private final List<Order> orders;
    private final List<Material> materials;
    private static GlobalParam _GlobalParam;
    private  List<GroupResult> _entryRel;

    FitnessCalculator _fitnessCalculator = new FitnessCalculator();

    private NSGAIIUtils _nsgaIIUtils = new NSGAIIUtils();

    private ObjectiveWeights _objectiveWeights = new ObjectiveWeights();


    private MaterialRequirementService materialRequirementService;

    private List<OrderMaterialRequirement> orderMaterials;

    public GeneticAlgorithm(GlobalParam globalParam,List<Machine> machines, List<Order> orders,
                                List<Material> materials, MachineSchedulerService machineScheduler,List<GroupResult> entryRel,MaterialRequirementService _materialRequirementService) {
        this.machines = machines;
        this.orders = orders;
        this.materials = materials;
        this.machineScheduler = machineScheduler;
        _GlobalParam=globalParam;
        _entryRel=entryRel;
        materialRequirementService=_materialRequirementService;

    }

    public void Init(double[] customWeights, boolean pureNSGAIIMode) {
        // 自定义权重配置
        if (customWeights != null && customWeights.length == 5)
        {
            _objectiveWeights.setWeights(customWeights);
            _objectiveWeights.setPureNSGAIIMode(pureNSGAIIMode);
        }
        _nsgaIIUtils.init(_objectiveWeights);
    }

    public Chromosome Run(ScheduleParams param, List<Entry> allOperations) {

        if(allOperations==null||allOperations.size()==0)
        {
            throw new RuntimeException("没有待排产工单");
        }

        if(materials!=null&&materials.size()>0) {
            materialRequirementService.init(materials, orders, allOperations, _entryRel, machineScheduler, machines,_GlobalParam);

            orderMaterials = materialRequirementService.buildMultiLevelRequirementNetwork(param.getBaseTime());
        }
        LocalDateTime starttime=LocalDateTime.now();
        FileHelper.writeLogFile("排产-----------开始-----------"+allOperations.get(0).getSceneId());

        Initialization initialization = new Initialization(_GlobalParam,allOperations,orders,machines,_objectiveWeights);

        GeneticOperations geneticOps = new GeneticOperations(_GlobalParam,allOperations,param);

        // 预生成全局工序列表（所有初始化方法共享同一顺序）
        List<GlobalOperationInfo> globalOpList = initialization.generateGlobalOpList();
        FileHelper.writeLogFile("初始化种群-----------开始-------");

        // 步骤1：初始化种群
        List<Chromosome> population = initialization.generateInitialPopulation(param, globalOpList);


            population= chromosomeDistinct(population);



        FileHelper.writeLogFile("初始化种群-----------结束-------");
        FileHelper.writeLogFile("初始化批量解码-----------开始-------");
        Chromosomedecode(param,allOperations,globalOpList,population);
        FileHelper.writeLogFile("初始化批量解码-----------结束-------");
        List<List<Chromosome>> fronts = _nsgaIIUtils.parallelFastNonDominatedSort(population);
        int ordercount = globalOpList.stream()
                .mapToInt(GlobalOperationInfo::getGroupId)
                .max()
                .orElse(0);
        Chromosome best=GetBest(fronts,"初始");

//        best=fronts.get(0).stream()
//                .max(Comparator.comparingDouble(Chromosome::getFitness))
//                .orElse(null);

        double bestFitness=best.getFitness();
        int Iteration=0;
        // 步骤2：迭代进化
        FileHelper.writeLogFile("迭代进化-----------开始-------"+param.getMaxIterations());
        for (int iter = 0; iter < param.getMaxIterations(); iter++) {
            // 解码并计算适应度
            FileHelper.writeLogFile("迭代进化------"+iter+"-----开始-------");


            // 计算种群适应度标准差，微调参数
            double fitnessStd = _fitnessCalculator.calculateFitnessStd(population);
            param.fineTuneParams(iter, fitnessStd);


            // 检查终止条件（此处简化为迭代次数）
            if (iter == param.getMaxIterations() - 1) {
                break;
            }
            FileHelper.writeLogFile("选择操作-----------开始-------");

            // 选择操作
            List<Chromosome> selected = geneticOps.tournamentSelection(population);
            FileHelper.writeLogFile("选择操作-----------结束-------");
            // 交叉操作
            FileHelper.writeLogFile("交叉操作-----------开始-------");

            List<Chromosome> nextPopulation = new ArrayList<>();
            for (int i = 0; i < selected.size(); i += 2) {
                if (i + 1 >= selected.size()) {
                    nextPopulation.add(selected.get(i));
                    break;
                }

                Chromosome parent1 = selected.get(i);
                Chromosome parent2 = selected.get(i + 1);
                if (rnd.nextDouble() < param.getCrossoverProb()) {
                    // 假设PoxCrossover返回包含两个子染色体的数组
                    Pair<Chromosome, Chromosome> children = geneticOps.poxCrossover(parent1, parent2, ordercount);
                    nextPopulation.add(children.getFirst());
                    nextPopulation.add(children.getSecond());
                } else {
                    nextPopulation.add(parent1);
                    nextPopulation.add(parent2);
                }
            }
            FileHelper.writeLogFile("交叉操作-----------结束-------");
            FileHelper.writeLogFile("变异操作-----------开始-------");
            // 变异操作
            List<Chromosome> nextPopulation1 = new ArrayList<>();
            for (Chromosome chromosome : nextPopulation) {
                if (rnd.nextDouble() < param.getMutationProb()) {
                    Chromosome chromosome1=  ProductionDeepCopyUtil.deepCopy(chromosome,Chromosome.class);
                    geneticOps.mutate(chromosome1, globalOpList);
                    nextPopulation1.add(chromosome1);
                }
            }
            nextPopulation.addAll(nextPopulation1);
            FileHelper.writeLogFile("变异操作-----------结束-------");
            FileHelper.writeLogFile("变异批量解码-----------开始-------");


            nextPopulation= chromosomeDistinct(nextPopulation);
            Chromosomedecode(param,allOperations,globalOpList,nextPopulation);
            FileHelper.writeLogFile("变异批量解码-----------开始-------");
//            // 精英保留
//            List<Chromosome> population1 = population.stream()
//                    .sorted((c1, c2) -> Double.compare(c2.getFitness(), c1.getFitness()))
//                    .collect(Collectors.toList()); // 降序排序
//
//
//            List<Chromosome>   elites = population1.subList(0, param.getElitismCount());

            List<Chromosome> newPopulation = new ArrayList<>();
            newPopulation.addAll(population);
            newPopulation.addAll(nextPopulation);
            newPopulation= chromosomeDistinct(newPopulation);
            FileHelper.writeLogFile("非支配排序-----------开始-------");
            // 2.7 非支配排序
            List<List<Chromosome>> combinedFronts = _nsgaIIUtils.parallelFastNonDominatedSort(newPopulation);
            FileHelper.writeLogFile("非支配排序-----------结束-------");
            // 2.8 选择下一代种群
            population = _nsgaIIUtils.selectNextPopulation(combinedFronts, param.getPopulationSize());
            // 更新种群
//            population = newPopulation.stream()
//                    .limit(param.getPopulationSize() )
//                    .collect(Collectors.toList());


            best= GetBest(combinedFronts,String.valueOf(iter));
            if(bestFitness<best.getFitness())
            {

                bestFitness=best.getFitness();


                Iteration=1;
            }else {

                Iteration++;
            }
            if(Iteration>5)
            {
                break;
            }
            FileHelper.writeLogFile("迭代进化------"+iter+"-----结束-------");

        }

        FileHelper.writeLogFile("迭代进化-----------结束-------");
        best.setBaseTime(param.getBaseTime());

        best.setOrderMaterials(orderMaterials);
        best.setOperatRel(_entryRel);

        LocalDateTime endtime=LocalDateTime.now();

        FileHelper.writeLogFile(String.format("排产-----------结束---%s----耗时%d----",allOperations.get(0).getSceneId(),DateTimeUtil.diffDuration(starttime,endtime).getSeconds()) );

        // 步骤3：返回最优解
        return best;

    }

    private Chromosome GetBest(List<List<Chromosome>> fronts,String msg)
    {
        WriteKpis(fronts,msg);
        List<Chromosome> fChromosomes= fronts.get(0);
        fChromosomes.sort((c1, c2) -> {
            int rankCompare = Double.compare(c1.getCrowdingDistance(), c2.getCrowdingDistance());
            return rankCompare != 0 ? rankCompare : Double.compare(c1.getFitness(), c2.getFitness());
        });
        Chromosome best=fChromosomes.get(0);
        WriteKpi(best,"最大");
        return best;
    }

    private List<Chromosome> chromosomeDistinct(List<Chromosome> population)
    {
        if(orders.size()<10)
        {
            population = population.stream()
                    .collect(Collectors.toMap(
                            Chromosome::getGeneStr, // key：去重的字段（GeneStr）
                            u -> u,        // value：Chromosome对象
                            (u1, u2) -> u1 // 重复时保留第一个元素
                    ))
                    .values() // 获取去重后的
                    .stream()
                    .collect(Collectors.toList());
        }
        return  population;
    }

    private void  WriteKpis(List<List<Chromosome>> fronts,String index) {
        for (int i=0;i<fronts.size();i++)
        {
            FileHelper.writeLogFile(String.format("KPI---%s--------%d----",index,i));

            for (Chromosome chromosome:fronts.get(i)) {
                WriteKpi(chromosome,"");
            }
        }
    }

    private void  WriteKpi(Chromosome chromosome,String desc)
    {
        FileHelper.writeLogFile(String.format("KPI---%f----%f----%s----%s",chromosome.getWeightedObjective(),chromosome.getFitness(), chromosome.getID(),desc));
        for (double d: chromosome.getObjectives()) {
            FileHelper.writeLogFile(String.format("    KPI---%f-------",d));
        }
    }

    private  void  Chromosomedecode(ScheduleParams param, List<Entry> allOperations,List<GlobalOperationInfo> globalOpList,List<Chromosome> population)
    {
        GeneticDecoder decoder = new GeneticDecoder(_GlobalParam, param.getBaseTime(), machines, orders, materials, machineScheduler,orderMaterials);

        if(population!=null&&population.size()>0) {
            population.parallelStream().forEach(chromosome -> {
                chromosome.setResult(new ArrayList<>());

                // 假设Machine类有拷贝方法，或使用MapStruct等工具进行映射
                chromosome.setMachines(ProductionDeepCopyUtil.deepCopyList(machines)); // 简单拷贝，实际可能需要深拷贝
                chromosome.setAllOperations(allOperations); // 简单拷贝，实际可能需要深拷贝
                chromosome.setGlobalOpList(globalOpList); // 简单拷贝，实际可能需要深拷贝
                //chromosome.setObjectiveWeights(_objectiveWeights);
                 decoder.decodeChromosomeWithCache(chromosome);
                if (chromosome.getFitness() == 0) {
                    chromosome.setFitness(_fitnessCalculator.calculateFitness(chromosome,_objectiveWeights));
                }
            });


        }
    }

}
