package com.aps.service.Algorithm;

import com.aps.entity.Algorithm.Chromosome;

/**
 * 作者：佟礼
 * 时间：2025-11-24
 */
public class FitnessCalculator {
    /**
     * 多目标适应度计算（加权求和）
     */
    public double calculateFitness(Chromosome chromosome) {
        // 权重可根据实际需求调整
        double w1 = 0.3; // 最早完工时间（越小越好，归一化后取反）
        double w2 = 0.2; // 总流程时间（越小越好）
        double w3 = 0.15; // 总换型时间（越小越好）
        double w4 = 0.2; // 机器负载均衡（标准差越小越好）
        double w5 = 0.15; // 交付期延迟（越小越好）

        // 归一化（假设最大可能值，实际应根据问题规模调整）
        double normMakespan =1/ (1 +(double) chromosome.getMakespan());
        double normFlowTime = 1/ (1 + (double) chromosome.getTotalFlowTime() );
        double normChangeover = 1/ (1 + (double) chromosome.getTotalChangeoverTime());
        double normLoadStd =  chromosome.getMachineLoadStd();
        double normDelay = 1/ (1 + (double) chromosome.getDelayTime() );

        // 适应度值（越大越好）
        return w1 * normMakespan + w2 * normFlowTime + w3 * normChangeover + w4 * normLoadStd + w5 * normDelay;
    }
}
